BEM.DOM.decl({ block: 'b-online-set-phrases-prices', modName: 'type', modVal: 'performance' }, {
    /**
     * Обновляет поле price_cpc|price_cpa в моделях dm-feed-filter введённым значением
     * @param {Object} data - параметры конструктора ставок
     * @override
     * @private
     */
    _updatePrices: function(data) {
        var value = data.price_performance,
            field = data.performance_type == u.performance.TYPE.CPA ? 'price_cpa' : 'price_cpc';

        u.campOptions.set('price_editor', JSON.stringify(data));

        BEM.MODEL.forEachModel(
            function() {
                this.get('price_change_restricted') || this.set(field, value);
            },
            { name: 'dm-feed-filter' }
        );
    },

    /**
     * Инициализирует блоки фильтров и их контролы
     * @override
     * @returns {BEM.DOM}
     */
    _initGroupControls: function() {
        return BEM.blocks['b-groups-list'].initDynamicMediaFilters();
    },

    /**
     * Выбирает только нужные поля из предложенных в передаваемом объекте данных
     * @param {Object} data
     * @override
     * @returns {Object}
     */
    _filterData: function(data) {
        return u._.pick(data, ['price_performance', 'performance_type']);
    }
});
