block('b-online-set-phrases-prices')(
    def()(function() {
        var campaign = this.data.campaign,
            strategy = campaign.strategy,
            OPTIONS = this.data.CAMP_OPTIONS || this.data.campaign.OPTIONS,
            savedData = {},
            hasRarelyUsedGroups,
            minPay = u.currencies.getConst(this.data.campaign.currency, 'BIG_RATE'),
            platform = strategy.name == 'different_places' ?
            this.ctx.showBothPlatforms ?
            'both' :
            strategy.search.name != 'stop' ? OPTIONS.platform || 'search' : 'context' :
            '';

        try {
            savedData = JSON.parse(OPTIONS.price_editor || '{}');
        } catch (e) {
            // DIRECT-41764 договорились что если не удаётся распарсить сохранённый в строке json, то оставляем пустой объект
        }

        savedData.platform = platform;
        savedData.context_scope = savedData.context_scope;

        savedData.is_simple = false;

        hasRarelyUsedGroups = u._.some(this.data.banners, function(banner) {
            return +banner.is_bs_rarely_loaded && banner.phrases.length > 0;
        });

        this.ctx.mods = this.extend(this.ctx.mods || {}, {
            platform: platform
        });

        return applyNext({
            strategy: strategy,
            currency: this.data.campaign.currency,
            savedData: savedData,
            showBothPlatforms: this.ctx.showBothPlatforms,
            hasRarelyUsedGroups: hasRarelyUsedGroups,
            minPay: minPay,
            hasPhrasesWithBsData: this.data.campaign.hasPhrasesWithBsData
        });
    }),

    addJs()(function() {
        return {
            showBothPlatforms: this.ctx.showBothPlatforms,
            modelParams: this.ctx.modelParams,
            hasRarelyUsedGroups: this.hasRarelyUsedGroups,
            hasPhrasesWithBsData: this.hasPhrasesWithBsData
        };
    }),

    content()(function() {
        var campaign = this.data.campaign;

        return [
            {
                elem: 'title',
                mediaType: campaign.mediaType
            },
            {
                elem: 'form-wrapper',
                modelParams: this.ctx.modelParams,
                showBothPlatforms: this.ctx.showBothPlatforms
            }
        ];
    }),

    elem('title').content()(function() {
        var helpId = this.ctx.mediaType === 'mcbanner' ?
            'cost-all-phrases-search' :
            'cost-all-phrases';

        return [
            iget2('b-online-set-phrases-prices', 'set-bid-for-all-phrases', 'Установить ставку для всех фраз на странице'),
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                mix: {
                    block: 'b-online-set-phrases-prices',
                    elem: 'title-help-link'
                },
                stretched: true,
                icon: 'question',
                url: u.getHelpUrl(helpId)
            }
        ];
    }),

    elem('form-wrapper').content()(function() {
        return [
            {
                elem: 'prices-constructors',
                modelParams: this.ctx.modelParams,
                showBothPlatforms: this.ctx.showBothPlatforms
            },
            {
                block: 'button',
                mods: {
                    size: 's',
                    theme: 'action',
                    // от БК не приходят торги (о том как протестировать кейс можно почитать в md)
                    disabled: this.data.campaign.hasPhrasesWithBsData ? '' : 'yes'
                },
                mix: [
                    {
                        block: 'b-online-set-phrases-prices',
                        elem: 'save'
                    },
                    this.hasRarelyUsedGroups && {
                        block: 'b-hintable',
                        mods: {
                            hoverable: 'yes'
                        },
                        js: true
                    }
                ],
                content: iget2('b-online-set-phrases-prices', 'set', 'Назначить')
            },
            { elem: 'spin' }
        ];
    }),

    elem('prices-constructors').replace()(function() {
        var modelParams = this.ctx.modelParams,
            showBothPlatforms = this.ctx.showBothPlatforms;

        if (this.strategy.name === 'different_places') {
            return [
                this.strategy.search.name !== 'stop' && {
                    elem: 'prices-constructor',
                    modelParams: modelParams,
                    formType: 'search',
                    showBothPlatforms: showBothPlatforms
                },
                {
                    elem: 'prices-constructor',
                    modelParams: modelParams,
                    formType: 'context',
                    showBothPlatforms: showBothPlatforms
                }
            ];
        } else {
            return {
                elem: 'prices-constructor',
                modelParams: modelParams,
                formType: 'common',
                showBothPlatforms: showBothPlatforms
            };
        }
    }),

    elem('prices-constructor').replace()(function() {
        var modelParams = this.ctx.modelParams,
            formType = this.ctx.formType;

        return {
            block: 'b-prices-constructor',
            mods: {
                type: this.mods.type
            },
            mix: {
                block: 'b-online-set-phrases-prices',
                elem: 'prices-constructor',
                elemMods: {
                    type: 'wizard',
                    'form-type': formType
                }
            },
            modelParams: {
                id: this.data.campaign.cid,
                parentName: modelParams.name,
                parentId: modelParams.id
            },
            formType: formType,
            isSimple: false,
            savedData: this.savedData,
            strategy: this.data.campaign.strategy,
            currencyName: u.currencies.getName(this.currency),
            minPay: this.minPay,
            currency: this.currency,
            showBothPlatforms: this.ctx.showBothPlatforms
        };
    }),

    elem('spin').replace()(function() {
        return {
            block: 'spin',
            mods: { theme: 'gray-16' },
            mix: { block: 'b-online-set-phrases-prices', elem: 'spin' }
        };
    })
);
