block('b-outboard-controls').mod('save-type', 'ajax')(
    js()(function() {
        return u._.extend({
            cmd: this.ctx.cmd
        }, this.ctx.params)
    }),

    elem('popup').content()(function() {
        return {
            block: 'popup',
            mods: {
                'has-close': 'yes',
                adaptive: 'yes'
            },
            js: { directions: ['bottom'] },
            mix: [{
                block: 'b-outboard-controls',
                elem: 'popup'
            }],
            content: [
                {
                    elem: 'tail'
                },
                {
                    elem: 'content',
                    mix: [{
                        block: 'b-outboard-controls',
                        elem: 'popup-content'
                    }],
                    content: {
                        block: 'b-outboard-controls',
                        mods: this.mods,
                        elem: 'content',
                        header: this.ctx.header,
                        innerBlock: this.ctx.innerBlock,
                        acceptButtonText: this.ctx.acceptButtonText
                    }
                }
            ]
        };
    }),

    elem('content').content()(function() {
        return [
            {
                block: 'b-outboard-controls',
                elem: 'popup-header',
                tag: 'h2',
                content: this.ctx.header || ''
            },
            {
                block: 'b-outboard-controls',
                elem: 'errors'
            },
            {
                block: 'b-outboard-controls',
                elem: 'popup-center',
                content: this.ctx.innerBlock || {
                    block: 'spin',
                    js: true,
                    mix: [{
                        block: 'b-outboard-controls',
                        elem: 'spin'
                    }],
                    mods: {
                        theme: 'gray-48',
                        progress: 'yes'
                    }
                }
            },
            {
                block: 'b-outboard-controls',
                elem: 'popup-buttons',
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action' },
                        mix: [{
                            block: 'b-outboard-controls',
                            elem: 'accept-button'
                        }],
                        content: this.ctx.acceptButtonText || iget2('b-outboard-controls', 'sohranit', 'Сохранить')
                    },
                    {
                        block: 'button',
                        mix: [{
                            block: 'b-outboard-controls',
                            elem: 'decline-button'
                        }],
                        content: iget2('b-outboard-controls', 'otmena', 'Отмена')
                    },
                    {
                        block: 'spin',
                        mix: [{
                            block: 'b-outboard-controls',
                            elem: 'popup-spin'
                        }],
                        mods: { theme: 'gray-16' }
                    }
                ]
            }
        ];
    })
);
