BEM.DOM.decl({ name: 'b-outboard-controls', modName: 'save-type', modVal: 'ajax' }, {

    onSetMod: {

        js: function() {
            this.spin = this.findBlockOn('popup-spin', 'spin');
            this.popupContent = this.elem('content');
            this.errors = this.elem('errors');
            this.__base.apply(this, arguments);

            this._request = BEM.create('i-request_type_ajax', {
                type: 'post',
                url: '/registered/main.pl',
                dataType: 'json',
                cache: false,
                callbackCtx: this
            });

            // Скрываем блок с ошибками при открытии попапа
            this.popup.on('show', function() {
                this.delMod(this.popupContent, 'error');
            }, this);
        },

        disabled: function(modName, modVal) {
            this.spin.setMod('progress', modVal);
            this.acceptButton.forEach(function(btn) {
                btn.setMod('disabled', modVal === 'yes' ? 'yes' : '');
            }, this);
        }

    },

    /**
     * Включает/выключает попап с учётом смены owner
     */
    toggle: function() {
        this.delMod(this.popupContent, 'error');
        this.__base.apply(this, arguments);
    },

    /**
     * Подтверждение изменений
     * @returns {BEM} this
     */
    accept: function() {
        var innerBlockModel = this.getInnerBlock().model,
            validate = innerBlockModel.validate();

        if (validate.valid) {
            this.setMod('disabled', 'yes');

            var data = $.extend(this.params, this.callInnerMethod('provideData'));

            this._request.get(data, function(response) {
                if (response.error) {
                    this.setMod(this.popupContent, 'error', 'yes');
                    this.errors.text(response.error);
                } else {
                    innerBlockModel.fix();
                    this.popup.hide();
                    this.trigger('accept');
                }
                this.setMod('disabled', 'no');
            });
        } else {
            this.setMod(this.popupContent, 'error', 'yes');
            this.errors.html(validate.errors.map(function(error) { return error.text; }).join(', '));
        }

    }
});
