block('b-outboard-controls')(

    elem('popup').content()(function() {
        return {
            block: 'popup',
            mods: {
                'has-close': 'yes',
                autoclosable: this.ctx.autoclosable,
                adaptive: this.ctx.adaptive === 'no' ? undefined : 'yes'
            },
            js: { directions: this.ctx.directions || ['right'] },
            mix: [{
                block: 'b-outboard-controls',
                elem: 'popup'
            }].concat(this.ctx.mix || []),
            content: [
                {
                    elem: 'tail'
                },
                {
                    elem: 'content',
                    mix: [{
                        block: 'b-outboard-controls',
                        elem: 'popup-content'
                    }],
                    content: [
                        this.ctx.header !== false && {
                            block: 'b-outboard-controls',
                            elem: 'popup-header',
                            tag: 'h2',
                            mix: this.ctx.mixes && this.ctx.mixes.header,
                            content: this.ctx.header || ''
                        },
                        this.ctx.hint && {
                            block: 'b-outboard-controls',
                            elem: 'popup-hint',
                            content: this.ctx.hint
                        },
                        {
                            block: 'b-outboard-controls',
                            elem: 'popup-center',
                            mix: this.ctx.mixes && this.ctx.mixes.center,
                            content: this.ctx.innerBlock || {
                                block: 'spin',
                                js: true,
                                mix: [{
                                    block: 'b-outboard-controls',
                                    elem: 'spin'
                                }],
                                mods: {
                                    theme: 'gray-48',
                                    progress: 'yes'
                                }
                            }
                        },
                        this.ctx.buttons !== false && {
                            block: 'b-outboard-controls',
                            mix: this.ctx.mixes && this.ctx.mixes.buttons,
                            elem: 'popup-buttons',
                            content: this.ctx.buttons || [
                                {
                                    block: 'button',
                                    mods: { theme: 'action' },
                                    mix: [{
                                        block: 'b-outboard-controls',
                                        elem: 'accept-button'
                                    }, {
                                        block: 'popup',
                                        elem: 'accept-button'
                                    }],
                                    content: this.ctx.acceptButtonText || iget2('b-outboard-controls', 'sohranit', 'Сохранить')
                                },
                                {
                                    block: 'button',
                                    mix: [{
                                        block: 'b-outboard-controls',
                                        elem: 'decline-button'
                                    }, {
                                        block: 'popup',
                                        elem: 'decline-button'
                                    }],
                                    content: iget2('b-outboard-controls', 'otmena', 'Отмена')
                                }
                            ].concat(this.ctx.controls || [])
                        }
                    ]
                }
            ]
        };
    }),

    elem('switcher').content()(function() {
        return this.ctx.switcher || {
            block: 'button',
            mods: { theme: this.ctx.theme || 'normal' },
            mix: [{
                block: 'b-outboard-controls',
                elem: 'switcher-button'
            }],
            content: this.ctx.switcherText || iget2('b-outboard-controls', 'izmenit', 'изменить')
        };
    })
);
