BEM.DOM.decl({ block: 'b-outboard-controls' }, {

    onSetMod: {
        js: function() {
            this._switcher = this.elem('switcher');

            if (this.params.popupId) {
                this.setPopup(this.__self.getPopup(this.params.popupId));
            } else {
                this.setPopup(this.findBlockOn('popup', 'popup'));
            }

        }
    },

    /**
     * Устанавливает попапом для данного контрола внешний блок (нужно при динамическом создании блоков)
     * Использование b-banner-sitelinks и b-banner-pic
     * @param {BEM} popup
     */
    setPopup: function(popup) {
        this.popup = popup;
        this._initPopup();
    },

    /**
     * Привязывает к попапу события
     * @private
     */
    _initPopup: function() {
        this.acceptButton = this.popup.findBlocksOn('accept-button', 'button');
        //fix DIRECT-39600
        this.acceptButton = this.acceptButton && this.acceptButton.length ?
            this.acceptButton :
            this.findBlocksOn('accept-button', 'button');
        this.acceptButton.forEach(function(btn) {
            btn.on('click', this.accept, this);
        }, this);

        this.declineButton = this.popup.findBlocksOn('decline-button', 'button');
        //fix DIRECT-39600
        this.declineButton = this.declineButton && this.declineButton.length ?
            this.declineButton :
            this.findBlocksOn('decline-button', 'button');
        this.declineButton.forEach(function(btn) {
            btn.on('click', function() {
                this.decline(true);
            }, this);
        }, this);

        var inner = this.getInnerBlock();
        inner && inner.on('state', this._onChangeState, this);

        this.popup.on('show hide', function(e) { this.trigger(e.type); }, this);
        this.popup.on('outside-click', this.decline, this);
        this.popup.bindTo('close', 'pointerclick', this.decline.bind(this));

        // Если есть элемент 'listener' подписываемся на изменение размеров попапа
        this._hasListener() &&
            this.popup.on('show hide', function(e) {
                e.type === 'show' ?
                    this.channel('listener').on('change-height', this._reDraw, this) :
                    this.channel('listener').un('change-height');
            }, this);
    },

    /**
     * Возвращает inner блок
     * @returns {BEM}
     */
    getInnerBlock: function() {
        var innerDom;

        if (this._inner) return this._inner;

        innerDom = this.findElem(this.popup.domElem, 'popup-center').children();

        return this._inner = this.popup.findBlockByInterfaceOn(innerDom, 'i-outboard-controls');
    },

    /**
     * Возвращает признак показанного блока
     * @returns {Boolean}
     */
    isShown: function() {
        return this.popup.isShown();
    },

    /**
     * Подтверждение изменений
     * @returns {BEM} this
     */
    accept: function() {
        this._tryConfirm('confirmAccept', 'provideData').then(function(result) {
            this.popup.hide();
            this.trigger('accept', result);
        }.bind(this));

        return this;
    },

    /**
     * Отмена изменений
     * @param {Boolean} [hidePopup] скрыть попап
     * @returns {BEM} this
     */
    decline: function(hidePopup) {
        this._tryConfirm('confirmDecline', 'declineChange').then(function(result) {
            hidePopup && this.popup.hide();
            this.trigger('decline');
        }.bind(this));

        return this;
    },

    /**
     * Блокирует/разблокирует кнопку свитчера
     * @param {Boolean} isDisabled
     */
    toggleSwitchButton: function(isDisabled) {
        var button = this.findBlockInside(this._switcher, 'button');

        button && button.toggleMod('disabled', 'yes', !!isDisabled);
    },

    /**
     * Вызов метода inner блока
     * @param {String} method
     * @param {Object} [params]
     * @returns {*}
     */
    callInnerMethod: function(method, params) {
        var inner = this.getInnerBlock();

        return inner && inner[method] && $.isFunction(inner[method]) && inner[method](params);
    },

    /**
     * Обработчик изменения state вложенного блока
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onChangeState: function(e, data) {
        if (!data || !this.acceptButton.length) return;

        this.acceptButton.forEach(function(btn) {
            btn.setMod('disabled', data.canSave || data.state == 'valid' ? '' : 'yes');
        });
    },

    /**
     * Устанавливает текст кнопки acceptButton
     * @param {String} text
     * @param {Number} [buttonIdx] индекс кнопки
     */
    setAcceptButtonText: function(text, buttonIdx) {
        this.acceptButton[buttonIdx || 0].setText(text);
    },

    /**
     * Возвращает текст кнопки acceptButton
     * @param {Number} [buttonIdx] индекс кнопки
     */
    getAcceptButtonText: function(buttonIdx) {
        return this.acceptButton[buttonIdx || 0].getText();
    },

    /**
     * Делает кнопку acceptButton неактивной
     * @param {Number} [buttonIdx] индекс кнопки
     */
    disableAcceptButton: function(buttonIdx) {
        this.acceptButton[buttonIdx || 0].setMod('disabled','yes');
    },

    /**
     * Устанавливает текст на переключателе
     * @param {String} text текст
    */
    setSwitcherText: function(text) {
        this.findBlockInside(this._switcher, 'button').setText(text);
    },

    /**
     * Отобразить попап
     * @param {Object} [params] параметры, пробрасываемые в inner блок
     * @param {jQuery} [owner] dom нода, на которой отображать попап
     *
     * @returns {BEM} this
     */
    show: function(params, owner) {
        // если не переданы аргументы, извлекаем параметры по умолчанию
        if (!arguments.length) {
            owner = this.elem('switcher');

            params = this.elemParams(owner).innerBlockParams;
        }

        return this.popup.isShown() ? this : this.toggle(owner, params);
    },

    /**
     * Включает/выключает попап с учётом смены owner
     * @param {jQuery} [owner] dom нода, на которой отображать попап
     * @param {Object} [params] параметры, пробрасываемые в inner блок
     * @returns {BEM} this
     */
    toggle: function(owner, params) {
        var popup = this.popup,
            isShown = popup.isShown(),
            currentOwner = popup._owner,
            ownerHasChanged = (owner && !currentOwner) || //владельца не было
                (owner && currentOwner && currentOwner[0] !== owner[0]); //или владелец был, но другой

        !ownerHasChanged && isShown && this.decline();

        owner || (owner = this._switcher);
        owner instanceof BEM && (owner = owner.domElem);

        this.afterCurrentEvent(function() {
            if (ownerHasChanged || !isShown) {
                this.callInnerMethod('prepareToShow', params);
            }

            // модальное окно не имеет привязки
            popup.hasMod('type', 'modal') ?
                popup.toggle() :
                popup.toggle(owner);
        });

        return this;
    },

    /**
     * Проверяет наличие элемента 'listener'
     * @returns {Boolean}
     * @private
     */
    _hasListener: function() {
        return !!this.elem('listener').length;
    },

    /**
     * Перерисовывает попап с пересчетом его новых размеров
     * @private
     */
    _reDraw: function() {
        this.afterCurrentEvent(function() {
            if (this.popup.isShown()) {
                this.popup.getPopupSize();
                this.popup.repaint();
            }
        });
    },

    /**
     * Пытается вызвать подтверждение, если оно реализовано в inner блоке
     * @param {String} confirmationHandler название метода подтверждения в inner блоке
     * @param {String} actionHandler название метода в inner блоке, вызываемого при подтверждении
     * @returns {*}
     * @private
     */
    _tryConfirm: function(confirmationHandler, actionHandler) {
        return $.Deferred()
            .resolve()
            .then(function() {
                // просим подтверждения (применяется, только если реализовано)
                return this.callInnerMethod(confirmationHandler, this);
            }.bind(this))
            // при ошибках считаем не подтвержденным
            .fail(function() { return false; })
            .then(function(confirmed) {
                // случай по умолчанию для таких вариантов как:
                //  - метода confirmAccept не было или он не вернул boolean
                //  - в confirmAccept использовался resolve без параметров
                typeof confirmed !== 'boolean' && (confirmed = true);

                if (confirmed !== true) return false;

                return this.callInnerMethod(actionHandler);
            }.bind(this))
            .then(function(result) {
                return result === false ?
                    $.Deferred().reject() :
                    result;
            });
    },

    _onSwitcherClick: function(e) {
        var button,
            popup,
            owner,
            currentSwitcher = $(u._.find(this._switcher, function(item) {
                return item.contains(e.target);
            }));

        e.preventDefault();
        owner = this.elemify(currentSwitcher, 'switcher');

        button = this.findBlockInside(owner, 'button');

        if (button && button.hasMod('disabled', 'yes')) return;

        popup = this.popup;

        if (popup.isShown()) {
            this.decline();
        } else {
            this.callInnerMethod('prepareToShow', this.elemParams(owner).innerBlockParams);
        }

        // модальное окно не имеет привязки
        popup.hasMod('type', 'modal') ?
            popup.toggle() :
            popup.toggle(owner);
    }

}, {
    live: function() {
        //init-by-parent  используется в b-banner-sitelinks и, где нужно сначала проинициализировать попап, а потом открывать
        this.liveBindTo('switcher', 'pointerclick', function(e) {
            this._onSwitcherClick(e);
        });
    },

    getPopup: function(popupId) {
        //распределенные блоки в i-bem работают неправильно, если элементы создаются в рабочем цикле
        //создаем попап, доступный из всех блоков данного типа попап, в том числе для блоков
        //созданных в рабочем цикле
        var popupDom = $('#' + popupId);

        return !!popupDom.length && popupDom.bem('b-outboard-controls').popup;
    }
});
