block('b-outdoor-map-preview').mod('type', 'indoor')(

    js()(true),

    content()(function() {
        var regions = this.ctx.selectedByRegions.filter(function(region) {
                return region.items.length > 0;
            }).map(function(region) {
                return {
                    elem: 'region',
                    name: iget2('b-outdoor-map-preview', 'platforms-in-regions-selected', '{regionName}', {
                        regionName: region.name
                    }),
                    items: region.items,
                    screensCount: region.screensCount
                };
            }),
            regionsCount = regions.length;

        return {
            elem: 'regions-list',
            elemMods: { empty: !regionsCount },
            content: regionsCount > 0 ? regions : {
                elem: 'hint',
                content: iget2('b-outdoor-map-preview', 'not-selected', 'Не выбраны')
            }
        }
    }),

    elem('region').content()(function() {
        return [
            {
                elem: 'head',
                content: [
                    {
                        elem: 'head-text',
                        tag: 'span',
                        content: this.ctx.name
                    },
                    {
                        elem: 'head-count',
                        tag: 'span',
                        content: this.ctx.screensCount
                    },
                    {
                        block: 'icon',
                        mix: {
                            block: this.block,
                            elem: 'head-icon'
                        },
                        mods: {
                            type: 'arrow'
                        }
                    }
                ]
            },
            {
                elem: 'content',
                content: this.ctx.items.map(function(item) {
                    return {
                        elem: 'region-row',
                        content: [
                            {
                                elem: 'row-title',
                                content: item.name
                            },
                            {
                                elem: 'row-operator',
                                content: item.operator
                            },
                            {
                                elem: 'row-address',
                                content: u.escapeHTML(item.address)
                            }
                        ]
                    }
                })
            }
        ];
    })
);
