BEM.DOM.decl({ block: 'b-outdoor-map' }, {

    onSetMod: {
        js: function() {
            this.addSpin();

            this.model = BEM.MODEL.getOne(this.params.modelParams);

            BEM.blocks['i-web-api-request'].placements
                .get({
                    ulogin: u.consts('ulogin'),
                    placementType: 'OUTDOOR'
                })
                .then(function(data) {
                    this._formatDictionary(data);
                    this._formatToMapData(data);
                    this._updatePreview();
                    this.removeSpin();
                    this.trigger('initFormats', { formats: this._selectedFormats }, this);
                }.bind(this))
                .catch(function(error) {
                    this.removeSpin();
                });
        }
    },

    addSpin: function() {
        this.findBlockInside(this.elem('switcher'), 'button2').setMod('disabled', 'yes');

        this.spin = $(BEMHTML.apply({
            mix: { block: 'b-outdoor-map', elem: 'spin' },
            block: 'spin',
            mods: { theme: 'gray-16' }
        })).bem('spin');

        BEM.DOM.append(this.elem('switcher-wrap'), this.spin.domElem);

        this.spin.setMod('progress', 'yes');

        return this;
    },

    /**
     * Удаляем спиннер из DOM-дерева
     * @returns {BEM}
     */
    removeSpin: function() {
        this.findBlockInside(this.elem('switcher'), 'button2').delMod('disabled');

        if (!this.spin) return this;

        this.spin.destruct();
        this.spin = null;

        return this;
    },

    _formatDictionary: function(data) {
        var langKey,
            regions = {},
            regionsSortIndex = {
                2: 2,
                213: 1
            };

        switch (BEM.blocks['i-global'].param('locale')) {
            case 'en':
                langKey = 'nameEn';
                break;
            case 'tr':
                langKey = 'nameTr';
                break;
            case 'uk':
                langKey = 'nameUa';
                break;
            case 'ru':
                langKey = 'nameRu';
                break;
            default:
                langKey = 'nameRu';
        }

        u._.keys(data.region_dictionary).reduce(function(result, id) {
            result[id] = {
                id: id,
                regionText: data.region_dictionary[id][langKey],
                sortIndex: regionsSortIndex[id]
            };

            return result;
        }, regions);

        return this._dictionary = {
            zone: data.zone_dictionary,
            facility: data.facility_dictionary,
            region: regions
        };
    },

    _formatToMapData: function(data) {
        var selectedByProvider = this._splitSelectedByProvider(this.params.selected),
            dictionary = this._dictionary,
            formatIdToShapeId = {
                1: 'billboard',
                2: 'super-site',
                3: 'media-f',
                4: 'citi-format'
            },
            facilityDictionary = dictionary.facility || {},
            providers = data.placements.reduce(function(result, provider) {
                if (provider.type === 'OUTDOOR') {
                    result[provider.id] = {
                        providerId: provider.id,
                        name: provider.operatorName,
                        deleted: provider.deleted
                    }
                }

                return result;
            }, {}),
            regions = dictionary.region || {},
            platformsByRegion = data.placement_blocks.reduce(function(result, platform) {
                var size,
                    duration = platform.duration,
                    platformId = platform.blockId && platform.blockId.toString(),
                    providerId = platform.pageId && platform.pageId.toString(),
                    regionId = platform.geoId && platform.geoId.toString(),
                    gid = platform.blockCaption,
                    resolution = [platform.resolution.width, platform.resolution.height].join('×'),
                    format = facilityDictionary[platform.facilityType].charAt(0).toUpperCase() +
                        facilityDictionary[platform.facilityType].slice(1),
                    isSelectedPlatform = u._.isEmpty(selectedByProvider[providerId]) ?
                        false :
                        (selectedByProvider[providerId].indexOf(platformId) !== -1),
                    isDeleted = !!(providers[providerId] && providers[providerId].deleted) || !!platform.deleted,
                    isHidden = !!platform.hidden;

                if (platform.width && platform.height) {
                    size = iget2('b-outdoor-map', 'size', '{size} м', {
                        size: [platform.width, platform.height].join(' × '),
                        context: 'size - размер щита в метрах'
                    });
                }

                if (regionId && platform.coordinates && ((!isDeleted && !isHidden) || isSelectedPlatform)) {
                    if (!result[regionId]) {
                        result[regionId] = {
                            platforms: [],
                            regionId: regionId,
                            regionText: regions[regionId].regionText,
                        }
                    }

                    result[regionId].platforms.push({
                        coordinates: platform.coordinates
                            .split(/,\s?/)
                            .map(function(value) {
                                // DIRECT-96745: Решить проблему с очень близко расположенными щитами
                                return u._.round(value, 5);
                            }),
                        id: [providerId, platformId].join(':'),
                        regionId: regionId,
                        provider: providers[providerId].name,
                        format: format,
                        duration: duration,
                        formatId: formatIdToShapeId[platform.facilityType],
                        resolution: resolution,
                        address: platform.address,
                        transform: platform.direction,
                        caption: [format, size].join(' '),
                        gid: gid
                    });
                }

                return result;
            }, {});

        return this._platformsByRegion =
            u._.keys(platformsByRegion)
                .map(function(id) {
                    return platformsByRegion[id];
                })
                .sort(function(regionA, regionB) {
                    var sortIndexA = regions[regionA.regionId] && regions[regionA.regionId].sortIndex,
                        sortIndexB = regions[regionB.regionId] && regions[regionB.regionId].sortIndex;

                    if (typeof sortIndexB === 'number' && typeof sortIndexA === 'number') {
                        return sortIndexA - sortIndexB;
                    } else {
                        return ((sortIndexA || Number.MAX_SAFE_INTEGER) - (sortIndexB || Number.MAX_SAFE_INTEGER));
                    }
                });
    },

    _selectedFromPopup: null,

    /**
     * Обработчик события save в попапе
     * @param {Object} data
     * @param {Array<number>} data.selected - выбранные
     * @private
     */
    _onPopupSave: function(data) {
        var checkedByRegion = data.checkedByRegion;

        this._selectedFromPopup = checkedByRegion;

        this._updatePreview();

        this.trigger('save', {
            selected: u._.keys(checkedByRegion).reduce(function(result, regionId) {
                return [].concat(
                    result,
                    checkedByRegion[regionId].map(function(platformId) {
                        var id = platformId.split(':');

                        return {
                            pageId: id[0],
                            blockId: id[1]
                        };
                    }));
            }, []),
            formats: this._selectedFormats
        }, this);
    },

    _updatePreview: function() {
        BEM.DOM.replace(this.findElem('preview'), BEMHTML.apply({
            block: 'b-outdoor-map-preview',
            mix: {
                block: 'b-outdoor-map',
                elem: 'preview'
            },
            selectedByRegions: this._getPreviewData()
        }));

    },

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('switcher').is(e.block.domElem) && this._onSwitcherClick(e, data);
    },

    _splitSelectedByProvider: function(selected) {
        var selectedByProvider = {};

        selected.forEach(function(id) {
            id = id.split('-');

            var platformId = id[0],
                providerId = id[1];

            if (!selectedByProvider[providerId]) {
                selectedByProvider[providerId] = [];
            }

            selectedByProvider[providerId].push(platformId);
        });

        return selectedByProvider;
    },

    _getSelected: function() {
        var platformsByRegion = this._platformsByRegion;

        if (this._selectedFromPopup) {
            return this._selectedFromPopup;
        } else {
            return this._selectedFromPopup = (this.params.selected || []).reduce(function(result, id) {
                var regionIndex,
                    platformId,
                    providerId,
                    platform;

                id = id.split('-');
                platformId = id[0];
                providerId = id[1];
                id = [providerId, platformId].join(':');

                for (regionIndex = 0; regionIndex < platformsByRegion.length; regionIndex++) {
                    platform = u._.find(platformsByRegion[regionIndex].platforms, { id: id });

                    if (platform) {
                        result[platform.regionId] || (result[platform.regionId] = []);
                        result[platform.regionId].push(id);
                        break;
                    }
                }

                return result;
            }, {});
        }
    },

    _selectedFormats: null,

    _getPreviewData: function() {
        var selected = this._getSelected(),
            platformsByRegion = this._platformsByRegion,
            _this = this;

        this._selectedFormats = [];

        return u._.keys(selected).reduce(function(result, regionId) {
            var region = u._.find(platformsByRegion, { regionId: regionId });

            result.push({
                name: region.regionText,
                regionId: region.regionId,
                items: selected[regionId].map(function(id) {
                    var platform = u._.find(region.platforms, { id: id });

                    _this._selectedFormats.push({
                        resolution: platform.resolution,
                        duration: platform.duration
                    });

                    return {
                        name: platform.caption,
                        operator: platform.provider,
                        address: platform.address,
                        duration: platform.duration && iget2('b-outdoor-map', 'duration', '{duration} сек.', {
                            duration: platform.duration
                        }),
                        resolution: platform.resolution
                    };
                })
            });

            return result;
        }, []);
    },

    /**
     * Обработчик нажатия на кнопку открытия попапа
     * @private
     */
    _onSwitcherClick: function() {
        var popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator']
                .create({ type: 'outdoor-map-popup', without: 'max-height' }, { bodyScroll: false }),
            subMan = BEM.create('i-subscription-manager'),
            outdoorPopup = popupDecorator
                .setPopupContent({
                    block: 'outdoor-map-popup',
                    js: {
                        platformsByRegion: this._platformsByRegion,
                        selectedByRegion: this._getSelected(),
                        adgroup_id: this.model.get('modelId'),
                        campaign_id: this.model.get('cid'),
                        video_creative_ids: this.model.getBanners().map(function(banner) {
                            return banner.get('creative').get('creative_id');
                        }),
                        isNewGroup: this.model.get('isNewGroup')
                    }
                });

        subMan
            .on(outdoorPopup, 'save', function(e, data) {
                this._onPopupSave(data);
                popupDecorator.hide({ force: true });
            }, this)
            .on(outdoorPopup, 'cancel', function() {
                popupDecorator.hide({ force: true });
            }, this)
            .on(popupDecorator, 'close-blocked', function(e) {
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-experiments-settings', 'close-popup-message', 'Изменения не будут сохранены. Продолжить?'),
                    fromPopup: popupDecorator.getPopup(),
                    onYes: function() {
                        popupDecorator.hide({ force: true });
                    }
                });
            }, this)
            .on(popupDecorator, 'close', function() {
                subMan.dispose();
                subMan.destruct();

                popupDecorator.destruct();
            }, this);

        popupDecorator.show();

        // @skywhale
        // понижаем индекс popup большого директа, что бы не перекрывал popup из DNA
        popupDecorator.getPopup().domElem.css('zIndex', 999);
        popupDecorator.getPopup()._under.css('zIndex', 999);
    }
}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button2', function(e, data) {
            this._onButtonClick(e, data);
        });

        return false;
    }

});
