BEM.DOM.decl({ block: 'b-outdoor-predictor', modName: 'type', modVal: 'indoor' }, {
    // 88px - 40px(отступы по 20 сверху и снизу) и 66px( высота навигации по городам)
    _updatePredictorHeight: function() {
        this.domElem.css('max-height', this.domElem.parent().height() - 106 + 'px');
    },

    _rebuildPredicator: function(view) {
        var isError = this._getPredictor().hasMod('error', 'yes');

        BEM.DOM.update(this.elem('predictor'), BEMHTML.apply({
            block: 'b-crypta-predictor',
            mods: {
                view: view,
                error: isError ? 'yes' : ''
            },
            indoor: true
        }));

        if (isError) {
            this._getPredictor().onReachError(this.lastError);
        }

        if (!this._getPredictor().hasMod('loading', 'yes')) {
            this._updatePredicator(this._lastReach);
        }
    },

    _getReach: function(data) {
        var totalData = Object.assign({}, data),
            deferred = $.Deferred();

        if (!u._.isEmpty(data.page_blocks_region)) {
            totalData.page_blocks = [];
            Object.assign(totalData.page_blocks, data.page_blocks_region);
        }

        delete data.page_blocks_region;
        delete totalData.page_blocks_region;
        totalData.video_creative_ids = [];

        Promise.all([
            BEM.blocks['i-web-api-request'].mediareach.getReachIndoor(u.consts('ulogin'), data),
            BEM.blocks['i-web-api-request'].mediareach.getReachIndoor(u.consts('ulogin'), totalData)
        ])
            .then(function(data) {
                this._updateRequestId(data[0].result.requestId);

                deferred.resolve({
                    of: data[0].result,
                    out: data[1].result
                });
            }.bind(this))
            .catch(function(response) {
                this._lastReach = null;
                this.lastError = response;
                this._getPredictor().onReachError(this.lastError);
                deferred.reject();
            }.bind(this));

        return deferred.promise();
    }
});
