block('b-outdoor-predictor')(

    js()(function() {
        return {
            data: this.ctx.data
        };
    }),

    content()(function() {

        return [
            {
                elem: 'predictor',
                content: [
                    {
                        block: 'b-crypta-predictor',
                        mods: { view: this.mods.view }
                    }
                ]
            },
            {
                block: 'icon',
                mods: { type: 'arrow', size: 's' },
                mix: [
                    { block: this.block, elem: 'icon' }
                ]
            },
            {
                elem: 'summary-wrap',
                content: {
                    elem: 'summary'
                }
            },
            {
                elem: 'copy'
            },
            {
                elem: 'request-id'
            }
        ]
    }),

    elem('summary')(

        content()(function() {

            return [
                {
                    elem: 'summary-title'
                },
                {
                    block: 'crypta-summary-provider',
                    mods: {
                        loading: 'yes'
                    }
                }
            ]
        })
    ),

    elem('summary-title')(

        content()(function() {

            return [
                iget2('b-crypta-inventory', 'group-settings-text', ' Настройки на группу объявлений'),
                {
                    block: 'icon',
                    mods: {
                        'size-13': 'question',
                        theme: 'light'
                    },
                    mix: [
                        {
                            block: 'b-hintable-popup',
                            js: {
                                hint: applyCtx({
                                    block: this.block,
                                    elem: 'help-content',
                                    content: [
                                        iget2('b-outdoor-predictor', 'help-text', 'В списке перечислены настройки группы объявлений, которые учитываются при расчете прогноза: формат выбранных щитов и формат загруженных баннеров, регионы показа.'),
                                        {
                                            block: 'b-help-link',
                                            mods: {
                                                type: 'modal'
                                            },
                                            stretched: true,
                                            url: u.getHelpUrl('cpm-campaign-outdoor-ots-forecast'),
                                            text: iget2('b-outdoor-predictor', 'help-text-link', 'Подробнее об условии показа')

                                        }
                                    ]
                                }),
                                directions: ['bottom']
                            }
                        },
                        {
                            block: 'b-crypta-inventory',
                            elem: 'summary-help'
                        }
                    ]
                }
            ]
        })
    ),

    elem('copy').content()(function() {

        return {
            block: 'button2',
            mix: {
                block: this.block,
                elem: 'copy-button'
            },
            mods: {
                theme: 'clear',
                size: 'xs'
            },
            iconLeft: { mods: { 'size-16': 'copy' } },
            text: iget2('b-crypta-inventory', 'copy-button-text', 'Скопировать в буфер обмена')
        }
    })

)
