/**
 * "Стакан" крипты, содержит в себе прогнозатор аудитории и сводку параметров влияющих на прогноз
 *
 * @param {PredictParams} data - данные для блока
 */
BEM.DOM.decl('b-outdoor-predictor', {

    /**
     * Флаг о готовности
     */
    _isReady: null,

    _isWrapped: true,

    onSetMod: {

        js: function() {
            this._summary = this.blockInside('crypta-summary-provider');

            this._initClipboard();

            this._hideHint = this._hideHint.bind(this);
            this.bindToWin('scroll', this._hideHint);
            this.bindTo('summary-wrap', 'scroll', this._hideHint);

        },

        view: {
            simple: function() {
                this._rebuildPredicator('simple');
            },

            advanced: function() {
                this._rebuildPredicator('advanced');
                this._updateSummary(this._lastSummary);
            }
        },

        'predictor-loading': {

            yes: function() {
                this._getPredictor().setMod('loading', 'yes');
            },

            '': function() {
                this._getPredictor().delMod('loading');
            }

        }

    },

    _getPredictor: function() {
        return this._predictor = this.findBlockInside('b-crypta-predictor');
    },

    /**
     * Обновляет содержимое блока
     * @param {PredictParams} data - данные для блока
     */
    update: function(data, summaryData) {
        if (u._.isEqual(this.params.data, data) ) {
            this.delMod('predictor-loading');

            return;
        }

        if (summaryData) {
            this._updateSummary(this._lastSummary = summaryData);
        }

        this.setMod('predictor-loading', 'yes');

        this._getReach(data)
            .then(function(result) {
                this._updatePredicator(this._lastReach = result);
                this._updatePredictorHeight();
                this.delMod('predictor-loading');
            }.bind(this))
            .fail(function() {
                this._getPredictor().onReachError();
                this._updatePredictorHeight();
            }.bind(this));
    },

    /**
     * Возвращает значение флага
     * @returns {boolean}
     */
    isReady: function() {
        return !!this._isReady;
    },

    /**
     * Обработчик готовности сводки
     */
    _onReadyContent: function() {
        this.delMod('loading');
        this._isReady = true;
        this.trigger('ready');
    },

    /**
     * Обновляет сводку
     * @private
     */
    _updateSummary: function(data) {
        this._summary.update(data);
    },

    _updateRequestId: function(requestId) {
        BEM.DOM.update(this.elem('request-id'), BEMHTML.apply('ID ' + requestId));
    },

    /**
     * Показывает сообщение при удачном копировании в буфер обмена
     * @private
     */
    _showCopiedMessage: function(e) {
        e.clearSelection(); // чтобы в FF не скролилось

        clearTimeout(this._copiedTimeout);

        this._getTipman().show({
            owner: this.elem('copy-button'),
            content: iget2('b-outdoor-predictor', 'copied-text', 'Скопировано')
        });

        this._copiedTimeout = setTimeout(function() {
            this._getTipman().hide();
        }.bind(this), 1000);

    },

    /**
     * Возвращает инстанс блока tipman
     *
     * @returns {BEM.DOM}
     * @private
     */
    _getTipman: function() {
        return this._tipman || (this._tipman = BEM.create('tipman', {
            tipMods: { size: 's', theme: 'normal', autoclosable: 'no' },
            tipJs: { to: ['right'] }
        }));
    },

    // 88px - 40px(отступы по 20 сверху и снизу) и 48px( высота навигации по городам)
    _updatePredictorHeight: function() {
        this.domElem.css('max-height', this.domElem.parent().height() - 88 + 'px');
    },

    /**
     * Прячет подсказку
     * @private
     */
    _hideHint: function() {
        this.blockInside(this.elem('summary-title'), 'b-hintable-popup').hideHint();
    },

    /**
     * Инициализирует работу библиотеки для копирования текста по нажатию на кнопку
     * @private
     */
    _initClipboard: function() {
        this.clipboard = new Clipboard('.b-outdoor-predictor__copy-button', {
            text: function(trigger) {
                return this.findElem('summary')[0].innerText;
            }.bind(this)
        }).on('success', this._showCopiedMessage.bind(this));
    },

    setRegion: function(region) {
        this._currentRegion = region;

        if (this.hasMod('view', 'advanced')) {
            this._getPredictor().updateSelectedRegion(this._currentRegion);
        }
    },

    _rebuildPredicator: function(view) {
        var isError = this._getPredictor().hasMod('error', 'yes');

        BEM.DOM.update(this.elem('predictor'), BEMHTML.apply({
            block: 'b-crypta-predictor',
            mods: {
                view: view,
                error: isError ? 'yes' : ''
            }
        }));

        if (isError) {
            this._getPredictor().onReachError(this.lastError);
        }

        if (view === 'advanced') {
            this._getPredictor().updateSelectedRegion(this._currentRegion);
        }

        if (!this._getPredictor().hasMod('loading', 'yes')) {
            this._updatePredicator(this._lastReach);
        }
    },

    _updatePredicator: function(data) {
        this._getPredictor().update(data);
    },

    _getReach: function(data) {
        var totalData = Object.assign({}, data),
            deferred = $.Deferred();

        if (!u._.isEmpty(data.page_blocks_region)) {
            totalData.page_blocks = [];
            Object.assign(totalData.page_blocks, data.page_blocks_region);
        }

        delete data.page_blocks_region;
        delete totalData.page_blocks_region;
        totalData.video_creative_ids = [];

        Promise.all([
            BEM.blocks['i-web-api-request'].mediareach.getReachOutdoor(u.consts('ulogin'), data),
            BEM.blocks['i-web-api-request'].mediareach.getReachOutdoor(u.consts('ulogin'), totalData)
        ])
            .then(function(data) {
                this._updateRequestId(data[0].result.requestId);

                deferred.resolve({
                    of: data[0].result,
                    out: data[1].result
                });
            }.bind(this))
            .catch(function(response) {
                this._lastReach = null;
                this.lastError = response;
                this._getPredictor().onReachError(this.lastError);
                deferred.reject();
            }.bind(this));

        return deferred.promise();
    },

    destruct: function() {
        this.unbindFromWin('scroll', this._hideHint);
        this.unbindFrom('summary-wrap', 'scroll', this._hideHint);
        this.clipboard.destroy();
        this.__base.apply(this, arguments);
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('ready', 'crypta-summary-provider', function(e, data) {
            this._onReadyContent();
        });

        this.liveBindTo('icon', 'click', function() {
            this.setMod('view', this.hasMod('view', 'simple') ? 'advanced' : 'simple');
        });

        return false;
    }

});
