block('b-overdraft-warning')(

    replace()(function() {
        var ctx = this.ctx,
            data = this.data,
            wallet = ctx.wallet,
            isNdsAvailable = !ctx.wallet.is_fake_nds,
            currentCurrency = ctx.currentCurrency,
            overdraftLimit = wallet.auto_overdraft_lim_without_nds - wallet.debt,
            signOverdraftLimitWithCurrency = overdraftLimit === 0 ? u.currencies.formatSum(
                currentCurrency,
                overdraftLimit
            ) : '- ' + u.currencies.formatSum(
                currentCurrency,
                overdraftLimit
            ),
            warningContent = (isNdsAvailable && overdraftLimit !== 0) ? iget2(
                'b-overdraft-warning',
                'campaigns-stopped',
                'Кампании будут остановлены, когда остаток на счете достигнет {sum} без НДС. Есть непогашенная задолженность.',
                {
                    sum: signOverdraftLimitWithCurrency
                }
            ) : iget2(
                'b-overdraft-warning',
                'campaigns-stopped-no-nds',
                'Кампании будут остановлены, когда остаток на счете достигнет {sum} Есть непогашенная задолженность.',
                {
                    sum: signOverdraftLimitWithCurrency
                }
            );

        if (wallet.auto_overdraft_lim > 0 && wallet.debt > 0 && data.autooverdraft_params.is_banned === '0') {
            return {
                block: 'b-page-warning',
                mix: {
                    block: 'b-overdraft-warning'
                },
                disableClose: true,
                content: {
                    elem: 'warning-content',
                    mix: {
                        block: 'b-overdraft-warning',
                        elem: 'warning-content'
                    },
                    content: [
                        {
                            block: 'b-overdraft-warning',
                            elem: 'icon'
                        },
                        warningContent,
                        {
                            block: 'button2',
                            url: u.formatUrl({
                                host: u.consts('balance'),
                                // todo поправить вызов u.formatUrl на корректную работу с параметрами
                                // (нужно сдвинуть ревизию adv-blocks чтобы u.formatUrl не срезал параметры с нулём)
                                path: '/invoices.xml?date_type=1&receipt_status=0&payment_type=1' +
                                (data.login_rights.role.match(/manager|support|superreader|super/) ?
                                    '&client_id=' + ctx.wallet.clientID :
                                    '')
                            }),
                            mods: { theme: 'pseudo', size: 's', type: 'link' },
                            mix: { block: 'b-overdraft-warning', elem: 'details-button' },
                            text: iget2('b-overdraft-warning', 'details', 'Погасить')
                        }
                    ]
                }
            };
        }
    })
);
