block('b-overdraft')(

    def()(function() {
        var data = this.data,
            clientRest = data.overdraft_rest && data.overdraft_rest > 0,
            clientDebt = data.debt && data.debt > 0,
            clientDiscount = data.discount && +data.discount > 0,
            clientBalance = data.client_role == 'client' && (clientRest || clientDebt),
            overdraftContent = clientDiscount || clientBalance;

        this.ctx.mods = this.extend(this.ctx.mods || {}, {
            debt: data.dateFlag == 'Past' ? 'past' : '',
            discount: clientDiscount ? 'yes' : ''
        });

        if (clientRest || clientDebt || clientDiscount || clientDiscount || clientBalance || overdraftContent) {
            return applyNext({
                clientRest: clientRest,
                clientDebt: clientDebt,
                clientBalance: clientBalance,
                clientDiscount: clientDiscount,
                overdraftContent: overdraftContent
            });
        }

        return '';
    }),

    match(function() {
        return !this.ctx.elem;
    }).match(function() {
        return this.overdraftContent;
    }).content()(function() {
        var data = this.data,
            lang = data.lang,
            overdraftList = [],
            hasBudgetData = data.budget && data.budget > 0;

        // Скидки
        if (this.clientDiscount) {
            overdraftList.push([
                hasBudgetData ?
                    {
                        block: 'check-button',
                        mods: { theme: 'pseudo' },
                        mix: [{
                            block: 'b-overdraft',
                            elem: 'discount-link'
                        }],
                        content: iget2('b-overdraft', 'tekushchaya-skidka-s', 'Текущая скидка {foo}%%', {
                            foo: Math.floor(data.discount)
                        })
                    } :
                    iget2('b-overdraft', 'tekushchaya-skidka-s-194', 'Текущая скидка {foo}%', {
                        foo: Math.round(data.discount)
                    }),
                {
                    block: 'link',
                    mix: [{
                        block: 'b-overdraft',
                        elem: 'context'
                    }],
                    target: 'blank',
                    url: iget2('b-overdraft', 'http-advertising-yandex-s', 'http://advertising.yandex.{foo}/price/discount/context.xml', {
                        foo: (lang == 'en' && 'com') || (lang == 'tr' && 'ru') || lang
                    }),
                    content: {
                        block: 'icon',
                        mods: {
                            'size-13': 'question',
                            theme: 'light'
                        }
                    }
                },
                hasBudgetData && {
                    block: 'b-menu-vert',
                    mix: [{
                        block: 'b-overdraft',
                        elem: 'discount'
                    }],
                    content: apply('discount')
                }
            ]);
        }

        // Для клиентов
        if (this.clientBalance) {

            // Отсрочка платежа
            if (this.clientRest && (data.client_allow_create_scamp_by_subclient || !data.client_have_agencies)) {
                overdraftList.push(iget2('b-overdraft', 'vozmozhna-otsrochka-platezha-na', 'Возможна отсрочка платежа на сумму {sum} {link}', {
                    link: {
                        block: 'b-help-link',
                        mods: { type: 'modal' },
                        mix: [{
                            block: 'b-overdraft',
                            elem: 'defer'
                        }],
                        stretched: true,
                        url: u.getHelpUrl('payment-delay')
                    },

                    sum: u.currencies.formatSum(
                        data.work_currency,
                        data.overdraft_rest, {
                            delim: '&nbsp;',
                            nds: data.work_currency == 'YND_FIXED'
                        })
                }));
            }

            // Задолженность
            if (this.clientDebt) {

                var formattingSumOfMoney = u.currencies.formatSum(
                        data.work_currency,
                        data.debt, {
                            delim: '&nbsp;',
                            nds: data.work_currency == 'YND_FIXED'
                        }),
                    clientDebt = [{
                        elem: 'debt',
                        content: [
                            {
                                block: 'icon-text',
                                mods: { size: 's', theme: 'alert' },
                                text: /\.$/.test(formattingSumOfMoney) ?
                                    iget2('b-overdraft', 'tekushchaya-zadolzhennost-s', 'Текущая задолженность: {foo}', {
                                        foo: formattingSumOfMoney
                                    }) :
                                    iget2('b-overdraft', 'tekushchaya-zadolzhennost-s-195', 'Текущая задолженность: {foo}.', {
                                        foo: formattingSumOfMoney
                                    })
                            }
                        ]
                    }];

                if (data.nextPayDateText) {
                    clientDebt.push({
                        elem: 'maturity',
                        content: [
                            (data.dateFlag == 'Past' ?
                                iget2('b-overdraft', 'srok-pogasheniya-prosrochen', 'Срок погашения просрочен') :
                                iget2('b-overdraft', 'crok-pogasheniya', 'Cрок погашения:')) + '&nbsp;' + data.nextPayDateText + '&nbsp;',
                            data.login_rights.user_allow_pay && {
                                block: 'button',
                                url: u.formatUrl({
                                    host: u.consts('balance'),
                                    // todo поправить вызов u.formatUrl на корректную работу с параметрами
                                    // (нужно сдвинуть ревизию adv-blocks чтобы u.formatUrl не срезал параметры с нулём)
                                    path: '/invoices.xml?date_type=1&receipt_status=0&payment_type=1&client_id=' +
                                        (data.login_rights.role.match(/manager|support|superreader|super/) ?
                                            data.ClientID :
                                            '')
                                }),
                                content: iget2('b-overdraft', 'pogasit', 'погасить')
                            }
                        ]
                    });
                }

                overdraftList.push(clientDebt);
            }

        }

        return overdraftList.map(function(itemContent) {
            return {
                elem: 'item',
                content: itemContent
            };
        });
    }),

    // Скидки
    mode('discount')(

        match(function() {
            return this.discountList;
        })(function() {
            var data = this.data,
                discountVals = {
                    services: iget2('b-overdraft', 'za-poslednie-12-mesyacev', 'За последние 12 месяцев оказано услуг на&nbsp;{foo}', {
                        foo: u.currencies.formatSum(data.work_currency, Math.floor(data.budget), {
                            delim: '&nbsp;'
                        })
                    }) + '*',
                    limit: iget2('b-overdraft', 'dostignutyy-porog-dlya-tekushchey', 'Достигнутый порог для текущей скидки&nbsp;&mdash;&nbsp;{foo}', {
                        foo: u.currencies.formatSum(data.work_currency, Math.floor(data.border_prev || 0), {
                            delim: '&nbsp;'
                        })
                    }) + '*',
                    nextLimit: iget2(
                        'b-overdraft',
                        'sleduyushchaya-skidka-nbsp-mdash',
                        'Следующая скидка&nbsp;&mdash;&nbsp;{foo}%, порог для нее составляет {bar}',
                        {
                            foo: Math.floor(data.discount_next),

                            bar: u.currencies.formatSum(data.work_currency, Math.floor(data.border_next), {
                                delim: '&nbsp;'
                            })
                        }
                    ) + '*',
                    vat: '*&nbsp;&mdash;&nbsp;' +
                        (data.work_currency == 'YND_FIXED' ? iget2('b-overdraft', 'summy-s-uchetom-nds', 'суммы с учетом НДС.') : iget2('b-overdraft', 'summy-bez-ucheta-nds', 'суммы без учета НДС.'))
                };

            return this.discountList.map(function(itemId) {
                return apply('listItem', {
                    itemId: itemId,
                    itemContent: discountVals[itemId]
                });
            }, this);
        }),

        match(function() {
            return !this.discountList;
        })(function() {
            return applyNext({
                discountList: ['services', 'limit', 'vat']
            });
        }),

        match(function() {
            return !this.discountList;
        }).match(function() {
            return (this.data.discount_next - this.data.discount >
                u.currencies.getConst(this.data.work_currency, 'MIN_PRICE'));
        })(function() {
            return applyNext({
                discountList: ['services', 'limit', 'nextLimit', 'vat']
            });
        })
    ),

    mode('listItem')(function() {
        return {
            elem: 'item',
            mix: (this.itemId == 'vat') ? [{
                block: 'b-overdraft',
                elem: 'vat'
            }] : '',
            content: this.itemContent
        };
    })
);
