block('b-page-warning')(

    js()(function() {
        return {
            expires: this.ctx.expires,
            cookieKey: u['b-page-warning'].generateCookieKey(this.ctx.id),
            pageWarningField: !u['b-page-warning'].isAlreadyHidden(this.ctx.id) && this.ctx.pageWarningField
        }
    }),

    content()(function() {
        var ctx = this.ctx;

        if (u['b-page-warning'].isAlreadyHidden(ctx.id)) {
            return '';
        }

        return {
            block: 'b-notice',
            mods: {
                theme: (ctx.mods || {}).theme || 'warning',
                'close-theme': 'middle'
            },
            mix: [{
                block: 'b-page-warning',
                elem: 'notice'
            }].concat(ctx.mix),
            hasClose: !ctx.disableClose,
            closeHint: ctx.closeHint,
            content: ctx.content
        };
    })
);
