BEM.DOM.decl('b-page-warning', {
    onSetMod: {

        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._noticeBlock = this.findBlockInside('b-notice');

            this._noticeBlock &&
                this._subscriptionManager.on(this._noticeBlock, 'close', this._onClose, this);

            if (this.params.pageWarningField) {
                this._flags = BEM.MODEL.getOrCreate('m-page-warning-flags');
                this._flags.set(this.params.pageWarningField, true);
            }
        }
    },

    /**
    * Удаляет блок и подписки на события
    */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
    * Обработчик события закрытия панели предупреждения
    */
    _onClose: function() {
        this._setHidingCookie();
        this.trigger('close');

        // `b-infoblock` подписывается на событие изменения флага, чтобы показать тизер после скрытия плашки
        if (this.params.pageWarningField) {
            this._flags.set(this.params.pageWarningField, false);
        }
    },

    /**
     * Выставляет блокирующую показ куку
     */
    _setHidingCookie: function() {
        // по умолчанию кука 1 день
        var expires = this.params.expires || 1;

        $.cookie(this.params.cookieKey, 1, { expires: expires, path: '/' });
    }
});
