u.register({
    'b-page-warning': {

        /**
         * Формирует ключ для cookies
         * @param {String} id - идентификатор предупреждения
         * @returns {String}
         */
        generateCookieKey: function(id) {
            return id + '~' + u.consts('uid') + ':' + u.consts('ulogin');
        },

        /**
         * Проверка, скрывали блок раньше или нет
         * @param {String} id - идентификатор предупреждения
         * @returns {boolean}
         */
        isAlreadyHidden: function(id) {
            var cookieKey = this.generateCookieKey(id);

            return u.hasCookie(cookieKey);
        }
    }
});
