block('b-page')(

    js()(function() {
        return {
            reqid: this.data.reqid,
            abBoxes: this.data.ab_boxes,
            UID: this.data.UID
        };
    }),

    mode('content-only')(undefined),

    def()(function() {
        var freelancerStatusAvoidContext,
            isFreelancerStatusNeedToBeRender;

        var data = this.data,
            langVals = {
                ru: 'ru',
                en: 'en',
                ua: 'uk',
                by: 'be',
                kz: 'kk',
                tr: 'tr'
            };
        this.lang = langVals[data.lang];

        var dnaHeaderAndSidebarEnabled = this.ctx.isDnaHeaderAndSidebarEnabled !== undefined ?
            this.ctx.isDnaHeaderAndSidebarEnabled :
            u.consts('rights').isDnaHeaderAndSidebarEnabled;
        this.isDnaHeaderAndSidebarEnabled = dnaHeaderAndSidebarEnabled && this.ctx.isHeaderEnabled;

        // Удалить "this.langForDna" когда перестанем отдавать ru бандлы DNA для украинского языка
        this.langForDna = getBundleLangForDna(this.lang);

        this.generateHashSum = function() {
            var result = '';
            var symbols = '0123456789abcdef';
            for (var i = 0; i < 32; i++) {
                result += symbols[Math.floor(Math.random() * symbols.length)];
            }
            return result;
        };
        /**
         * Добавляет к имени статического файла его хэш-сумму из data.static_file_hashsums.
         * Пример: _direct.bemtree.xjst.js -> _direct.v-XXXX.bemtree.xjst.js
         *
         * @param {String} filename Имя файла.
         * @param {String} hashName Ключ в data.static_file_hashsums; по умолчанию используется filename без символа
         *     слеша (косой черты) в начале.
         */
        this.expandStaticFileName = function(filename, hashName) {
            var hashSum;

            if (!this.data.static_file_hashsums) return filename;

            hashName = hashName || filename.replace(/^\//, '');
            hashSum = this.data.static_file_hashsums[hashName];

            // если для файла нет хеш-суммы, генерируем случайную
            hashSum = hashSum || this.generateHashSum();

            // Это регулярное выражение вытаскивает из имени файла слеш перед именем, имя
            // без расширения (_direct) и расширение или расширения (.bemtree.xjst.js).
            // В результате выполнения замены между именем и расширением вставляется '.v-XXXX'.
            return filename.replace(/\/([^\/\.]+)(\.[^\/]+)?$/, function(match, baseName, extension) {
                return '/' + baseName + '.v-' + hashSum + (extension ? extension : '');
            });
        };

        this.shouldLoadDnaFromS3 = function() {
            return true;
        };

        this.getS3Url = function() {
            if (this.data.is_beta) {
                return 'https://yastatic.net/s3/direct-dna/betas';
            }

            return 'https://yastatic.net/s3/direct-dna/releases';
        };

        this.useLocalDna = function() {
            return Boolean(this.data.is_beta && this.data.COOKIES['local-dna']);
        };

        this.useLocalFrontendServer = function() {
            return Boolean(this.data.COOKIES['local-frontend-server']);
        };

        this.getLocalDnaUrl = function(path) {
            return 'https://dna.yandex.ru:3000/' + (path || '');
        };

        this.addUtilityScripts = function() {
            var elems = [],
                js = [];

            if (this.shouldLoadDnaFromS3()) {
                var baseUrl = this.getS3Url() + '/';

                if (this.useLocalDna()) {
                    baseUrl = this.getLocalDnaUrl();
                } else if (this.useLocalFrontendServer()) {
                    baseUrl = '/dna/build/';
                }

                js.push('window.dnaResourceBaseUrl = "' + baseUrl + '";');
            }

            if (this.data.global_vars_file) {
                js.push(this.data.global_vars_file);
            }

            if (js.length > 0) {
                elems.push({
                    elem: 'js',
                    content: js.join(' ')
                });
            }

            elems.push({
                elem: 'js',
                attrs: { crossorigin: 'anonymous' },
                url: this.useLocalDna() ? u.devReactWithDomUrl : u.reactWithDomUrl
            });

            if (this.data.is_beta && this.data.COOKIES['DUMPSTER'] == 1) {
                // в режиме подмены бэкедна на дампы
                // выводим на экран ошибки об отсутствии дампов
                elems.push({
                    elem: 'js',
                    content:
                        'var _hermioneFetch = window.fetch;' +
                        'window.fetch = function() {' +
                        '    return _hermioneFetch.apply(window, arguments)' +
                        '        .then(function(r) {' +
                        '            if (r.status == 400) {' +
                        '                d = document.createElement("div");' +
                        '                d.style = "color:red;padding:15px;";' +
                        '                return r.text().then(function(text) {' +
                        '                    d.innerHTML = text;' +
                        '                    document.body.prepend(d);' +
                        '                    throw "error";' +
                        '                });' +
                        '            }' +
                        '            return r;' +
                        '        }).catch(err => {' +
                        '            console.log("err", err);' +
                        '            throw err;' +
                        '        });' +
                        '};'
                })
            }

            if (!this.data.is_production && this.data.COOKIES['HERMIONE'] == 1) {
                // для тестов отключаем все анимации
                // чтобы они не влияли на нестабильность скриншотов
                elems.push({
                    elem: 'css',
                    content:
                        'body, body *, body *:after, body *:before, body[class], body[class] *, body[class] *:after, body[class] *:before {' +
                        ' -webkit-animation-duration: 0s !important;' +
                        ' -moz-animation-duration: 0s !important;' +
                        ' -ms-animation-duration: 0s !important;' +
                        ' animation-duration: 0s !important;' +
                        ' -webkit-transition-duration: 0s !important;' +
                        ' -moz-transition-duration: 0s !important;' +
                        ' -ms-transition-duration: 0s !important;' +
                        ' transition-duration: 0s !important;' +
                        ' -webkit-transition-delay: 0s !important;' +
                        ' -moz-transition-delay: 0s !important;' +
                        ' -ms-transition-delay: 0s !important;' +
                        ' transition-delay: 0s !important;' +
                        '}'
                })
            }

            return elems;
        };

        this.addBeforeJsInitScripts = function(params) {
            var observeDOMNode = params && params.observeDOMNode;

            return {
                elem: 'js',
                content: [
                    '(function(){',
                    'window.__jsinitstart = +new Date();',
                    'window.Ya&&Ya.Rum&&Ya.Rum.sendTimeMark("3057");',
                    observeDOMNode && 'window.Ya&&Ya.Rum&&Ya.Rum.observeDOMNode("2876", "' + observeDOMNode + '")',
                    '}())'
                ].filter(Boolean).join('')
            };
        };

        this.addAfterJsInitScripts = function() {
            var mainJsUrl = this.expandStaticFileNameForDna('static/js/main.' + this.lang + '.js');

            return {
                elem: 'js',
                content: [
                    '(function(){',
                    'try{',
                    [
                        'var totalTime = +new Date() - window.__jsinitstart;',
                        // eslint-disable-next-line max-len
                        'var perfData = { timings: { "scriptsInit": totalTime }, deviceType: "desktop", interfaceEvents: { isDataActual: !document.hidden } };',
                        'var xhr = new XMLHttpRequest();',
                        'xhr.open("POST", "/web-api/log/frontendTimings", true);',
                        'xhr.setRequestHeader("Content-Type", "application/json");',
                        'xhr.send(JSON.stringify(perfData));', //ignore stringify
                    ].join(''),
                    '}catch(e){}',
                    'window.Ya&&Ya.Rum&&Ya.Rum.sendTimeMark&&Ya.Rum.sendTimeMark("3058");',
                    this.useLocalDna() ? '' : 'window.Ya&&Ya.Rum&&Ya.Rum.sendResTiming&&Ya.Rum.sendResTiming(2095, "' + mainJsUrl + '");',
                    '}())'
                ].join('')
            };
        };

        this.addDnaInlineScript = function() {
            var script = this.data.inline_script,
                isHermione = this.data.COOKIES['HERMIONE'] == 1;

            if (isHermione) {
                // На всемогущих бетах инлайн скрипт расходится с main бандлом, что дает ложные прокраски в ticount проверке.
                // ticount открывает беты с HERMIONE кукой, поэтому убираем inline скрипт и для ticount, и для тестов.
                return;
            }

            if (!script) {
                // Не хотим падать, если инлайн скрипт вдруг не попал в deb пакет
                return;
            }

            var inlineScriptParams = {
                login: this.data.login,
                loginFromBlackbox: this.data.uname,
                csrfToken: this.data.csrf_token,
                perlReqId: this.data.reqid,
                page: this.data.FORM.cmd
            };

            return {
                elem: 'js',
                content: [
                    script,
                    'window.dnaRunInlineScript && window.dnaRunInlineScript(' + safeStringify(inlineScriptParams) + ')'
                ].join(';')
            };
        };

        this.addDnaMainScript = function() {
            var url = this.expandStaticFileNameForDna('static/js/main.' + this.lang + '.js');

            if (this.useLocalDna()) {
                url = this.getLocalDnaUrl('static/js/main.js');
            }

            return {
                elem: 'js',
                attrs: { crossorigin: 'anonymous' },
                url: url
            };
        };

        this.addDnaMainStyles = function() {
            if (this.useLocalDna()) {
                return;
            }

            return {
                elem: 'css',
                attrs: { crossorigin: 'anonymous' },
                url: this.expandStaticFileNameForDna('static/css/main.' + this.lang + '.css')
            };
        };

        this.addCtxDumpScript = function() {
            var needRender = this.data.COOKIES.dumpvars_into_json && data.is_beta;
            var ctxDump;

            if (!needRender) {
                return;
            }

            try {
                ctxDump = JSON.stringify(this.data); // ignore stringify
            } catch (e) {
                ctxDump = '"' + e + '"';
            }

            return {
                elem: 'js',
                content: 'window.ctxDump = ' + escapeJs(ctxDump) + ';'
            };
        };

        this.addFavicons = function() {
            var isDirectRebrandingEnabled = u.hasClientFeature('direct_birthday_rebranding');

            return {
                elem: 'favicon',
                url: isDirectRebrandingEnabled ?
                    this.getS3Url() + '/favicon-2021.ico' :
                    '//yastatic.net/iconostasis/_/Elh4Zia0taGlnsEe-5f4mIu85oQ.ico'
            };
        };

        this.getPreloadLinkType = function() {
            if (this.data.is_preload_assets_enabled) {
                return 'preload';
            }
            if (this.data.is_prefetch_assets_enabled) {
                return 'prefetch';
            }
        };

        this.getPreloadLink = function(path, options) {
            options = options || {};

            var attrs = {
                as: options.type,
                rel: options.rel || 'preload',
                href: path,
                crossorigin: 'anonymous'
            };

            return { tag: 'link', attrs: attrs };
        };

        this.getS3PreloadLink = function(path, options) {
            var href = [this.getS3Url(), path].join('/');

            return this.getPreloadLink(href, options);
        };

        this.addPreloadLinks = function() {
            var currentPath = (this.data.FORM && this.data.FORM.native_uri) || '';
            var preloadManifest = this.data.preload_manifest;
            var relType = this.getPreloadLinkType();
            var preloadAssets = { scripts: [], styles: [] };

            if (this.useLocalDna() || !preloadManifest || !currentPath || !relType) {
                return [];
            }

            var matchedPathPattern = Object.keys(preloadManifest).find(function(pathPattern) {
                return (new RegExp(pathPattern)).test(currentPath)
            });

            if (matchedPathPattern) {
                preloadAssets = preloadManifest[matchedPathPattern];
            }

            var isPreloadAssetsEnabled = Boolean(this.data.is_preload_assets_enabled);

            var mainScript = this.expandStaticFileNameForDna('static/js/main.' + this.lang + '.js');
            var mainStyle = this.expandStaticFileNameForDna('static/css/main.' + this.lang + '.css');

            return [].concat(
                // для 3-х данных файлов нет смысла делать prefetch, т.к. с ним у загрузки становится низкий приоритет
                isPreloadAssetsEnabled && this.getPreloadLink(mainStyle, { type: 'style' }),
                isPreloadAssetsEnabled && this.getPreloadLink(u.reactWithDomUrl, { type: 'script' }),
                isPreloadAssetsEnabled && this.getPreloadLink(mainScript, { type: 'script' }),

                preloadAssets.styles.map(function(path) {
                    return this.getS3PreloadLink(path, { type: 'style', rel: relType });
                }, this),
                preloadAssets.scripts.map(function(path) {
                    return this.getS3PreloadLink(path, { type: 'script', rel: relType });
                }, this)
            ).filter(Boolean);
        };

        this.addFontToPreloadLinks = function() {
            var isFontPreloadingEnabled = Boolean(this.data.is_font_preloading_enabled);
            var currentPath = (this.data.FORM && this.data.FORM.native_uri) || '';
            var preloadManifest = this.data.preload_manifest;
            var preloadFonts = [];

            if (this.useLocalDna() || !preloadManifest || !currentPath || !isFontPreloadingEnabled) {
                return [];
            }

            var matchedPathPattern = Object.keys(preloadManifest).find(function(pathPattern) {
                return (new RegExp(pathPattern)).test(currentPath)
            });

            if (matchedPathPattern) {
                preloadFonts = preloadManifest[matchedPathPattern].fonts;
            }

            if (!preloadFonts) {
                return [];
            }

            return [].concat(
                preloadFonts.map(function(path) {
                    return this.getPreloadLink(path, { type: 'font', anonymous: true });
                }, this)
            ).filter(Boolean);
        };

        this.expandStaticFileNameForDna = function(filename) {
            var hashSum = this.data.static_file_hashsums && this.data.static_file_hashsums[filename],
                realFilename,
                sourceUrl;

            if (hashSum) {
                realFilename = filename.replace(/(js|css)$/, function(match) {
                    return hashSum + '.' + match;
                });
            } else {
                realFilename = filename + '?hashsum=' + this.generateHashSum();
            }

            if (this.shouldLoadDnaFromS3() && hashSum && !this.useLocalFrontendServer()) {
                sourceUrl = this.getS3Url();
            } else {
                // Если не найден хеш то делаем fallback на файлы без хеша.
                sourceUrl = '/dna/build';
            }

            return sourceUrl + '/' + realFilename;
        };

        this.ctx.title = apply('title') || '';
        this.ctx.head = apply('head');
        this.ctx.meta = apply('meta');

        if (this.ctx.pageBlock) {
            this.ctx.mods = this.mods || {};
            this.ctx.mods['page-block'] = this.ctx.pageBlock.block;
        }

        if (apply('content-only')) {
            this.ctx.mods['content-only'] = 'yes';
        }

        if (u.hasClientFeature('direct_birthday_rebranding')) {
            this.ctx.mods.rebranding = 'yes';
        }

        if (u.hasClientFeature('united_flow_stage_1_1')) {
            this.ctx.mods['united-flow-1-1'] = 'yes';
        }

        // с пеерездном на понятные url, perl теперь знает только о context и cmd
        // cmd - всегда статичный showDna для нового интерфейса
        // context - то, что идет после /dna/. Страница интерфейса.
        freelancerStatusAvoidContext =
            /context=(freelancers|customers|log|mobile-apps|recommendations|offline-reports|welcome|domains-reports)/;

        isFreelancerStatusNeedToBeRender = !freelancerStatusAvoidContext
            .test(decodeURIComponent(this.data.current_url));

        var applyNextData = {
            pageBlock: this.ctx.pageBlock,
            isFooterEnabled: this.ctx.isFooterEnabled,
            isHeaderEnabled: this.ctx.isHeaderEnabled,
            hideChatOnPage: this.ctx.hideChatOnPage,
            enablePhoneWarningsWrapper: false,
            tld: this['i-global'].tld,
            // для морды и страниц без шапки/футера (за исключением мультиредактирования)
            // не грузим js/css для dna и не инитим стор, т.к. dna там не используется
            withoutDna: Boolean(this.data.index_page ||
                apply('content-only') && this.ctx.pageBlock.block !== 'p-multiedit2'),

            // Под фичей в проде и на бетах с установленной кукой показываем новую шапку
            // !!!кроме типа кампании Сделки!!!
            isNewHeader: data.cmd === 'showCamp' && data.campaign && data.campaign.mediaType !== 'cpm_deals' && !!(
                data.is_new_campaign_info_enabled && (!data.is_beta || data.COOKIES.new_show_camp) ||
                data.is_beta && data.COOKIES.new_show_camp
            ),

            shouldRenderFreelancerStatus: /context=grid/.test(decodeURIComponent(this.data.current_url)) ?
                this.data.grid === 0 :
                isFreelancerStatusNeedToBeRender
        };
        if (this.isDnaHeaderAndSidebarEnabled) {
            applyNextData['ctx.mods'] = u._.extend(this.mods, { height: 'window' });
        }

        return applyNext(applyNextData);
    }),

    //  Добавляем модификатор b-page_touch_yes для тачевых устройств
    match(function() {
        return !!this.data.uatraits.isMobile;
    }).match(function() {
        return !!this.data.uatraits.isTouch;
    }).mix()(function() {
        this.ctx.mods = this.mods || {};
        this.ctx.mods.touch = 'yes';

        return applyNext();
    }),

    //  Добавляем модификатор b-page_skeleton_yes для страницы кампании с новой шапкой кампании
    match(function() { return this.isNewHeader; }).mix()(function() {
        this.ctx.mods = this.mods || {};
        this.ctx.mods.skeleton = 'yes';

        return applyNext();
    }),

    mode('title')(function() {
        return this.data.page_title;
    }),

    mode('head')(function() {
        return [
            u.getMetrikaPreloadScript(this.data.is_webvisor_enabled),
            {
                elem: 'js',
                content: applyCtx({
                    block: 'i-time-logger',
                    elem: 'init'
                })
            },
            !!this.data.is_production && {
                elem: 'js',
                content: applyCtx({
                    block: 'i-error-logger'
                })
            },
            {
                elem: 'js',
                content: applyCtx({
                    block: 'i-rum-timing'
                })
            },
            {
                elem: 'js',
                content: applyCtx({
                    block: 'i-rum-error-counter'
                })
            },
            {
                elem: 'js',
                content: applyCtx({
                    block: 'i-const',
                    mods: {
                        type: 'dump'
                    }
                })
            },
            apply('static-css'),
            this.addFavicons(),
            this.data.index_page && {
                tag: 'link',
                attrs: {
                    rel: 'alternate',
                    type: 'application/rss+xml',
                    title: iget2('b-page', 'novosti-yandeks-direkta', 'Новости Яндекс.Директа'),
                    href: '/news.rss'
                }
            }
        ];
    }),

    mode('meta')(function() {
        var meta = [
            {
                elem: 'meta',
                attrs: {
                    name: 'format-detection',
                    content: 'telephone=no'
                }
            },
            {
                elem: 'meta',
                attrs: {
                    name: 'keywords',
                    content: iget2('b-page', 'yandeks-direkt-direkt-kontekstnaya', 'Яндекс.Директ, Директ, контекстная реклама')
                }
            },
            {
                elem: 'meta',
                attrs: {
                    name: 'description',
                    content: this.data.page_description || iget2(
                        'b-page',
                        'yandeks-direkt-servis-dlya',
                        'Яндекс.Директ - сервис для размещения контекстной рекламы на Яндексе и на сайтах-партнерах его рекламной сети. Контекстная реклама помогает увеличить продажи и привлечь новых клиентов. Объявление видят пользователи, которые уже ищут в интернете товары или услуги рекламодателя.'
                    )
                }
            },
            {
                elem: 'meta',
                attrs: {
                    name: 'SKYPE_TOOLBAR',
                    content: 'SKYPE_TOOLBAR_PARSER_COMPATIBLE'
                }
            }
            // !this.data.is_touch_interface && this.data.uatraits.OSFamily == 'iOS' && {
            //     elem: 'meta',
            //     attrs: {
            //         name: 'apple-itunes-app',
            //         content: 'app-id=583627331'
            //     }
            // }
        ];

        var custom_meta = this.data.page_meta;
        if (custom_meta) {
            for (var key in custom_meta) {
                var attrs = {};
                attrs[custom_meta[key].type || 'name'] = key;
                attrs['content'] = custom_meta[key].content;

                meta.push({
                    elem: 'meta',
                    attrs: attrs
                })
            }
        }

        return meta;
    }),

    content()({
        elem: 'body'
    }),

    elem('body').content()(

        match(function() {
            return true;
        })({
            elem: 'page-block-undefined'
        }),

        match(function() {
            return this.pageBlock;
        })(function() {
            var data = this.data,
                firstCampaign = data.campaigns && data.campaigns[0],
                agencyID = firstCampaign ? firstCampaign.AgencyID : data.AgencyID,
                wallet = data.wallet && (agencyID ? data.wallet.agencies[agencyID] : data.wallet.self),
                ulogin = data.FORM.ulogin,
                isUcDesignEnabled = Boolean(
                    this.data.client_features && this.data.client_features.is_new_sidebar_available
                ),
                isDirectBirthdayRebrandingEnabled = u.hasClientFeature('direct_birthday_rebranding'),
                isUnitedFlowStage_1_1 = u.hasClientFeature('united_flow_stage_1_1');

            return [
                this.shouldRenderFreelancerStatus && isDirectBirthdayRebrandingEnabled && {
                    block: 'b-freelancer-project-status',
                    isDirectBirthdayRebrandingEnabled: isDirectBirthdayRebrandingEnabled,
                    mods: {
                        rebranding: u.hasClientFeature('direct_birthday_rebranding')
                    }
                },
                {
                    elem: 'logos'
                },
                {
                    elem: 'warnings',
                },
                this.withoutDna ?
                    '' :
                    {
                        block: 'b-state-dna',
                        ulogin: data.user_login || data.FORM.ulogin,
                        devInfo: u.createDevInfo(data),
                        infoblockTeasersUrl: data.infoblock_teasers_url,
                        cspNonce: data.csp_nonce,
                        tagsAllowed: data.tags_allowed === 'Yes',
                        page: this.data.FORM.cmd,
                        isGridEnabled: this.isDnaHeaderAndSidebarEnabled,
                        csrfToken: this.data.csrf_token,
                        isLoginBlocked: data.statusBlocked === 'Yes'
                    },
                this.enablePhoneWarningsWrapper && {
                    block: 'b-phone-warnings-dna',
                    ulogin: data.user_login || data.FORM.ulogin,
                    tld: this.tld
                },
                this.isHeaderEnabled && (
                    this.isDnaHeaderAndSidebarEnabled ?
                        !isUnitedFlowStage_1_1 && {
                            block: 'b-header-dna'
                        } :
                        {
                            block: 'header2'
                        }
                ),
                wallet && data.autooverdraft_params && {
                    block: 'b-overdraft-warning',
                    wallet: wallet,
                    agencyID: agencyID,
                    ulogin: ulogin,
                    currentCurrency: data.work_currency
                },
                this.shouldRenderFreelancerStatus && !isDirectBirthdayRebrandingEnabled && {
                    block: 'b-freelancer-project-status',
                    isDirectBirthdayRebrandingEnabled: isDirectBirthdayRebrandingEnabled,
                    mods: {
                        rebranding: u.hasClientFeature('direct_birthday_rebranding')
                    }
                },
                this.isDnaHeaderAndSidebarEnabled ? {
                    elem: 'content-wrapper-with-sidebar',
                    mix: isUnitedFlowStage_1_1 && {
                        block: 'app_is-united-flow-1-1'
                    },
                    content: [
                        {
                            elem: 'sidebar',
                            mix: isUcDesignEnabled && {
                                block: 'app_is-new-interface'
                            }
                        },
                        {
                            elem: 'wrapper',
                            content: [
                                { elem: 'content' },
                                this.isFooterEnabled && {
                                    elem: 'dev-info'
                                },
                                this.isFooterEnabled && {
                                    elem: 'footer-dna'
                                },
                            ]
                        },
                        isUnitedFlowStage_1_1 && { elem: 'userbar' }
                    ]
                } : {
                    elem: 'wrapper',
                    content: { elem: 'content' }
                },
                !this.isDnaHeaderAndSidebarEnabled && this.isFooterEnabled && {
                    elem: 'dev-info'
                },
                !this.isDnaHeaderAndSidebarEnabled && this.isFooterEnabled && {
                    elem: 'footer'
                },
                {
                    elem: 'foot-js'
                },
                {
                    elem: 'stat'
                },
                // чаты есть в header-dna, поэтому тут их не надо дублировать
                !this.isDnaHeaderAndSidebarEnabled && u.consts('isSupportChatEnabled') && !this.hideChatOnPage && {
                    elem: 'support-chat'
                },

                (this.data.is_beta && (!!this.data.COOKIES.dumpvars || !!this.data.COOKIES.get_vars)) && {
                    block: 'b-dumper'
                },
                //@heliarian подключается строго после остальных блоков
                (!!this.data.COOKIES.highlight_inited_blocks && this.data.is_beta) && {
                    block: 'i-inited-highlight'
                }
            ];
        })
    ),

    elem('logos').replace()(function() {
        var lang = /en|tr/.test(this.lang) ? 'en' : 'ru',
            logos = lang === 'en' ? [
                'borschik:include:../../desktop.blocks/b-page/assets/b-page-ya-logo-en.svg',
                'borschik:include:../../desktop.blocks/b-page/assets/b-page-direct-logo-en.svg',
                'borschik:include:../../desktop.blocks/b-page/assets/b-page-direct-icon.svg',
                'borschik:include:../../desktop.blocks/b-page/assets/b-page-direct-logo-v2-en.svg',
                'borschik:include:../../desktop.blocks/b-page/assets/b-page-direct-icon-v2.svg',

            ] : [
                'borschik:include:../../desktop.blocks/b-page/assets/b-page-ya-logo-ru.svg',
                'borschik:include:../../desktop.blocks/b-page/assets/b-page-direct-logo-ru.svg',
                'borschik:include:../../desktop.blocks/b-page/assets/b-page-direct-icon.svg',
                'borschik:include:../../desktop.blocks/b-page/assets/b-page-direct-logo-v2-ru.svg',
                'borschik:include:../../desktop.blocks/b-page/assets/b-page-direct-icon-v2.svg',

            ];

        return {
            tag: 'svg',
            attrs: {
                style: 'position:absolute;width:0;height:0',
                xmlns: 'http://www.w3.org/2000/svg',
                'xmlns:xlink': 'http://www.w3.org/1999/xlink',
                'aria-hidden': 'true'
            },
            content: {
                tag: 'defs',
                content: logos
            }
        };
    }),

    elem('warnings').content()(function() {
        var data = this.data,
            JSS_VALIDATION = data.JSS_VALIDATION,
            userOptions = data.USER_OPTIONS || {};

        return [
            !!data.is_beta && {
                block: 'b-template-error-summary',
                js: true
            },
            this.data.is_beta ?
                {
                    block: 'b-validation-errors',
                    pBlock: this.pageBlock.block,
                    expectedProps: this.__expectedProps,
                    controllerInputWarnErrors: JSS_VALIDATION && JSS_VALIDATION.input &&
                        JSS_VALIDATION.input.level == 'warn' && JSS_VALIDATION.input.errors,
                    controllerOutputWarnErrors: JSS_VALIDATION && JSS_VALIDATION.output &&
                        JSS_VALIDATION.output.level == 'warn' && JSS_VALIDATION.output.errors
                } :
                '',
            {
                block: 'b-head-warning'
            },
            u.consts('client_country') && u.consts('client_country') === u.REGIONS.UKRAINE &&
            !+userOptions['hide_block_ukraine_warning'] && {
                block: 'b-block-ukraine-warning'
            },
            this.data.cmd === 'showCamps' && +this.data.COOKIES.hide_new_show_camps_warning !== 1 && {
                block: 'b-new-show-camps-warning'
            },
            u.consts('client_country') === u.REGIONS.RUSSIA && this.data.client_currency === 'RUB' &&
            this.data.is_alert_nds20_enabled &&
            !+this.data.COOKIES.hide_nds20_warning && {
                block: 'b-nds20-warning'
            },

            // DIRECT-121096 — здесь можно включить глобальное предупреждение в старом интерфейсе
            // { elem: 'global-warning' },

            this.data.is_user_applicable_for_min_price_shutdown_warning != null &&
            !+userOptions['hide_min_price_warning'] && {
                block: 'b-min-price-shutdown-warning'
            },

            Number(this.data.show_belarus_change_bank_details_warning) === 1 &&
            !+userOptions['hide_belarus_change_bank_details_warning'] && {
                block: 'b-belarus-change-bank-details-warning'
            },

            Number(this.data.show_belarus_old_rub_warning) === 1 &&
            !+userOptions['hide_belarus_old_rub_warning'] && {
                block: 'b-belarus-old-rub-warning'
            },

            { elem: 'old-browsers' }
        ]
    }),

    elem('sidebar').content()(function() {
        var cookieVal = this.data.COOKIES['is-sidebar-expanded'],
            expanded = undefined,
            isUcDesignEnabled = Boolean(
                this.data.client_features && this.data.client_features.is_new_sidebar_available
            ),
            isDirectBirthdayRebrandingEnabled = u.hasClientFeature('direct_birthday_rebranding'),
            mods = {
                skeleton: 'yes',
                uc: isUcDesignEnabled ? 'yes' : 'no',
                rebranding: isDirectBirthdayRebrandingEnabled ? 'yes' : 'no'
            };

        if (cookieVal === '0') {
            expanded = false;
        } else if (cookieVal === '1' || isUcDesignEnabled) {
            expanded = true;
            mods['expanded'] = 'yes';
        }

        return {
            block: 'b-sidebar-dna',
            mods: mods,
            expanded: expanded,
            is_enable_sidebar_optimize: Boolean(this.data.is_enable_sidebar_optimize),
            isUcDesignEnabled: isUcDesignEnabled
        }
    }),

    elem('userbar').content()(function() {
        return {
            block: 'b-userbar-dna'
        }
    }),

    elem('support-chat').match(function() {
        return this.data.FORM.popupMode !== '1'
    }).replace()(function() {
        return {
            block: 'b-support-chat',
            mix: { block: 'b-page', elem: 'support-chat' },
            csp_nonce: this.data.csp_nonce,
            lang: this.data.lang
        };
    }),

    elem('foot-js').content()(function() {
        this.__disableCheckExpectedProps = true;
        var ctxDump;

        if (!!this.data.COOKIES.dumpvars_into_json && this.data.is_beta) {
            try {
                ctxDump = JSON.stringify(this.data); // ignore stringify
            } catch (e) {
                ctxDump = '"' + e + '"';
            }
        }

        var data = this.data,
            result = [
                {
                    block: 'i-jquery',
                    mods: {
                        version: '3.5.1'
                    },
                    url: 'https://direct-dna.s3.yandex.net/direct-static/jquery/jquery-3.5.1.min.js'
                },
                {
                    elem: 'js',
                    url: 'https://direct-dna.s3.yandex.net/direct-static/jquery-migrate/jquery-migrate-3.1.0.min.js'
                },
                {
                    elem: 'js',
                    content: 'jQuery.event.fixHooks = {};'
                },
                {
                    elem: 'js',
                    url: '/js/jquery-check.js'
                },
                data.lang != 'ru' && {
                    elem: 'js',
                    url: '/block/i-translation/i-translation_lang_' + data.lang + '.js'
                },
                //data.is_beta && { elem: 'js', url: this.expandStaticFileName('/data3/desktop.bundles/direct/direct.client.schema.js') },
                { elem: 'static-js' },
                !!this.data.COOKIES.dumpvars_into_json && data.is_beta ? {
                    elem: 'js',
                    content: 'window.ctxDump = ' + escapeJs(ctxDump) + ';'
                } : ''
            ];

        this.__disableCheckExpectedProps = false;

        return result;
    }),

    elem('content').match(function() {
        return this.pageBlock;
    }).content()(function() {
        // Без extend весь контент страничного блока попадает еще и в `ctx` блока `b-page`
        return [
            this.extend({}, this.pageBlock)
        ];
    }),

    elem('page-block-undefined').match(function() {
        return this.data.is_beta;
    }).content()(function() {
        return [
            {
                elem: 'content',
                content: iget2('b-page', 'ne-nayden-ili-ne', 'Не найден или не указан блок страницы') + ' ' + this.data.cmd
            },
            {
                elem: 'foot-js'
            },
            {
                elem: 'stat'
            },
            applyCtx({
                block: 'b-dev-info',
                usedPage: {
                    block: 'undefined'
                }
            }),
            (this.data.COOKIES.dumpvars || this.data.COOKIES.get_vars) && {
                block: 'b-dumper'
            }
        ];
    }),

    elem('dev-info').match(function() {
        return this.data.is_beta;
    }).replace()(function() {
        return {
            block: 'b-dev-info',
            usedPage: {
                block: this.pageBlock.block,
                mods: this.pageBlock.mods
            }
        };
    }),

    elem('global-warning').replace()(function() {
        return u.consts('tld') !== 'com.tr' && {
            block: 'b-global-warning',
            mods: { type: 'non-working-week' }
        };
    }),

    elem('footer').replace()(function() {
        return {
            block: 'footer',
            retPath: this.data.is_public && this['i-global'].retpath
        };
    }),

    elem('footer-dna').replace()(function() {
        return {
            block: 'b-footer-dna',
            mods: {
                rebranding: u.hasClientFeature('direct_birthday_rebranding')
            }
        };
    }),

    mod('content-only', 'yes').elem('body').content()(

        match(function() {
            return true;
        })({
            elem: 'page-block-undefined'
        }),

        match(function() {
            return this.pageBlock;
        })(function() {
            return [
                this.data.FORM.popupMode == '1' && {
                    tag: 'base',
                    attrs: {
                        target: '_blank'
                    }
                },
                {
                    elem: 'content'
                },
                {
                    elem: 'foot-js'
                },
                {
                    elem: 'stat'
                },
                this.isFooterEnabled && {
                    elem: 'dev-info'
                },
                ((this.data.COOKIES.dumpvars || this.data.COOKIES.get_vars) && this.data.is_beta) && {
                    block: 'b-dumper'
                }
            ];
        })
    ),

    mode('static-css')(function() {
        return [
            // Не передвигать после desktop.bundles/direct так как всё едет в старом интерфейсе из-за неправильно
            // переобределённых стилей с наружением инкапсуляции lego блоков
            (this.withoutDna || this.useLocalDna()) ?
                '' :
                {
                    elem: 'css',
                    url: this.expandStaticFileNameForDna('static/css/desktopForOldInterface.' + this.langForDna + '.css')
                },
            {
                elem: 'css',
                url: this.expandStaticFileName('/data3/desktop.bundles/direct/_direct.css'),
                ie: false
            },
            {
                elem: 'css',
                url: this.expandStaticFileName('/data3/desktop.bundles/direct/_direct.ie.css', 'union:desktop:ie'),
                ie: 'IE'
            }
        ]
    }),

    elem('static-js').replace()(
        (function() {
            return [
                {
                    elem: 'js',
                    url: this.expandStaticFileName('/data3/desktop.bundles/direct/_direct.' + this.lang + '.js')
                }
            ]
        }),

        match(function() { return !this.withoutDna; })(function() {
            var data = this.data;
            var desktopForOldInterfaceUrl = this.expandStaticFileNameForDna('static/js/desktopForOldInterface.' + this.langForDna + '.js');

            if (this.useLocalDna()) {
                desktopForOldInterfaceUrl = this.getLocalDnaUrl('static/js/desktopForOldInterface.js');
            }

            return [
                {
                    elem: 'js',
                    content: '(function(){ window.__jsinitstart = +new Date(); }())'
                },
                this.addUtilityScripts(),
                [
                    {
                        elem: 'js',
                        attrs: { crossorigin: 'anonymous' },
                        url: desktopForOldInterfaceUrl
                    },
                    {
                        elem: 'js',
                        content: 'try { ' +
                            'dna && dna.components.StateWrapper.initStore(' + safeStringify({
                                login: data.user_login || data.FORM.ulogin,
                                loginFromBlackbox: data.uname,
                                page: data.FORM.cmd,
                                devInfo: u.createDevInfo(data),
                                tagsAllowed: data.tags_allowed === 'Yes',
                                infoblockTeasersUrl: data.infoblock_teasers_url,
                                cspNonce: data.csp_nonce,
                                isGridEnabled: this.isDnaHeaderAndSidebarEnabled,
                                csrfToken: data.csrf_token,
                                perlReqId: data.reqid,
                                clientFeatures: u.consts('clientFeaturesAll'),
                                operatorFeatures: u.consts('operatorFeaturesAll'),
                                isUcGridDesignEnabled: Boolean(
                                    data.client_features && data.client_features.is_new_sidebar_available
                                ),
                                isLoginBlocked: data.statusBlocked === 'Yes'
                            }) + ');' +
                            '} catch(e) {}'
                    },
                    // Наколеночное ускорение шапки кампании на странице кампании
                    this.isNewHeader && {
                        elem: 'js',
                        content: 'try { ' +
                            'dna && dna.reactDOMRender(' +
                            '  dna.reactCreateElement(dna.components.LegacyCampaignPageHeaderWrapper, {' +
                            '    campaignId: ' + safeStringify(data.campaign.cid) + ',' +
                            '    onReadyContent: function() {' +
                            '        var page = BEM.DOM.scope.bem("b-page");' +
                            '        page && page.delMod("skeleton");' +
                            '    }' +
                            '  }, null),' +
                            '  document.querySelector(".b-dna-header")' +
                            ');' +
                            '} catch(e) {}'
                    }
                ]
            ].concat(applyNext());
        })
    )
);

function getBundleLangForDna(lang) {
    if (lang === 'uk') {
        return 'ru';
    }

    return lang;
}
