block('b-pager').mod('type', 'ajax')(

    def()(function() {
        var ctx = this.ctx || {},
            url = ctx.pageUrl || '',
            start = ctx.startFrom || 0,
            anchor = ctx.anchor ? '#' + ctx.anchor : '',
            current = ctx.currentPage ? +ctx.currentPage + (1 - start) : 1,
            getUrl = function(page) {
                var startFrom = 1 - start,
                    pageNo = page - startFrom;

                return url + pageNo + anchor;
            },
            pages = ctx.totalPages || Math.ceil(ctx.totalCount / (ctx.perpageCount || 20));

        url += (url.indexOf('?') + 1 ? '&' : '?') + (ctx.pageParam || 'p') + '=';

        ctx.js = ctx.js || {
            keydownReaction: ctx.keydownReaction === undefined ? true : ctx.keydownReaction
        };

        return applyNext({
            _current: current,
            _pages: pages,
            _keydownReaction: ctx.keydownReaction === undefined ? true : ctx.keydownReaction,
            _getUrl: getUrl,
            _prevUrl: current > 1 ? getUrl(current - 1) : '',
            _nextUrl: current < pages ? getUrl(current + 1) : ''
        });
    }),

    elem('pages').content()(function() {
        var getUrl = this._getUrl,
            ctx = this.ctx,
            radius = +ctx.pagerRadius || 3,
            left = Math.max(1, this._current - radius),
            right = Math.min(this._pages, this._current + radius),
            pages = [],
            i;

        function getPage(page, content) {
            return [{
                elem: 'page',
                url: getUrl(page),
                content: content,
                page: page
            }, ' '];
        }

        left > 1 && pages.push(ctx.showFirst ? getPage(1, '1') : getPage(left - 1));

        left > 2 && ctx.showFirst && pages.push(getPage(2));

        if (left < right) {
            for (i = left; i <= right; i++)
                pages.push(i == this._current ? [{
                    elem: 'current',
                    content: i
                }, ' '] :
                    getPage(i, i));
        }

        ((right < this._pages && !ctx.showLast) ||
            (right < this._pages - 1 && ctx.showLast)) &&
        pages.push(getPage(right + 1));

        right < this._pages && ctx.showLast &&
            pages.push(getPage(this._pages, this._pages));

        return pages;
    }),

    elem('page')(

        content()(function() {
            return {
                block: 'link',
                mix: { block: 'b-pager', elem: 'page', js: { page: this.ctx.page } },
                url: this.ctx.url,
                content: this.ctx.content || '&hellip;'
            };
        })
    )
);
