BEM.DOM.decl({ block: 'b-pager', modName: 'type', modVal: 'ajax' }, {
    onSetMod: {
        js: function() {
            this.__self.liveBindTo('pages', 'click', this._onPagesClick);
        }
    },

    /**
     * Событие клика по выбранной странице
     * Перерисовывает список страниц и генерирует событие "change-page"
     * @param {Event} e
     * @private
     */
    _onPagesClick: function(e) {
        var curPage = this.elemParams(this.elemify($(e.target), 'page')).page;

        if (!curPage) return false;

        this.trigger('change-page', { page: curPage });

        return false;
    },

    update: function(updateParams, callback, callbackCtx) {
        var params = $.extend({}, this.params, updateParams);
        BEM.DOM.update(this.elem('pages'), $(BEMHTML.apply({
            block: 'b-pager',
            mods: { type: 'ajax' },
            perpageCount: params.perpageCount || 5,
            totalCount: params.totalCount,
            currentPage: params.currentPage,
            startFrom: params.startFrom,
            content: [{
                elem: 'pages',
                showFirst: params.showFirst || false,
                showLast: params.showLast || false,
                pagerRadius: params.pagerRadius || 3
            }]
        })).bem('b-pager').elem('pages').html(),  //todo: переписать шаблон и убрать этот костыль
            callback,
            callbackCtx || this
        );
    },

    destruct: function() {
        this.__self.liveUnbindFrom('pages', 'click', this._onPagesClick);
        this.__base.apply(this, arguments);
    }

});
