block('b-pager').mod('type', 'js')(

    js()(function() {
        return {
            current: this.current,
            total: this.total
        };
    }),

    def()(function() {
        return applyNext({
            current: this.ctx.currentPage || 1,
            total: this.ctx.totalPages || this.ctx.currentPage,
            _current: true,
            _prevUrl: true,
            _nextUrl: true
        });
    }),

    elem('pages').content()(function() {
        var pages = [];

        for (var i = 1; i <= this.total; i++) {
            pages.push({
                elem: 'page',
                elemMods: { current: this.current === i ? 'yes' : '' },
                pos: i
            });
        }

        return pages;
    }),

    elem('page')(

        tag()('span'),

        def()(function() {
            return applyNext({
                'elemMods.pos': this.ctx.pos
            });
        }),

        content()(function() {
            return [
                {
                    block: 'link',
                    mix: [{
                        block: 'b-pager',
                        elem: 'page-link'
                    }],
                    mods: { pseudo: 'yes' },
                    content: this.ctx.pos
                },
                {
                    elem: 'current',
                    content: this.ctx.pos
                }
            ];
        })),

    elem('button-prev').def()(function() {
        return applyCtx({
            block: 'link',
            mix: [{
                block: 'b-pager',
                elem: 'button-prev'
            }],
            mods: {
                pseudo: 'yes',
                disabled: this.current === 1 ? 'yes' : ''
            },
            content: this.ctx.content
        });
    }),

    elem('button-next').def()(function() {
        return applyCtx({
            block: 'link',
            mix: [{
                block: 'b-pager',
                elem: 'button-next'
            }],
            mods: {
                pseudo: 'yes',
                disabled: this.current === this.total ? 'yes' : ''
            },
            content: this.ctx.content
        });
    }))
