BEM.DOM.decl({ block: 'b-pager', modName: 'type', modVal: 'js' }, {

    onSetMod: {

        js: function() {
            var _this = this;

            this._prev = this.findBlockOn('button-prev', 'link');
            this._next = this.findBlockOn('button-next', 'link');
            this._links = this.findBlocksOn('page-link', 'link');
            this._current = this.params.current;
            this._total = this.params.total;

            BEM.blocks['link'].on(this.elem('page-link'), 'click', function(e) {
                _this.setPage(+_this.getMod(e.block.domElem.closest(_this.buildSelector('page')), 'pos'));
            });

            this._prev && this._prev.on('click', function() {
                _this.setPage(_this._current - 1);
            });

            this._next && this._next.on('click', function() {
                _this.setPage(_this._current + 1);
            });
        },

        disabled: function(mod, val) {
            this._links && this._links.forEach(function(link) {
                link.setMod(mod, val);
            });
            this._prev && this._prev.setMod(mod, val !== 'yes' && this._current !== 1 ? '' : 'yes');
            this._next && this._next.setMod(mod, val !== 'yes' && this._current === this._total ? '' : 'yes');
        }

    },

    /**
     * Установить страницу
     * {Number} pos
     */
    setPage: function(pos) {
        this._current = pos;

        this._prev && this._prev.setMod('disabled', this._current === 1 ? 'yes' : '');
        this._next && this._next.setMod('disabled', this._current === this._total ? 'yes' : '');

        this
            .delMod(this.findElem('page', 'current', 'yes'), 'current')
            .setMod(this.findElem('page', 'pos', pos), 'current', 'yes');

        this.trigger('change-page', { page: pos });
    }

}, {

    live: function() {
        return false;
    }

});
