block('b-pager').mod('type', 'mol')(

    // skywhale: DIRECT-49467
    // Временный b-pager для МОЛ
    def().match(function() {
        return !this._current;
    })(function() {
        var ctx = this.ctx,
            url = ctx.pageUrl || '',
            start = ctx.startFrom || 0,
            pageParam = ctx.pageParam || 'p',
            sortedParam = 'sorted',
            current = ctx.currentPage ? +ctx.currentPage + (1 - start) : 1,
            pages = ctx.totalPages || Math.ceil(ctx.totalCount / (ctx.perpageCount || 20)),
            getUrl = function(page, sorted) {
                var u = [url],
                    startFrom = 1 - start,
                    pageNo = page - startFrom;

                if (pageNo > 0) {
                    u.push(pageParam + '=' + pageNo);
                }
                if (sorted && sorted.value) {
                    u.push((sorted.param || sortedParam) + '=' + sorted.value);
                }

                return u.join('');
            };

        url += (url.indexOf('?') + 1 ? '&' : '?');

        return pages > 1 ?
            applyNext({
                _mode: '',
                _current: current,
                _pages: pages,
                _keydownReaction: ctx.keydownReaction === undefined ? true : ctx.keydownReaction,
                _startFrom: start,
                _getUrl: getUrl,
                _prevUrl: current > 1 ? getUrl(current - 1) : '',
                _nextUrl: current < pages ?
                    current < 0 ? '' : getUrl(current + 1) :
                    '',
                _allUrl: ctx.allUrl,
                ctx: ctx
            }) :
            '';
    }),

    elem('pages').content()(function() {
        var getUrl = this._getUrl,
            ctx = this.ctx,
            radius = +ctx.pagerRadius || 7,
            left = Math.max(1, this._current - radius),
            right = Math.min(this._pages, this._current + radius),
            startFrom = this._startFrom,
            elemContent,
            pages = [],
            i;

        function getPage(page, content) {
            return [
                {
                    elem: 'page',
                    url: getUrl(page),
                    content: content,
                    page: page
                },
                ' '
            ];
        }

        left > 1 && pages.push(ctx.showFirst ? getPage(1, '1') : getPage(left - 1));

        left > 2 && ctx.showFirst && pages.push(getPage(2));

        for (i = left; i <= right; i++) {
            elemContent = i - (1 - startFrom);

            if (i != right || i == this._current) {
                pages.push(i == this._current ?
                    [
                        {
                            elem: 'current',
                            content: elemContent
                        },
                        ' '
                    ] :
                    getPage(i, elemContent));
            } else {
                pages.push(getPage(i));
            }
        }

        ((right < this._pages && !ctx.showLast) || (right < this._pages - 1 && ctx.showLast)) &&
            pages.push(getPage(right + 1));

        right < this._pages && ctx.showLast &&
            pages.push(getPage(this._pages, this._pages));

        return pages;
    }),

    elem('page')(
        content()(function() {
            return {
                block: 'link',
                mix: { block: 'b-pager', elem: 'page', js: { page: this.ctx.page } },
                url: this.ctx.url,
                content: this.ctx.content || '&hellip;'
            };
        })
    ),

    elem('button-all')(

        tag()('span'),

        mix()(function() {
            return [{
                elem: this._allUrl ? 'active' : 'inactive'
            }];
        }),

        content()(function() {
            return [
                this._allUrl ?
                    {
                        elem: 'all',
                        url: this._allUrl,
                        content: this.ctx.content
                    } :
                    this.ctx.content
            ];
        })
    ),

    elem('all')(

        tag()('a'),

        attrs()(function() { return { href: this.ctx.url }; })
    ),

    elem('button-start')(
        content()(function() {
            return {
                block: 'link',
                mix: { block: 'b-pager', elem: 'page', js: { page: this._startFrom } },
                url: this._getUrl(2 - this._startFrom),
                content: this.ctx.content
            };
        })
    ),

    elem('key')(

        tag()('i'),

        content()(function() {
            return {
                elem: 'arr',
                content: '&' + this.ctx.dir + 'arr;'
            };
        })
    )
);
