block('b-pager').mod('type', 'show-all')(

    def()(function() {
        var ctx = this.ctx || {},
            url = ctx.pageUrl || '',
            start = ctx.startFrom || 0,
            pageParam = ctx.pageParam || 'p',
            sortedParam = 'sorted',
            current = ctx.currentPage ? +ctx.currentPage + (1 - start) : 1,
            getUrl = function(page, sorted) {
                var u = [url],
                    startFrom = 1 - start,
                    pageNo = page - startFrom;

                if (pageNo > 0) {
                    u.push(pageParam + '=' + pageNo)
                }
                if (sorted && sorted.value) {
                    u.push((sorted.param || sortedParam) + '=' + sorted.value)
                }

                return u.join('');
            },
            pages = ctx.totalPages || Math.ceil(ctx.totalCount / (ctx.perpageCount || 20));

        url += (url.indexOf('?') + 1 ? '&' : '?');

        ctx.js = ctx.js || {
            keydownReaction: ctx.keydownReaction === undefined ? true : ctx.keydownReaction
        };

        return pages <= 1 ?
            '' :
            applyNext({
                _current: current,
                _pages: pages,
                _keydownReaction: ctx.keydownReaction === undefined ? true : ctx.keydownReaction,
                _getUrl: getUrl,
                _prevUrl: current > 1 ? getUrl(current - 1) : '',
                _nextUrl: current < pages ?
                    current < 0 ? '' : getUrl(current + 1) :
                    '',
                _allUrl: ctx.allUrl
            });
    }),

    elem('button-all')(

        tag()('span'),

        mix()(function() {
            return [{ elem: this._allUrl ? 'active' : 'inactive' }];
        }),

        content()(function() {
            return [
                this._allUrl ?
                    {
                        elem: 'all',
                        url: this._allUrl,
                        content: this.ctx.content
                    } :
                    this.ctx.content
            ];
        })
    ),

    elem('all')(

        tag()('a'),

        attrs()(function() {
            return { href: this.ctx.url };
        })
    ),

    elem('key')(

        tag()('i'),

        content()(function() {

            return {
                elem: 'arr',
                content: '&' + this.ctx.dir + 'arr;'
            };
        })
    )
);
