block('b-pager')(
    //@heliarian у b-pager_type_ajax свой блок def() и определения элементов. Есть подозрения, что для других _type определения из основного блока тоже не нужны
    match(function() { return this.mods && this.mods.type !== 'ajax'; }).def()(function() {
        var ctx = this.ctx || {},
            url = ctx.pageUrl || '',
            start = ctx.startFrom || 0,
            pageParam = ctx.pageParam || 'p',
            sortedParam = 'sorted',
            current = ctx.currentPage ? +ctx.currentPage + (1 - start) : 1,
            getUrl = function(page, sorted) {
                var u = [url],
                    startFrom = 1 - start,
                    pageNo = page - startFrom;

                if (pageNo > 0) {
                    u.push(pageParam + '=' + pageNo)
                }
                if (sorted && sorted.value) {
                    u.push((sorted.param || sortedParam) + '=' + sorted.value)
                }

                return u.join('');
            },
            pages = ctx.totalPages || Math.ceil(ctx.totalCount / (ctx.perpageCount || 20));
        url += (url.indexOf('?') + 1 ? '&' : '?');

        ctx.js = ctx.js || {
            keydownReaction: ctx.keydownReaction === undefined ? true : ctx.keydownReaction
        };

        return isNaN(pages) || pages <= 1 ?
            '' :
            applyNext({
                _current: current,
                _pages: pages,
                _keydownReaction: ctx.keydownReaction === undefined ? true : ctx.keydownReaction,
                _getUrl: getUrl,
                _prevUrl: current > 1 ? getUrl(current - 1) : '',
                _prevPage: current > 1 ? current - 1 : '',
                _nextUrl: current < pages ? getUrl(current + 1) : '',
                _nextPage: current < pages ? current + 1 : '',
            });
    }),

    elem('title').tag()('b'),

    elem('button-prev')(

        tag()('span'),

        mix()(function() {
            return [{ elem: this._prevUrl ? 'active' : 'inactive' }];
        }),

        content()(function() {
            var content = [this._prevUrl ?
            {
                elem: 'prev',
                url: this._prevUrl,
                content: this.ctx.content,
                page: this._prevPage,
            } :
                    this.ctx.content];

            this._keydownReaction &&
                content.unshift({
                    elem: 'key',
                    dir: 'l'
                }, '&nbsp;');

            return content;
        })
    ),

    elem('button-next')(

        tag()('span'),

        mix()(function() {
            return [{ elem: this._nextUrl ? 'active' : 'inactive' }];
        }),

        content()(function() {
            var content = [
                this._nextUrl ?
                {
                    elem: 'next',
                    url: this._nextUrl,
                    content: this.ctx.content,
                    page: this._nextPage
                } :
                this.ctx.content
            ];

            this._keydownReaction &&
                content.push('&nbsp;', {
                    elem: 'key',
                    dir: 'r'
                });

            return content;
        })
    ),

    elem('prev')(
        def()(function() {
            return applyCtx({
                block: 'link',
                mix: { block: 'b-pager', elem: 'prev', js: { page: this.ctx.page } },
                url: this.ctx.url,
                content: applyCtx(this.ctx.content)
            });
        })
    ),

    elem('next')(
        def()(function() {
            return applyCtx({
                block: 'link',
                mix: { block: 'b-pager', elem: 'next', js: { page: this.ctx.page } },
                url: this.ctx.url,
                content: applyCtx(this.ctx.content)
            });
        })
    ),

    elem('key')(

        tag()('i'),

        content()(function() {
            var arr = {
                elem: 'arr',
                content: '&' + this.ctx.dir + 'arr;'
            };
            return this.ctx.dir == 'l' ? [arr, '&nbsp;Ctrl'] : ['Ctrl&nbsp;', arr];
        })
    ),

    elem('arr').tag()('i'),

    elem('pages').content()(function() {
        var getUrl = this._getUrl,
            ctx = this.ctx,
            radius = +ctx.pagerRadius || 7,
            left = Math.max(1, this._current - radius),
            right = Math.min(this._pages, this._current + radius),
            pages = [],
            i;

        function getPage(page, content) {
            return [
                {
                    elem: 'page',
                    url: getUrl(page),
                    content: content
                },
                ' '
            ];
        }

        left > 1 && pages.push(ctx.showFirst ? getPage(1, '1') : getPage(left - 1));

        left > 2 && ctx.showFirst && pages.push(getPage(2));

        for (i = left; i <= right; i++)
            pages.push(i == this._current ?
                [
                    {
                        elem: 'current',
                        content: i
                    },
                    ' '
                ] :
                getPage(i, i));

        ((right < this._pages && !ctx.showLast) ||
            (right < this._pages - 1 && ctx.showLast)) &&
                pages.push(getPage(right + 1));

        right < this._pages && ctx.showLast &&
            pages.push(getPage(this._pages, this._pages));

        return pages;
    }),

    elem('page')(

        tag()(''),

        content()(function() {
            return {
                block: 'link',
                mix: { block: 'b-pager', elem: 'page' },
                url: this.ctx.url,
                content: this.ctx.content || '&hellip;'
            };
        })
    ),

    elem('current').tag()('b'),

    elem('sorted')(

        tag()('p'),

        content()(function() {
            var ctx = [this.ctx.text + ' '],
                _this = this;
            this.ctx.items && this.ctx.items.forEach(function(item) {

                var i = {
                    elem: 'select',
                    tag: 'b',
                    content: item.text
                };
                if (!item.selected) {
                    i.elem = 'link';
                    i.tag = 'a';
                    i.attrs = {
                        href: _this._getUrl(0, {
                            param: _this.ctx.name,
                            value: item.name
                        })
                    }
                }

                ctx.push(i);
                ctx.push(' ');
            });

            return this.ctx.items && ctx;
        })
    )
);
