BEM.DOM.decl('b-pager', {

    onSetMod: {

        js: function() {

            if (!this.params.keydownReaction) return;

            // (varankinv@): LEGO-6591 - b-pager: поддержать mac os x lion
            // TODO: блок определяющий User Agent
            var macosVersion = navigator.userAgent.match(/mac os x (\d+)[._](\d+)/i);
            if (macosVersion) {

                var minorVersion = parseInt(macosVersion.pop(), 10),
                    majorVersion = parseInt(macosVersion.pop(), 10);

                if (majorVersion > 10 || (majorVersion === 10 && minorVersion > 6)) {
                    this.__self.MODIFIER_KEY = 'altKey';
                    this.elem('key').html(function(i, html) {
                        return html.replace('Ctrl', 'Alt');
                    });
                }

                this.isMac = true;

            }

            this.bindToDoc('keydown', this.onKeyDown);

        }

    },

    navigate: function(url) {
        url && (window.location.href = url);
    },

    onKeyDown: function(e) {

        // В Маке не должна быть зажата Cmd и Ctrl с Alt
        // (NOTE, varankinv): В MacOS 10.6 при нажатии на Cmd одновременно срабатывает meta и ctrl
        if (this.isMac && (e.ctrlKey && (e.metaKey || e.altKey))) return;

        if (!e.ctrlKey && !e.altKey || $(e.target).is('input, textarea') || (e.ctrlKey && e.shiftKey)) return;

        if (e[this.__self.MODIFIER_KEY]) {
            var elem = e.keyCode === 37 ? this.elem('prev') : e.keyCode === 39 ? this.elem('next') : null;
            elem && elem.attr('href') && this.navigate(elem.attr('href'));
        }

    }

}, {

    MODIFIER_KEY: 'ctrlKey'

});
