/**
 * @param {Number} totalPages
 * @param {Number} currentPage
 */
block('b-pager2')(
    js()(true),

    def()(function() {
        if (this.ctx.totalPages > 1) return applyNext();
    }),

    content()(function() {
        var pages = [],
            current;

        this.ctx.currentPage = this.ctx.currentPage || 1;

        for (var i = 0; i < this.ctx.totalPages; i++) {
            current = (i + 1);

            pages.push({
                elem: 'radio',
                elemMods: { checked: current == this.ctx.currentPage ? 'yes' : '' },
                controlAttrs: { value: current },
                content: current
            });
        }

        return {
            block: 'radio-button',
            content: pages
        };
    })
);
