BEM.DOM.decl('b-paranja', {

    onSetMod: {

        visible: {

            '': function() {
                this._updateSpinner(false);
            },

            yes: function() {
                this._updateSpinner(true);
            }

        }
    },

    /**
     * Включает или выключает спиннер в зависимости от переданного флага
     * @param {Boolean} draw
     * @private
     */
    _updateSpinner: function(draw) {
        /*
            у spin есть js реализация.
            Если какой либо блок внутри своей моды js выставит this._paranja.delMod('visible');
            то дом элемент спина будет удален а его колбек на моду js останется в очереди колбеков на инициализацию
            и блок спина упадет т.к. упадет у него будет отсутствовать DOM элемент.
            Подобная ситуация была обнаружена в блоке b-feeds-list.
            Для этого использован this.afterCurrentEvent
         */
        this.afterCurrentEvent(function() {
            BEM.DOM.update(
                this.domElem,
                draw ? BEMHTML.apply({
                    block: 'spin',
                    js: true,
                    mods: { progress: 'yes', theme: 'gray-48' },
                    mix: [{ block: 'b-paranja', elem: 'spin' }]
                }) :
                '');
        });
    }

});
