block('b-pay-select-credit-card')(
    match(function() {
        var cards = this.ctx.cards;

        return !cards || !cards.length;
    }).def()(function() {
        return '';
    }),

    js()(function() {
        return {
            cards: this.ctx.cards
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            cards = ctx.cards,
            size = ctx.size || 's';

        return {
            block: 'select2',
            mods: {
                size: size,
                theme: 'normal',
                width: 'max',
                type: 'radio'
            },
            mix: [
                { block: 'b-pay-select-credit-card', elem: 'select' }
            ],
            val: 0,
            button: {
                mix: [
                    { block: 'b-pay-select-credit-card', elem: 'button' }
                ],
                text: {
                    content: {
                        block: 'b-pay-select-credit-card',
                        elem: 'select-item',
                        card: cards[0]
                    }
                }
            },
            items: [].concat(
                cards.map(function(card) {
                    return {
                        val: card.card_id,
                        text: {
                            block: 'b-pay-select-credit-card',
                            elem: 'select-item',
                            card: card
                        }
                    };
                }),
                {
                    val: '',
                    text: iget2('b-pay-select-credit-card', 'new-card', 'Новая карта')
                }
            )
        };
    }),

    elem('select-item').content()(function() {
        var card = this.ctx.card;

        return [
            {
                block: 'b-pay-select-credit-card',
                elem: 'credit-card-system',
                elemMods: {
                    type: u['b-pay-select-credit-card'].getPaymentSystemModifier(card.system)
                }
            },
            card.number
        ];
    })
);
