BEM.DOM.decl('b-pay-select-credit-card', {
    onSetMod: {
        js: function() {
            var mgr = this._subscriptionManager = BEM.create('i-subscription-manager');

            u.graspSelf.call(this, {
                _creditCardSelect: 'select2 on select',
                _creditCardSelectButton: 'button2 on button'
            });

            mgr.on(this._creditCardSelect, 'change', this._onCreditCardSelect, this);
        }
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this.__base.apply(this, arguments);
    },

    _onCreditCardSelect: function(event, data) {
        var cardId = data.currVal,
            newCard = this.params.cards.find(function(card) {
                return card.card_id === cardId;
            }),
            content;

        if (newCard) {
            content = BEMHTML.apply({
                block: 'b-pay-select-credit-card',
                elem: 'select-item',
                card: newCard
            });
        } else {
            content = iget2('b-pay-select-credit-card', 'new-card', 'Новая карта')
        }
        BEM.DOM.update(this._creditCardSelectButton.elem('text'), content);

        this.trigger('change', data);
    }
});
