block('b-pay')(
    elem('autopayment').content()(function() {
        var ctx = this.ctx,
            autopaymentSum = ctx.autopaymentSum,
            autopaymentRemainingSum = ctx.autopaymentRemainingSum,
            clientNds = ctx.clientNds,
            workCurrency = ctx.workCurrency,
            isOfferAccepted = ctx.isOfferAccepted,
            autopaymentEnabled = ctx.autopaymentEnabled,
            currencySign = u.currencies.get(workCurrency).currency_sign;

        return [
            {
                block: 'checkbox',
                mix: [
                    { block: 'b-pay', elem: 'autopayment-enabled-checkbox' }
                ],
                mods: {
                    theme: 'normal',
                    size: 'm',
                    checked: autopaymentEnabled ? 'yes' : ''
                },
                text: iget2('b-pay', 'enable-autopayment', 'Включить автоплатёж')
            },
            {
                elem: 'autopayment-inputs',
                elemMods: {
                    hidden: autopaymentEnabled ? '' : 'yes'
                },
                content: iget2(
                    'b-pay',
                    'autopayment-inputs',
                    '{paymentSumInput} {currency} при остатке {remainingSumInput} {currency}', {
                        currency: currencySign,
                        remainingSumInput: {
                            block: 'input',
                            mix: [
                                { block: 'b-pay', elem: 'remaining-sum-input' }
                            ],
                            mods: {
                                size: 'l',
                                clear: 'no',
                                align: 'right'
                            },
                            value: u.numberFormatter.format(autopaymentRemainingSum || 0, { precision: 2 }),
                            content: {
                                elem: 'control'
                            }
                        },
                        paymentSumInput: {
                            block: 'input',
                            mix: [
                                { block: 'b-pay', elem: 'autopayment-sum-input' }
                            ],
                            mods: {
                                size: 'l',
                                clear: 'no',
                                align: 'right'
                            },
                            value: u.numberFormatter.format(autopaymentSum || 0, { precision: 2 }),
                            content: {
                                elem: 'control'
                            }
                        }
                    }
                )
            },
            {
                elem: 'autopayment-hint',
                elemMods: {
                    hidden: autopaymentEnabled ? '' : 'yes'
                },
                sum: autopaymentSum,
                remainingSum: autopaymentRemainingSum,
                workCurrency: workCurrency,
                nds: clientNds
            },
            (!this.ctx.isModerationsOfferFeatureEnabled || isOfferAccepted) && {
                elem: 'offer-checkbox',
                mix: {
                    block: 'b-pay',
                    elem: 'autopayment-offer-checkbox',
                    elemMods: {
                        hidden: autopaymentEnabled ? '' : 'yes'
                    }
                }
            }
        ]
    }),

    elem('autopayment-hint')(
        content()(function() {
            var ctx = this.ctx,
                sum = ctx.sum,
                remainingSum = ctx.remainingSum || 0.01,
                ndsPercent = ctx.nds || 0,
                sumWithNds = (ndsPercent / 100 + 1) * sum,
                ndsSum = (sumWithNds - sum),
                workCurrency = ctx.workCurrency,
                currencySign = u.currencies.get(workCurrency).currency_sign;

            if (!sumWithNds || sumWithNds < 0.01) return;

            return iget2(
                'b-pay',
                'autopayment-hint',
                'Каждый раз, когда на вашем счёте будет оставаться менее {remainingSum} {currency}, с карты будет списываться сумма — {sumWithNds} {currency}, включая НДС {ndsPercent}%  — {ndsSum} {currency}. На счёт будет зачиляться {sum} {currency}',
                {
                    sum: u.numberFormatter.round(sum),
                    remainingSum: u.numberFormatter.round(remainingSum),
                    currency: currencySign,
                    sumWithNds: u.numberFormatter.round(sumWithNds),
                    ndsPercent: ndsPercent,
                    ndsSum: u.numberFormatter.round(ndsSum)
                }
            )
        })
    )
);
