block('b-pay')(
    elem('pay-with-cash').content()(function() {
        var ctx = this.ctx,
            nds = ctx.clientNds,
            workCurrency = ctx.workCurrency,
            minSum = u.currencies.get(workCurrency)['MIN_PAY'] * (1 + nds / 100),
            cid = ctx.cid,
            name = ctx.name,
            splitCid = cid.split(''),
            formattedPaymentCode = '5007',
            currencySign = u.currencies.get(workCurrency).currency_sign,
            payWithCashHelpLink = 'https://yandex.ru/support/money/add/cash.html',
            newCashPaymentEnabled = ctx.newCashPaymentEnabled;

        while (splitCid.length) {
            formattedPaymentCode += ' ' + splitCid.splice(0, 4).join('');
        }

        return [
            !newCashPaymentEnabled && {
                elem: 'payment-code-title',
                content: iget2('b-pay', 'payment-code-title', 'Код платежа для оплаты заказа №{num} «{name}»', {
                    num: cid,
                    name: name
                })
            },
            !newCashPaymentEnabled && {
                elem: 'payment-code-number',
                content: [
                    {
                        elem: 'payment-code',
                        content: formattedPaymentCode
                    },
                    {
                        block: 'button2',
                        mods: {
                            size: 's',
                            theme: 'clear'
                        },
                        mix: [
                            { block: 'b-pay', elem: 'copy-payment-code-button' }
                        ],
                        icon: { mods: { 'size-16': 'copy' } }
                    },
                    {
                        block: 'b-help-link',
                        mods: {
                            theme: 'normal',
                            decoration: 'no'
                        },
                        url: payWithCashHelpLink,
                        text: iget2('b-pay', 'where-to-spend-my-hard-earned-cash', 'Где оплатить')
                    }
                ]
            },
            {
                elem: 'pay-with-cash-disclaimer',
                content: iget2('b-pay', 'cash-disclaimer', 'Минимальный платеж без учета комиссии терминала для сервиса  «Яндекс.Директ» — {sum} {currency}. Пожалуйста, сохраняйте квитанцию об оплате до завершения оказания услуг.', {
                    sum: minSum,
                    currency: currencySign
                })
            }
        ];
    })
);
