block('b-pay')(
    elem('switch-off-limit').content()(function() {
        var ctx = this.ctx,
            workCurrency = ctx.workCurrency,
            switchOffUpperLimit = ctx.switchOffUpperLimit,
            switchOffLimitEnabled = ctx.switchOffLimitEnabled,
            formattedLimit = u.numberFormatter.format(ctx.switchOffLimit || 0, { precision: 2 }),
            currencySign = u.currencies.get(workCurrency).currency_sign,
            isOfferAccepted = ctx.isOfferAccepted;

        return [
            {
                elem: 'table',
                mix: [
                    { block: 'b-pay', elem: 'switch-off-limit-table' }
                ],
                content: [
                    {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                elemMods: {
                                    number: 1
                                },
                                content: {
                                    block: 'checkbox',
                                    mix: [
                                        { block: 'b-pay', elem: 'switch-off-limit-checkbox' }
                                    ],
                                    mods: {
                                        theme: 'normal',
                                        size: 'm',
                                        checked: switchOffLimitEnabled ? 'yes' : 'no'
                                    },
                                    text: iget2('b-pay', 'switch-off-limit2', 'Порог отключения показов')
                                }
                            },
                            {
                                elem: 'cell',
                                elemMods: {
                                    number: 2
                                },
                                content: {
                                    elem: 'switch-off-limit-input-cell',
                                    mix: {
                                        block: 'b-pay',
                                        elem: 'switch-off-limit-input-cell'
                                    },
                                    elemMods: {
                                        hidden: switchOffLimitEnabled ? '' : 'yes'
                                    },
                                    formattedLimit: formattedLimit,
                                    workCurrency: workCurrency,
                                    currencySign: currencySign,
                                    switchOffUpperLimit: switchOffUpperLimit
                                }
                            }
                        ]
                    },
                    {
                        elem: 'row',
                        mix: {
                            block: 'b-pay',
                            elem: 'switch-off-limit-payers-row',
                            elemMods: {
                                hidden: switchOffLimitEnabled ? '' : 'yes'
                            }
                        },
                        content: [
                            {
                                elem: 'cell',
                                mix: [
                                    { block: 'b-pay', elem: 'switch-off-limit-payer-label' }
                                ],
                                elemMods: {
                                    number: 1
                                },
                                content: iget2('b-pay', 'payer', 'Плательщик')
                            },
                            {
                                elem: 'cell',
                                elemMods: {
                                    number: 2
                                },
                                content: {
                                    elem: 'switch-off-limit-select',
                                    items: [
                                        { val: '', text: iget2('b-pay', 'loading-payers', 'загрузка инфорации о плательщиках...'), elemMods: { disabled: 'yes' } }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            },
            (!this.ctx.isModerationsOfferFeatureEnabled || isOfferAccepted) && {
                elem: 'offer-checkbox',
                mix: {
                    block: 'b-pay',
                    elem: 'switch-off-limit-offer-checkbox',
                    elemMods: {
                        hidden: switchOffLimitEnabled ? '' : 'yes'
                    }
                }
            }
        ];
    }),

    elem('switch-off-limit-input-cell').content()(function() {
        var ctx = this.ctx,
            formattedLimit = ctx.formattedLimit,
            workCurrency = ctx.workCurrency,
            currencySign = ctx.currencySign,
            switchOffUpperLimit = ctx.switchOffUpperLimit;

        return [{
            block: 'input',
            mix: [
                { block: 'b-pay', elem: 'switch-off-limit-input' }
            ],
            mods: {
                size: 'xxl',
                clear: 'no',
                align: 'right'
            },
            content: {
                elem: 'control'
            },
            value: formattedLimit
        },
            currencySign,
        {
            elem: 'switch-off-limit-suffix',
            upperLimit: switchOffUpperLimit,
            workCurrency: workCurrency
        }]
    }),

    elem('switch-off-limit-select').replace()(function() {
        var ctx = this.ctx,
            items = ctx.items,
            val = ctx.value;

        return {
            block: 'select2',
            mix: [
                { block: 'b-pay', elem: 'switch-off-limit-select' }
            ],
            val: val,
            mods: {
                theme: 'normal',
                size: 'n',
                type: 'radio',
                text: 'vary'
            },
            items: items
        };
    }),

    elem('switch-off-limit-suffix').content()(function() {
        var ctx = this.ctx,
            workCurrency = ctx.workCurrency,
            upperLimit = ctx.upperLimit,
            currencySign = u.currencies.get(workCurrency).currency_sign;

        return iget2('b-pay', 'available-switch-off-limit', 'Доступный порог – {limit} {currency}', {
            limit: u.numberFormatter.format(upperLimit || 0, { precision: 2 }),
            currency: currencySign
        });
    })
);
