BEM.DOM.decl({ block: 'b-pay', elem: 'trust-frame-switcher' }, {
    onSetMod: {
        js: function() {
            this._subscribeOnTrustEvents();
        }
    },

    _openCreditCardFrame: function() {
        var parent = this.getParent(),
            model = parent._model,
            is_legal = model.get('payment_method') === 'card-legal',
            autoPaymentEnabled = model.get('autopaymentAgreedTo'),
            shouldBindCard = autoPaymentEnabled && !model.get('credit_card_id');

        parent._setSubmitButtonProgress(true);

        BEM.blocks['i-web-api-request'].payment.getTrustLink(u.consts('ulogin'), {
            sum: model.get('sum_with_nds'),
            card_id: model.get('credit_card_id') || null,
            is_ur: is_legal,
            promocode: model.get('promocode').trim() || undefined,
            remaining_sum: autoPaymentEnabled ? model.get('remaining_sum') : undefined,
            autopayment_sum: autoPaymentEnabled ? model.get('autopayment_sum') : undefined,
            is_mobile: Boolean(parent.params.isTouch)
        }).then(function(response) {
            var frameTitle = shouldBindCard ?
                iget2('b-pay', 'trust-frame-title-bind', 'Привязка карты') :
                iget2('b-pay', 'trust-frame-title-pay', 'Пополнение общего счета'),
                errors = response.validationResult && response.validationResult.errors;

            parent._setSubmitButtonProgress(false);

            if (Array.isArray(errors) && errors.length > 0) {
                parent._renderErrors(u['b-pay']._getErrorMessage(errors, parent.params.currency));

                BEM.blocks['b-metrika2'].params({
                    params: {
                        payment: {
                            'validation-failed': '1',
                            'validation-error-codes': errors.map(function(error) {
                                return error.path + ':' + error.code;
                            }).join(' ')
                        }
                    }
                });

                return;
            }

            this._formVersion = Number(response.formVersion) || 1;
            this._firstStepUrl = shouldBindCard ? response.bindingUrl : response.paymentUrl;
            this._secondStepUrl = shouldBindCard ? response.paymentUrl : undefined;

            model.set('promocode', '');

            if (this._parent.params.isIframeContent) {
                this._parent._sendPostMessage(
                    'open-payment',
                    {
                        title: frameTitle,
                        formVersion: this._formVersion,
                        firstStepUrl: this._firstStepUrl,
                        secondStepUrl: this._secondStepUrl
                    }
                );
            } else {
                this._iframe = BEM.DOM.append(this.domElem, BEMHTML.apply({
                    block: 'b-iframe-modal',
                    src: this._firstStepUrl,
                    title: frameTitle,
                    width: 800,
                    height: 600
                })).bem('b-iframe-modal');

                this._iframe.getEventBus()
                    .on('need-close', function() {
                        window.location.reload();
                    });
            }
        }.bind(this))
            .catch(function() {
                model.set('promocode', '');

                parent._setSubmitButtonProgress(false);
                parent._renderError(iget2('b-pay', 'unexpected-error', 'Что-то пошло не так, попробуйте еще раз позже'));
                BEM.blocks['b-metrika2'].params({
                    params: {
                        payment: {
                            'trust-payment-failed': '1'
                        }
                    }
                });
            }.bind(this));
    },

    _subscribeOnTrustEvents: function() {
        if (typeof window === 'undefined') {
            return;
        }

        window.addEventListener('message', function(event) {
            var data;
            try {
                data = JSON.parse(event.data);
            } catch (e) {
                return;
            }
            if (data.source !== 'YandexTrustPaymentForm') {
                return;
            }

            if (this._formVersion === 1) {
                this._onV1TrustFromMessage(data);
            }

            if (this._formVersion === 2) {
                this._onV2TrustFormMessage(data);
            }
        }.bind(this));
    },

    _onV2TrustFormMessage: function(data) {
        if (data.type === 'payment-complete') {
            this._onPaymentSuccess();
        }
    },

    _onV1TrustFromMessage: function(data) {
        if (data.type === 'payment-status' && data.data && data.data.value === 'success') {
            this._onPaymentSuccess();
        }
    },

    _onPaymentSuccess: function() {
        if (this._secondStepUrl) {
            this._iframe
                .setTitle(iget2('b-pay', 'trust-frame-title-pay', 'Пополнение общего счета'))
                .setSrc(this._secondStepUrl);

            return;
        }

        BEM.blocks['b-metrika2'].params({
            params: {
                payment: {
                    'trust-payment-finalized': '1'
                }
            }
        });
    }
});
