BEM.DOM.decl({ name: 'b-pay', modName: 'nds', modVal: 'no' }, {

    onSetMod: {

        js: function() {
            u.graspSelf.call(this, {
                sum_money_local: '? b-toggle-input on sum-money-local',
                sum: 'b-toggle-input on sum'
            });

            this.__base.apply(this, arguments);

            ['sum', 'sum_money_local'].map(function(name) {
                if (!this[name]) return;

                this._model.on(name, 'change', this._onModelChanged, this);

                this[name]
                    .on('toggle', { name: name }, this._onInputToggle, this)
                    .on('change', { name: name }, this._onInputChange, this)
                    .on('blur', { name: name }, this._onInputBlur, this);
            }, this);

            this._onModelChanged({}, { field: 'sum', value: this.params.defaultSum, isInit: true });

            this.sum_money_local &&
                this._onInputBlur({ data: { name: 'sum_money_local' } });
        }

    },

    /**
     * Возвращает имя парного поля модели по имени указанного поля
     * @param {String} name
     * @returns {String}
     * @protected
     */
    _getOtherName: function(name) {
        return name == 'sum' ? 'sum_money_local' : 'sum';
    },

    /**
     * Возвращает значение парного поля модели по имени и значению указанного поля
     * @param {String} fieldName
     * @param {Number} fieldValue
     * @returns {Number}
     * @protected
     */
    _calcOtherValue: function(fieldName, fieldValue) {
        return fieldName == 'sum' ? fieldValue * this.params.rate : fieldValue / this.params.rate;
    },

    /**
     * Обработчик изменения модели
     * @param {jQuery.Event} e
     * @param {Object} data
     * @returns {BEM.DOM}
     * @protected
     */
    _onModelChanged: function(e, data) {
        var otherValue,
            toUpdate = {},
            fieldName = data.field,
            value = this._model.get(fieldName, 'raw');

        if (this[fieldName].getMod('focused') == 'yes' || data.isInit) {
            otherValue = this._calcOtherValue(fieldName, value);
            toUpdate[this._getOtherName(fieldName)] = otherValue;
            this._model.update(toUpdate, { source: this });
        } else {
            this[fieldName].val(this._getValueFromModel(fieldName))
        }

        return this;
    }

});
