BEM.DOM.decl({ name: 'b-pay', modName: 'nds', modVal: 'yes' }, {

    onSetMod: {

        js: function() {
            var isNewPaymentWorkFlow = this.getMod('new-payment-workflow') === 'yes';
            if (isNewPaymentWorkFlow) {
                u.graspSelf.call(this, {
                    sum_with_nds: 'input on sum-with-nds',
                    sum: 'input on sum-without-nds',
                    nds_label: '? nds-label'
                });
            } else {
                u.graspSelf.call(this, {
                    sum_with_nds: 'b-toggle-input on sum-with-nds',
                    sum: 'b-toggle-input on sum-without-nds'
                });
            }

            // НДС приходит с сервера в процентах
            this._nds = this.params.nds / 100;

            this.__base.apply(this, arguments);

            this._model
                .on('sum sum_with_nds', 'change', this._onModelChanged, this)
                .on('nds', 'change', function() {
                    this.elem('nds') && this.elem('nds').text(this._getValueFromModel('nds'));
                    this.nds_label && this.nds_label.text(
                        iget2('b-pay', 'nds-with-sum', 'Включая НДС {tax}% — {ndsSum}{currency}', {
                            tax: +this.params.nds.toString(),
                            ndsSum: this._getValueFromModel('nds'),
                            currency: u.currencies.get(this.params.currency).currency_sign,
                        })
                    );
                }, this);

            ['sum', 'sum_with_nds'].map(function(name) {
                this[name]
                    .on('toggle', { name: name }, this._onInputToggle, this)
                    .on('change', { name: name }, this._onInputChange, this)
                    .on('blur', { name: name }, this._onInputBlur, this);
            }, this);

            this._onModelChanged({}, { field: 'sum', value: this.params.defaultSum, isInit: true });
            this._onInputBlur({ data: { name: 'sum_with_nds' } });
        }

    },

    /**
     * Обработчик изменения модели
     * @param {jQuery.Event} e
     * @param {Object} data
     * @returns {BEM.DOM}
     * @protected
     */
    _onModelChanged: function(e, data) {
        var value = data.value,
            otherValue,
            toUpdate = {},
            fieldName = data.field;

        if (this[fieldName].getMod('focused') == 'yes' || data.isInit) {
            otherValue = this._calcOtherValue(fieldName, value);

            toUpdate[this._getOtherName(fieldName)] = otherValue;
            toUpdate.nds = Math.abs(value - otherValue);

            this._model.update(toUpdate, { source: this });
        } else {
            this[fieldName].val(this._getValueFromModel(fieldName))
        }

        return this;
    },

    /**
     * Возвращает имя парного поля модели по имени указанного поля
     * @param {String} name
     * @returns {String}
     * @protected
     */
    _getOtherName: function(name) {
        return name == 'sum' ? 'sum_with_nds' : 'sum';
    },

    /**
     * Возвращает значение парного поля модели по имени и значению указанного поля
     * @param {String} fieldName
     * @param {Number} fieldValue
     * @returns {Number}
     * @protected
     */
    _calcOtherValue: function(fieldName, fieldValue) {
        return fieldName == 'sum' ? this._calcWithNdsValue(fieldValue) : this._calcWithoutNdsValue(fieldValue);
    },

    /**
     * Вычисляет значение суммы платежа с НДС по сумме платежа без НДС
     * @param {String|Number} withoutNdsVal
     * @returns {Number}
     * @private
     */
    _calcWithNdsValue: function(withoutNdsVal) {
        withoutNdsVal = +withoutNdsVal;

        return withoutNdsVal + this._nds * withoutNdsVal;
    },

    /**
     * Вычисляет значение суммы без НДС по известному значению с НДС
     * @param {String|Number} withNdsVal
     * @returns {Number}
     * @private
     */
    _calcWithoutNdsValue: function(withNdsVal) {
        return +withNdsVal / (1 + this._nds);
    }

});
