block('b-pay').mod('new-payment-workflow', 'yes')(
    elem('form-body').content()(function() {
        var ctx = this.ctx;

        return [].concat(
            applyNext({
                'ctx.paymentMethod': ctx.paymentMethod,
                'ctx.needOverdraftPaymentMethod': ctx.needOverdraftPaymentMethod,
            }),
            ctx.autopaymentAllowed && {
                elem: 'autopayment',
                elemMods: {
                    'no-offer': ctx.isModerationsOfferFeatureEnabled ? '' : 'yes'
                },
                autopaymentSum: ctx.autopaymentSum,
                autopaymentEnabled: ctx.autopaymentEnabled,
                autopaymentRemainingSum: ctx.autopaymentRemainingSum,
                clientNds: ctx.clientNds,
                withNds: ctx.withNds,
                workCurrency: ctx.workCurrency,
                isOfferAccepted: ctx.isOfferAccepted,
                isModerationsOfferFeatureEnabled: ctx.isModerationsOfferFeatureEnabled
            },
            ctx.switchOffLimitAllowed && {
                elem: 'switch-off-limit',
                elemMods: {
                    'no-offer': ctx.isModerationsOfferFeatureEnabled ? '' : 'yes'
                },
                workCurrency: ctx.workCurrency,
                switchOffLimit: ctx.switchOffLimit,
                switchOffLimitEnabled: ctx.switchOffLimitEnabled,
                switchOffUpperLimit: ctx.switchOffUpperLimit,
                isOfferAccepted: ctx.isOfferAccepted,
                isModerationsOfferFeatureEnabled: ctx.isModerationsOfferFeatureEnabled
            },
            {
                elem: 'pay-with-cash',
                cid: ctx.payWithCashCid,
                name: ctx.payWithCashName,
                clientNds: ctx.clientNds,
                workCurrency: ctx.workCurrency,
                newCashPaymentEnabled: ctx.newCashPaymentEnabled,
                promocode: ctx.promocode
            },
            {
                elem: 'trust-frame-switcher'
            }
        );
    }),

    elem('pay-with-nds').replace()(function() {
        var ctx = this.ctx,
            formattedSum = ctx.formattedSum,
            workCurrency = ctx.workCurrency,
            paymentMethod = ctx.paymentMethod,
            promocode = ctx.promocode,
            needOverdraftPaymentMethod = ctx.needOverdraftPaymentMethod,
            warnSum = u['b-pay']._getRecommendationSum('warn', workCurrency);

        return [
            {
                elem: 'pay-settings',
                content: [{
                    elem: 'pay-settings-row',
                    content: [
                        {
                            elem: 'pay-settings-cell',
                            content: [
                                {
                                    elem: 'to-enroll-label',
                                    content: iget2('b-pay', 'to-enroll', 'Зачислить на счёт', {
                                        currency: u.currencies.get(workCurrency).currency_sign
                                    }),
                                },
                                {
                                    block: 'input',
                                    mix: [
                                        { block: 'b-pay', elem: 'sum-without-nds' }
                                    ],
                                    mods: {
                                        size: 'xxl',
                                        clear: 'no',
                                        align: 'right'
                                    },
                                    content: { elem: 'control' },
                                    value: formattedSum
                                },
                                {
                                    elem: 'min-pay-label',
                                    content: iget2('b-pay', 'min-sum-warning', 'Не менее {minSum}{currency}', {
                                        minSum: u.numberFormatter.format(u.currencies.get(workCurrency)['MIN_PAY'], { precision: 2 }),
                                        currency: u.currencies.get(workCurrency).currency_sign,
                                    })
                                }],
                        },
                        {
                            elem: 'pay-settings-cell',
                            mix: [{
                                block: 'b-pay',
                                elem: 'tooltip-container'
                            }],
                            content: [
                                {
                                    elem: 'to-spend-label',
                                    content: iget2('b-pay', 'to-spend', 'Будет списано', {
                                        currency: u.currencies.get(workCurrency).currency_sign
                                    }),
                                },
                                {
                                    block: 'input',
                                    mix: [
                                        { block: 'b-pay', elem: 'sum-with-nds' },
                                        warnSum && {
                                            block: 'b-feature-marker',
                                            js: {
                                                featureId: 'substantial-payment-tooltip',
                                                dynamic: true,
                                                direction: 'bottom-right',
                                                secondaryOffset: -33,
                                                text: {
                                                    block: 'b-pay',
                                                    elem: 'substantial-payment-tooltip',
                                                    currency: workCurrency,
                                                    sum: warnSum
                                                },
                                            }
                                        }
                                    ],
                                    mods: {
                                        size: 'xxl',
                                        clear: 'no',
                                        align: 'right'
                                    },
                                    content: { elem: 'control' },
                                    value: ''
                                },
                                {
                                    elem: 'nds-label'
                                }
                            ]
                        }
                    ]
                },
                {
                    elem: 'payment-method',
                    paymentMethod: paymentMethod,
                    needOverdraftPaymentMethod: needOverdraftPaymentMethod
                }]
            },
            {
                elem: 'apply-promocode',
                promocode: promocode
            },
            u.consts('isPromocodeHintEnabled') && {
                elem: 'promocode-promo'
            }
        ];
    }),

    elem('promocode-promo').replace()(function() {
        return {
            elem: 'promocode-promo-row',
            elemMods: { hidden: 'yes' },
            content: [
                {
                    block: 'icon',
                    mix: [
                        {
                            block: 'b-pay',
                            elem: 'promocode-promo-icon'
                        }
                    ],
                    mods: {
                        'size-13': 'info'
                    }
                },
                iget2('b-pay', 'promocode-promo', 'Промокод вы сможете ввести на следующем шаге')
            ]
        }
    }),

    elem('apply-promocode').replace()(function() {
        return {
            elem: 'promocode-row',
            elemMods: { hidden: 'yes' },
            content: [
                {
                    elem: 'apply-promocode-label',
                    content: iget2('b-pay', 'promocode', 'Промокод')
                },
                {
                    elem: 'apply-promocode-input',
                    content: [
                        {
                            block: 'input',
                            mods: {
                                size: 'xxl',
                                autocomplete: 'off'
                            },
                            mix: [{
                                block: 'b-pay',
                                elem: 'promo-code'
                            }],
                            content: { elem: 'control' },
                            value: this.ctx.promocode
                        }
                    ]
                },
                {
                    elem: 'apply-promocode-details',
                    content: [
                        iget2('b-pay', 'apply-promocode-msg2', 'Номинал промокода будет зачислен на ваш счёт после оплаты')
                    ]
                },
            ]
        };
    }),

    elem('content').content()(function() {
        return [
            {
                block: 'b-pay',
                elem: 'spin',
                content: {
                    block: 'spin2',
                    mods: {
                        size: 's',
                        progress: 'yes'
                    }
                }
            },
            applyNext()
        ];
    }),

    elem('payment-method').replace()(function() {
        var ctx = this.ctx,
            paymentMethod = ctx.paymentMethod

        return [
            {
                elem: 'pay-settings-row',
                mix: [
                    { block: 'b-pay', elem: 'payment-method' }
                ],
                content: [
                    // Выбор типа плательщика пока убираем, он будет сделан вместе с формой создания плательщика.
                    /*{
                        elem: 'pay-settings-cell',
                        content: [
                            {
                                elem: 'label',
                                content: iget2('b-pay', 'payer', 'Плательщик')
                            },
                            {
                                block: 'select2',
                                mix: [
                                    { block: 'b-pay', elem: 'payer-select' }
                                ],
                                mods: {
                                    size: 'n',
                                    theme: 'normal',
                                    text: 'vary',
                                    width: 'max',
                                    type: 'radio'
                                },
                                val: 'phys',
                                items: [
                                    { val: 'phys', text: iget2('b-pay', 'phys-person', 'Физическое лицо') },
                                    { val: 'legal', text: iget2('b-pay', 'legal-person', 'Юридическое лицо') }
                                ]
                            }
                        ]
                    },*/
                    {
                        elem: 'pay-settings-cell',
                        content: [
                            {
                                elem: 'payment-method-label',
                                content: iget2('b-pay', 'payment-method', 'Способ оплаты'),
                            },
                            {
                                elem: 'payment-method-select',
                                val: paymentMethod,
                                items: []
                            },
                            {
                                elem: 'payment-term',
                                content: u['b-pay']._getPaymentTermMessage(paymentMethod)
                            }
                        ]
                    },
                    {
                        elem: 'pay-settings-cell',
                        mix: [
                            { block: 'b-pay', elem: 'card-select-cell' }
                        ],
                    }
                ]
            }
        ];
    }),

    elem('payment-method-select').replace()(function() {
        var val = this.ctx.val,
            items = this.ctx.items;

        return {
            block: 'select2',
            mix: [
                { block: 'b-pay', elem: 'payment-method-select' }
            ],
            mods: {
                size: 'n',
                theme: 'normal',
                text: 'vary',
                width: 'max',
                type: 'radio'
            },
            val: val,
            items: items
        }
    })
);
