block('b-pay').mod('new-payment-workflow', 'yes')(
    def()(function() {
        var wallet = this.wallet,
            data = this.data,
            paymentSuggestBlock = data.payment_suggest_block,
            autopayParams = data.autopay_suggest || {},
            switchOffLimitParams = data.autooverdraft_params || {},
            switchOffLowerLimit = +switchOffLimitParams.auto_overdraft_lower_limit,
            switchOffUpperLimit = +switchOffLimitParams.auto_overdraft_upper_limit,
            needOverdraftPaymentMethod = Boolean(!+switchOffLimitParams.is_banned && !!switchOffUpperLimit &&
                +switchOffLimitParams.auto_overdraft_lim === 0),
            switchOffLimitAllowed = paymentSuggestBlock === 'autooverdraft' && !+switchOffLimitParams.is_banned && !!switchOffUpperLimit,
            payerType = 'phys',
            paymentMethod = 'card',
            autopaymentAllowed = paymentSuggestBlock === 'autopay' ||
                paymentSuggestBlock === 'autopay_opt_out' ||
                paymentSuggestBlock === 'autopay_save',
            autopaymentEnabled = autopaymentAllowed && (
                paymentSuggestBlock === 'autopay' ||
                ( paymentSuggestBlock === 'autopay_save' ? !!(+(data.COOKIES.autopay_mem_val || 1)) : false )
            ),
            switchOffLimitCoeff = +data.autooverdraft_suggest_coef || 1,
            autopaymentSum = +autopayParams.payment_sum,
            queryParams = u.getUrlParams(),
            autopaymentEnabledFromQueryParams = queryParams['autopayment'],
            autopaySumFromQueryParams = +queryParams['autopay-sum'];

        if (autopaymentEnabledFromQueryParams !== undefined) {
            autopaymentEnabled = autopaymentAllowed && autopaymentEnabledFromQueryParams === '1';
            autopaymentSum = (autopaymentEnabled && autopaySumFromQueryParams > 0) ? autopaySumFromQueryParams : autopaymentSum;
        }

        return applyNext({
            isTouch: this.ctx.isTouch,
            autopaymentAllowed: autopaymentAllowed,
            autopaymentEnabled: autopaymentEnabled,
            autopaymentSum: autopaymentSum,
            autopaymentMemoryPeriodDays: paymentSuggestBlock === 'autopay_save' && +data.autopay_save_period,
            autopaymentRemainingSum: +autopayParams.remaining_sum,
            isModerationsOfferFeatureEnabled: u.consts('isModerationsOfferFeatureEnabled'),
            switchOffLimitAllowed: switchOffLimitAllowed,
            switchOffLimitEnabled: switchOffLimitAllowed && true,
            switchOffUpperLimit: switchOffUpperLimit,
            switchOffLowerLimit: switchOffLowerLimit,
            switchOffLimit: switchOffUpperLimit * switchOffLimitCoeff,
            switchOffLimitCoeff: switchOffLimitCoeff,
            needOverdraftPaymentMethod: needOverdraftPaymentMethod,
            payerType: payerType,
            paymentMethod: paymentMethod,
            promocode: u.escapeHTML(data.FORM.promocode),
            payWithCashCid: wallet ? wallet.wallet_cid : data.cid,
            payWithCashName: wallet ? iget2('b-pay', 'common-wallet', 'Общий счёт') : data.name,
            isIframeContent: this.ctx.isIframeContent,
            isOfferAccepted: this.ctx.isOfferAccepted,
            hidePayWithCash: u.consts('hidePayWithCash')
        });
    }),

    addJs()(function() {
        return {
            isTouch: this.isTouch,
            autopaymentAllowed: this.autopaymentAllowed,
            autopaymentEnabled: this.autopaymentEnabled,
            autopaymentSum: this.autopaymentSum,
            autopaymentMemoryPeriodDays: this.autopaymentMemoryPeriodDays,
            autopaymentRemainingSum: this.autopaymentRemainingSum,
            switchOffLimitAllowed: this.switchOffLimitAllowed,
            switchOffLimitEnabled: this.switchOffLimitEnabled,
            switchOffLowerLimit: this.switchOffLowerLimit,
            switchOffUpperLimit: this.switchOffUpperLimit,
            switchOffLimit: this.switchOffLimit,
            switchOffLimitCoeff: this.switchOffLimitCoeff,
            paymentMethod: this.paymentMethod,
            isPageContentView: this.ctx.isPageContentView,
            isModerationsOfferFeatureEnabled: u.consts('isModerationsOfferFeatureEnabled'),
            needOverdraftPaymentMethod: this.needOverdraftPaymentMethod,
            hidePayWithCash: this.hidePayWithCash
        };
    }),

    mode('form-body')(function() {
        var formBody = applyNext();

        formBody.isTouch = this.isTouch;
        formBody.payWithCashCid = this.payWithCashCid;
        formBody.payWithCashName = this.payWithCashName;
        formBody.paymentMethod = this.paymentMethod;
        formBody.switchOffLimitAllowed = this.switchOffLimitAllowed;
        formBody.switchOffLimitEnabled = this.switchOffLimitEnabled;
        formBody.switchOffUpperLimit = this.switchOffUpperLimit;
        formBody.switchOffLimit = this.switchOffLimit;
        formBody.autopaymentAllowed = this.autopaymentAllowed;
        formBody.autopaymentEnabled = this.autopaymentEnabled;
        formBody.autopaymentSum = this.autopaymentSum;
        formBody.promocode = this.promocode;
        formBody.autopaymentRemainingSum = this.autopaymentRemainingSum;
        formBody.needOverdraftPaymentMethod = this.needOverdraftPaymentMethod;
        formBody.newCashPaymentEnabled = this.newCashPaymentEnabled;

        formBody.elemMods = u._.extend(
            formBody.elemMods || {},
            { 'new-payment-workflow': 'yes' }
        );

        return formBody;
    }),

    content()(function() {
        var isPageContentView = this.ctx.isPageContentView,
            formContent = {
                block: 'b-pay',
                elem: 'content-wrapper',
                content: {
                    block: 'b-pay',
                    mods: {
                        'new-payment-workflow': 'yes'
                    },
                    elem: 'content',
                    elemMods: {
                        'has-balance-cart': 'no',
                        'new-payment-workflow': 'yes',
                        'payment-method': this.paymentMethod,
                        'single-legal-payer': 'no',
                        'new-cash-payment': this.newCashPaymentEnabled ? 'yes' : 'no',
                        loading: 'yes',
                        'has-close-button': !isPageContentView
                    },
                    formBody: apply('form-body'),
                    isOfferAccepted: this.ctx.isOfferAccepted
                }
            };
        var blockContent;

        if (isPageContentView) {
            blockContent = [formContent];
        } else {
            blockContent = [
                {
                    block: 'button',
                    mix: [
                        { block: 'b-pay', elem: 'open-popup-button' }
                    ],
                    mods: {
                        pseudo: 'yes',
                        theme: 'action',
                        disabled: this.ctx.mods.disabled ? 'yes' : '',
                        size: this.ctx.btnSize
                    },
                    content: this.ctx.btnText || iget2('b-pay', 'add-money', 'Пополнить')
                },
                {
                    block: 'modal',
                    mix: [
                        { block: 'b-pay', elem: 'payment-popup' }
                    ],
                    mods: {
                        theme: 'normal',
                    },
                    content: formContent
                }
            ];
        }

        blockContent.push({
            elem: 'form',
            cid: this.ctx.cid,
            userLogin: this.ctx.userLogin
        });

        return blockContent;
    })
);
