BEM.DOM.decl({ block: 'b-pay', modName: 'new-payment-workflow', modVal: 'yes' }, {

    modelPaymentMethodsToApiPaymentMethodsDictionary: {
        card: 'card',
        'card-legal': 'card',
        wire: 'bank'
    },

    paymentMethodToPayerTypeDict: {
        card: 'phys',
        cash: 'phys',
        other: 'phys',
        'card-legal': 'legal',
        wire: 'legal',
        overdraft: 'legal'
    },

    onSetMod: {
        js: function() {
            var params = this.params;

            // кэшируем элементы до того, как открылся попап
            this.elem('promocode-row');
            this.elem('promocode-promo-row');
            this.elem('payment-term');

            this.__base.apply(this, arguments);

            this._trustSwitcher = this.elem('trust-frame-switcher').bem({ block: 'b-pay', elem: 'trust-frame-switcher' });

            u.graspSelf.call(this, {
                _page: 'b-page outside',
                _promoCode: '? input on promo-code',
                _paymentModal: '? modal on payment-popup',
                _cardSelectCell: '? card-select-cell',
                _payerTypeSelect: '? select2 on payer-select',
                _paymentMethodSelect: '? select2 on payment-method-select',
                _autopaymentEnabledCheckbox: '? checkbox on autopayment-enabled-checkbox',
                _autopaymentInputs: '? autopayment-inputs',
                _autopaymentHint: '? autopayment-hint',
                _autopaymentOfferCheckbox: '? autopayment-offer-checkbox',
                remaining_sum: '? input inside remaining-sum-input',
                autopayment_sum: '? input inside autopayment-sum-input',
                _switchOffLimit: '? switch-off-limit',
                _switchOffLimitEnabledCheckbox: '? checkbox on switch-off-limit-checkbox',
                _switchOffLimitInputCell: '? switch-off-limit-input-cell',
                _switchOffLimitPayersRow: '? switch-off-limit-payers-row',
                _switchOffLimitSelect: '? select2 on switch-off-limit-select',
                _switchOffLimitSuffix: '? switch-off-limit-suffix',
                _switchOffLimitOfferCheckbox: '? switch-off-limit-offer-checkbox',
                switch_off_limit: '? input inside switch-off-limit-input',
                _paymentCode: 'payment-code',
                _copyPaymentCodeButton: 'copy-payment-code-button',
                _commonOffer: '? common-offer'
            });

            this.findBlocksInside('b-toggle-input').forEach(function(toggleInput) {
                toggleInput.findBlockInside('input').setMod('size', 'm');
            });

            if (params.isTouch) {
                this.findBlocksInside('input').forEach(function(inputItem) {
                    inputItem.on('focus', function(event) {
                        // здесь делаем задержку, чтобы клавиатура успела открыться и инпут спозиционировался правильно
                        setTimeout(function() {
                            event.block.domElem[0].scrollIntoView({ behavior: 'smooth', block: 'center' });
                        }, 300);
                    }, this);
                })
            }

            this._model.update({
                payer_type: params.payerType,
                payment_method: params.paymentMethod,
                autopayment_enabled: params.autopaymentEnabled,
                autopayment_sum: params.autopaymentSum,
                remaining_sum: params.autopaymentRemainingSum,
                switch_off_limit_enabled: params.switchOffLimitEnabled,
                switch_off_lower_limit: params.switchOffLowerLimit,
                switch_off_upper_limit: params.switchOffUpperLimit,
                switch_off_limit: params.switchOffLimit,
                hasSingleLegalPayer: false
            });

            this._model.on('promocode', 'change', function(e, data) {
                var notAllowed = !this._model.get('canUsePromocodes'),
                    notNow = this._promoCode.hasMod('focused', 'yes');

                if (notAllowed) {
                    return;
                }

                this._promoCode.val(this._model.get(data.field))
            }, this);

            this._firstRun = true;

            this._initSubs();
            this._initDefaultPaymentMethod();
        }
    },

    _initSubs: function() {
        this.__base.apply(this, arguments);

        var mgr = this._subscriptionManager;

        if (this.params.isPageContentView) {
            this._initFormContent();
        } else {
            mgr.wrap(this._paymentModal)
                .on('beforeOpen', this._onBeforeModalOpen, this)
                .on('afterClose', this._onAfterModalClose, this);
        }

        if (this._payerTypeSelect) {
            mgr.on(this._payerTypeSelect, 'change', this._onPayerTypeSelectChange, this);
        }
        mgr.on(this._paymentMethodSelect, 'change', this._onPaymentMethodSelect, this);

        this._autopaymentEnabledCheckbox && mgr.on(this._autopaymentEnabledCheckbox, 'change', this._onEnableAutopayment, this);

        this.remaining_sum && mgr.wrap(this.remaining_sum)
            .on('change', { name: 'remaining_sum' }, this._onInputChange, this)
            .on('change', this._onAutoPaymentSumsChange, this)
            .on('blur', { name: 'remaining_sum' }, this._onInputBlur, this);

        this.autopayment_sum && mgr.wrap(this.autopayment_sum)
            .on('change', { name: 'autopayment_sum' }, this._onInputChange, this)
            .on('change', this._onAutoPaymentSumsChange, this)
            .on('blur', { name: 'autopayment_sum' }, this._onInputBlur, this);

        this._switchOffLimitEnabledCheckbox && mgr.on(this._switchOffLimitEnabledCheckbox, 'change', this._onEnableSwitchOffLimit, this);

        this.switch_off_limit && mgr.wrap(this.switch_off_limit)
            .on('change', { name: 'switch_off_limit' }, this._onInputChange, this)
            .on('blur', { name: 'switch_off_limit' }, this._onInputBlur, this);

        if (this._promoCode) {
            mgr.wrap(this._promoCode).on('change', function() {
                var notAllowed = !this._model.get('canUsePromocodes'),
                    notNow = !this._promoCode.hasMod('focused', 'yes');

                if (notAllowed || notNow) {
                    return;
                }

                this._model.set('promocode', this._promoCode.val(), { source: this });

                this.delMod(this.elem('content'), 'errors');
            }, this);
        }
    },

    _onSubmit: function() {
        var isSingleLegalPayer = this._model.get('hasSingleLegalPayer'),
            paymentMethod = this._model.get('payment_method'),
            isSwitchOffLimitEnabled = this._model.get('switch_off_limit_enabled');

        if (this.getMod(this._switchOffLimit, 'hidden') === 'yes') {
            this._model.set('switch_off_limit_enabled', false);
        }

        var sumWithoutNds = this._model.get('sum');
        if (!this._model.validate().valid) {
            if (sumWithoutNds === 0) {
                u.userOptions.remove('payment_sum');
            }
            return;
        }

        this._model.set('switch_off_limit_enabled', isSwitchOffLimitEnabled);
        u.userOptions.set('payment_sum', sumWithoutNds);

        switch (true) {
            case paymentMethod === 'card':
            case paymentMethod === 'card-legal' && isSingleLegalPayer:
                this._tryToSubmitSwitchOffLimit();
                this._trustSwitcher._openCreditCardFrame();
                u.payment.setOfferAccepted();
                break;
            case paymentMethod === 'card-legal' && !isSingleLegalPayer:
            case paymentMethod === 'wire':
                this._tryToSubmitSwitchOffLimit().then(function() {
                    this._submitForm();
                }.bind(this));
                break;
            case paymentMethod === 'overdraft':
            case paymentMethod === 'promocode':
            case paymentMethod === 'other':
                this._submitForm();
                break;
            case paymentMethod === 'cash':
                this._submitPayWithCash();
                break;
        }

        BEM.blocks['b-metrika2'].params({
            params: {
                payment: {
                    method: paymentMethod,
                    'balance-cart': '0'
                }
            }
        });
    },

    _addToBalanceCart: function() {
        var paymentMethod;
        this.__base.apply(this, arguments);

        paymentMethod = this._model.get('payment_method');

        if (paymentMethod === 'card-legal' && this._model.validate().valid) {
            this._tryToSubmitSwitchOffLimit();
        }

        BEM.blocks['b-metrika2'].params({
            params: {
                payment: {
                    method: paymentMethod,
                    'balance-cart': '1'
                }
            }
        });
    },

    _openPopup: function() {
        this._paymentModal.setMod('visible', 'yes');
    },

    _closePopup: function() {
        this._sendPostMessage('close');

        this._paymentModal && this._paymentModal.delMod('visible');
    },

    _initSwitchOffLimitClient: function() {
        var clientCreator,
            client;

        if (!this._switchOffDataProvider) {
            clientCreator = u._.get(window, 'dna.utils.getSwitchOffLimitDataProvider');
            client = clientCreator && clientCreator(u.consts('ulogin'));
            this._switchOffDataProvider = client && client.dataProvider;
            this._switchOffMutationExecutor = client && client.mutationExecutor;
        }
    },

    _onSwitchOffLimitDataLoaded: function(response) {
        var firstOption;

        this._switchOffLimitOptions = response.client.autoOverdraftPaymentOptions;

        firstOption = this._getPayersFilteredByPaymentMethod()[0];
        firstOption && this._model.set('payer_id', firstOption.personInfo.id);

        this._updateSwitchOffLimitPayerSelect();
        this._updateSwitchOffLimitSuffix();
    },

    _updateSwitchOffLimitSuffix: function() {
        var params = this.params,
            switchOffLimitCoeff = params.switchOffLimitCoeff,
            payerId = this._model.get('payer_id'),
            apiPaymentMethod = this.modelPaymentMethodsToApiPaymentMethodsDictionary[this._model.get('payment_method')],
            payerData,
            limit;

        if (!this.switch_off_limit) {
            return;
        }

        payerData = this._switchOffLimitOptions && this._switchOffLimitOptions.find(function(payer) {
            return payer.personInfo.id === payerId;
        });

        limit = payerData && payerData.paymentMethods.find(function(method) {
            return method.code === apiPaymentMethod;
        });

        if (!limit || limit.limit === null) {
            limit = params.switchOffUpperLimit;
        } else {
            limit = limit.limit;
        }

        if (limit < params.switchOffLowerLimit) {
            this._hideSwitchOffLimit();
        }

        this._model.set('switch_off_upper_limit', limit);
        this._model.set('switch_off_limit', this._model.get('switch_off_limit'));
        this._model.set('switch_off_limit', this._model.get('switch_off_limit') * switchOffLimitCoeff);
        this.switch_off_limit.val(this._getValueFromModel('switch_off_limit'));

        this._switchOffLimitSuffix = BEM.DOM.replace(this._switchOffLimitSuffix, BEMHTML.apply({
            block: 'b-pay',
            elem: 'switch-off-limit-suffix',
            workCurrency: params.currency,
            upperLimit: limit
        }));
    },

    _updateSwitchOffLimitPayerSelect: function() {
        var mgr = this._subscriptionManager,
            payerId = this._model.get('payer_id'),
            payerItems;

        if (!this._switchOffLimitSelect) {
            return;
        }

        payerItems = this._getPayersFilteredByPaymentMethod().map(function(option) {
            return { text: option.personInfo.name, val: option.personInfo.id };
        });

        if (payerItems.length) {
            this._showSwitchOffLimit();
            if (!u._.includes(payerItems.map(function(item) { return item.val }), payerId)) {
                // если текущего выбранного плательщика нет среди доступных для выбранного способа платежа,
                // выбираем первого из доступных
                payerId = payerItems[0].id;
                this._model.set('payer_id', payerId);
            }

            mgr.un(this._switchOffLimitSelect, 'change', this._onPayerSelect);

            this._switchOffLimitSelect = BEM.DOM.replace(this.elem('switch-off-limit-select'), BEMHTML.apply({
                block: 'b-pay',
                elem: 'switch-off-limit-select',
                value: payerId,
                items: payerItems
            })).bem('select2');

            mgr.on(this._switchOffLimitSelect, 'change', this._onPayerSelect, this);
        } else {
            this._hideSwitchOffLimit();
        }
    },

    _initSwitchOffLimit: function() {
        this._initSwitchOffLimitClient();

        this._switchOffDataProvider && this._switchOffDataProvider.fetchSwitchOffLimitPaymentData(u.consts('ulogin'))
            .then(this._onSwitchOffLimitDataLoaded.bind(this))
            .catch(function(e) {
                var errorMessage = u._.get(e, 'message');

                this._hideSwitchOffLimit();

                BEM.blocks['b-metrika2'].params({
                    params: {
                        payment: {
                            'switch-off-limit-data-error': errorMessage ? JSON.stringify(errorMessage) : '1'
                        }
                    }
                });
            }.bind(this));
    },

    _initFormContent: function() {
        var params = this.params,
            offer = 'none';

        if (params.autopaymentAllowed) {
            if (params.autopaymentMemoryPeriodDays) {
                offer = 'autopayment-save';
            } else {
                offer = params.autopaymentEnabled ?
                    'autopayment' :
                    'autopayment-opt-out';
            }
        } else if (params.switchOffLimitAllowed) {
            offer = 'switch-off-limit';
        }

        if (this._firstRun) {
            BEM.blocks['i-web-api-request'].payment.getBillingData(u.consts('ulogin'))
                .then(function(d) {
                    var data = d || {};

                    this._model.set('canUsePromocodes', !!data.canUsePromocodes);
                    this._model.set('hasSingleLegalPayer', !!data.hasSingleLegalPerson);
                    this.setMod(this.elem('content'), 'single-legal-payer', data.hasSingleLegalPerson ? 'yes' : 'no');

                    this._initCreditCardSelect(data.boundCards);
                    this._updatePromoCodeTextFieldVisibility();

                    this.delMod(this.elem('content'), 'loading');
                    this._initDefaultPaymentMethod();
                }.bind(this))
                .catch(function() {
                    BEM.blocks['b-confirm'].alert(iget2('b-pay', 'unexpected-error', 'Что-то пошло не так, попробуйте еще раз позже'));
                });

            this.params.switchOffLimitAllowed && this._initSwitchOffLimit();
        }

        this._firstRun = false;

        BEM.blocks['b-metrika2'].params({
            params: {
                payment: {
                    offer: offer
                }
            }
        });
    },

    _onBeforeModalOpen: function() {
        this._initFormContent();

        this._page.setMod('no-scroll', 'yes');
    },

    _onAfterModalClose: function() {
        this._page.delMod('no-scroll');

        BEM.blocks['b-metrika2'].params({
            params: {
                payment: {
                    'modal-closed': '1'
                }
            }
        });
    },

    _updatePromoCodeTextFieldVisibility: function() {
        if (!this._model.get('canUsePromocodes')) {
            return;
        }

        var isSingleLegalPayer = this._model.get('hasSingleLegalPayer'),
            paymentMethod = this._model.get('payment_method'),
            visible = false,
            promoVisible = false;

        switch (true) {
            case paymentMethod === 'card':
            case paymentMethod === 'card-legal' && isSingleLegalPayer:
                visible = true;
                break;
            case paymentMethod === 'card-legal' && !isSingleLegalPayer:
            case paymentMethod === 'wire':
            case paymentMethod === 'overdraft':
            case paymentMethod === 'promocode':
            case paymentMethod === 'other':
                promoVisible = true;
                break;
        }

        this.toggleMod(this.elem('promocode-row'), 'hidden', '', 'yes', visible);
        this.toggleMod(this.elem('promocode-promo-row'), 'hidden', '', 'yes', promoVisible);
    },

    _initDefaultPaymentMethod: function() {
        var payerType = window.localStorage.getItem('clientWalletPayment.payerType') || 'phys',
            paymentMethod = window.localStorage.getItem('payment_method') || 'card';

        this._payerTypeSelect && this._payerTypeSelect.setVal(payerType);
        this._updatePaymentMethods(payerType);
        if (paymentMethod/* && this.paymentMethodToPayerTypeDict[paymentMethod] === payerType*/) {
            this._paymentMethodSelect && this._paymentMethodSelect.setVal(paymentMethod);
            this._changeSubmit(paymentMethod);
        }

        this._changeOfferState(paymentMethod);
        this.updateDisabled(paymentMethod);
    },

    _changeOfferState: function(paymentMethod) {
        var isSingleLegalPayer = this._model.get('hasSingleLegalPayer');

        switch (true) {
            case paymentMethod === 'card':
            case paymentMethod === 'card-legal' && isSingleLegalPayer:
                this._showOffer();
                break;
            default:
                this._hideOffer();
        }
    },

    _onPayerTypeSelectChange: function(e, data) {
        var payerType = data.currVal;

        window.localStorage.setItem('clientWalletPayment.payerType', payerType);
        this._model.set('payer_type', payerType);
        this._updatePaymentMethods(payerType);
    },

    _updatePaymentMethods: function(payerType) {
        var paymentMethodItems = [],
            mgr = this._subscriptionManager;
            // defaultPaymentMethod;

        paymentMethodItems = [
            { val: 'card', text: iget2('b-pay', 'bank-card-phys', 'Банковская карта для физических лиц') },
            { val: 'card-legal', text: iget2('b-pay', 'bank-card-legal', 'Банковская карта для юридических лиц') },
            { val: 'wire', text: iget2('b-pay', 'payment-method-wire', 'Банковский перевод') },
            this.params.needOverdraftPaymentMethod && { val: 'overdraft', text: iget2('b-pay', 'payment-method-overdraft', 'Счёт с отложенной оплатой') },
            !this.params.hidePayWithCash && { val: 'cash', text: iget2('b-pay', 'payment-method-cash', 'Оплата наличными') },
            { val: 'other', text: iget2('b-pay', 'payment-method-other', 'Другие способы') }
        ];

        /*if (payerType === 'phys') {
            paymentMethodItems = [
                { val: 'card', text: iget2('b-pay', 'bank-card', 'Банковская карта') },
                { val: 'cash', text: iget2('b-pay', 'payment-method-cash', 'Оплата наличными') },
                { val: 'other', text: iget2('b-pay', 'payment-method-other', 'Другие способы') }
            ];
            defaultPaymentMethod = 'card';
        } else if (payerType === 'legal') {
            paymentMethodItems = [
                { val: 'card-legal', text: iget2('b-pay', 'bank-card', 'Банковская карта') },
                { val: 'wire', text: iget2('b-pay', 'payment-method-wire', 'Банковский перевод') },
                this.params.needOverdraftPaymentMethod && { val: 'overdraft', text: iget2('b-pay', 'payment-method-overdraft', 'Счёт с отложенной оплатой') },
            ];
            defaultPaymentMethod = 'card-legal';
        }*/

        mgr.un(this._paymentMethodSelect, 'change', this._onPaymentMethodSelect);
        this._paymentMethodSelect = BEM.DOM.replace(this.elem('payment-method-select'), BEMHTML.apply({
            block: 'select2',
            mix: [
                { block: 'b-pay', elem: 'payment-method-select' }
            ],
            mods: {
                size: 'n',
                theme: 'normal',
                text: 'vary',
                width: 'max',
                type: 'radio'
            },
            val: '',
            items: paymentMethodItems
        })).bem('select2');
        mgr.on(this._paymentMethodSelect, 'change', this._onPaymentMethodSelect, this);

        // this._paymentMethodSelect.setVal(defaultPaymentMethod);
    },

    _onPaymentMethodSelect: function(e, data) {
        this._handlePaymentMethodChange(data.currVal);
    },

    _handlePaymentMethodChange: function(paymentMethod) {
        window.localStorage.setItem('payment_method', paymentMethod);
        this._model.set('payment_method', paymentMethod);
        this.setMod(this.elem('content'), 'payment-method', paymentMethod);
        this.delMod(this.elem('content'), 'errors');
        this._updatePromoCodeTextFieldVisibility()
        this._changeSubmit(paymentMethod);
        BEM.DOM.update(this.elem('payment-term'), BEMHTML.apply(u['b-pay']._getPaymentTermMessage(paymentMethod)));
    },

    _changeSubmit: function(paymentMethod) {
        var isSingleLegalPayer = this._model.get('hasSingleLegalPayer');

        this._changeOfferState(paymentMethod);
        this.updateDisabled(paymentMethod);

        switch (true) {
            case paymentMethod === 'card':
            case paymentMethod === 'card-legal' && isSingleLegalPayer:
                this._submit.setText(iget2('b-pay', 'forward-to-payment', 'Перейти к оплате'));
                this._submit.setMod('theme', 'action');
                this._updateSwitchOffLimitPayerSelect();
                this._updateSwitchOffLimitSuffix();
                break;

            case paymentMethod === 'card-legal' && !isSingleLegalPayer:
            case paymentMethod === 'wire':
                this._submit.setText(iget2('b-pay', 'submit-vypisat-schyot-or-param-submit', 'Выписать счёт'));
                this._submit.setMod('theme', 'action');
                this._updateSwitchOffLimitPayerSelect();
                this._updateSwitchOffLimitSuffix();
                break;
            case paymentMethod === 'overdraft':
            case paymentMethod === 'promocode':
                this._submit.setText(iget2('b-pay', 'submit-vypisat-schyot-or-param-submit', 'Выписать счёт'));
                this._submit.setMod('theme', 'action');
                this._hideSwitchOffLimit();
                break;

            case paymentMethod === 'other':
                this._submit.setText(iget2('b-pay', 'submit-vypisat-schyot-or-param-submit', 'Выписать счёт'));
                this._submit.setMod('theme', 'action');
                break;

            case paymentMethod === 'cash':
                this._submit.setText(iget2('b-pay', 'generate-payment-code', 'Сформировать код платежа'));
                this._submit.setMod('theme', 'action');
                break;
        }
    },

    _hideOffer: function() {
        this._commonOffer && this.setMod(this._commonOffer, 'visible', 'no');
    },

    _showOffer: function() {
        this._commonOffer && this.setMod(this._commonOffer, 'visible', 'yes');
    },

    _onCreditCardSelect: function(e, data) {
        this._model.set('credit_card_id', data.currVal);
    },

    _onPayerSelect: function(e, data) {
        this._model.set('payer_id', data.currVal);
    },

    _onEnableAutopayment: function(e, data) {
        var cookieName = 'autopay_mem_val',
            expires = this.params.autopaymentMemoryPeriodDays;

        this._model.set('autopayment_enabled', data.checked);
        this.delMod(this.elem('content'), 'errors');

        if (expires && !data.checked) {
            $.cookie(cookieName, 0, { expires: expires, path: '/' });
        } else {
            $.cookie(cookieName, null, { path: '/' });
        }

        this.toggleMod(this._autopaymentInputs, 'hidden', '', 'yes', data.checked);
        this.toggleMod(this._autopaymentHint, 'hidden', '', 'yes', data.checked);
        this.toggleMod(this._autopaymentOfferCheckbox, 'hidden', '', 'yes', data.checked);

        BEM.blocks['b-metrika2'].params({
            params: {
                payment: {
                    'autopayment-enabled': data.checked ? '1' : '0'
                }
            }
        });
    },

    _onEnableSwitchOffLimit: function(e, data) {
        this._model.set('switch_off_limit_enabled', data.checked);
        this.delMod(this.elem('content'), 'errors');

        this.toggleMod(this._switchOffLimitInputCell, 'hidden', '', 'yes', data.checked);
        this.toggleMod(this._switchOffLimitPayersRow, 'hidden', '', 'yes', data.checked);
        this.toggleMod(this._switchOffLimitOfferCheckbox, 'hidden', '', 'yes', data.checked);

        BEM.blocks['b-metrika2'].params({
            params: {
                payment: {
                    'switch-off-limit-enabled': data.checked ? '1' : '0'
                }
            }
        });
    },

    _hideSwitchOffLimit: function() {
        this.setMod(this._switchOffLimit, 'hidden', 'yes');
    },

    _showSwitchOffLimit: function() {
        this.delMod(this._switchOffLimit, 'hidden');
    },

    _setSubmitButtonProgress: function(isInProgress) {
        if (isInProgress) {
            this._submit.setMod('progress', 'yes');
        } else {
            this._submit.delMod('progress');
        }
    },

    _tryToSubmitSwitchOffLimit: function() {
        var switchOffLimitEnabled = this._model.get('switch_off_limit_enabled') &&
                this.getMod(this._switchOffLimit, 'hidden') !== 'yes',
            paymentMethod = this._model.get('payment_method'),
            payerId = this._model.get('payer_id'),
            limit = this._model.get('switch_off_limit'),
            apiPaymentMethod = this.modelPaymentMethodsToApiPaymentMethodsDictionary[paymentMethod];

        if (!switchOffLimitEnabled || !this._switchOffMutationExecutor) {
            return Promise.resolve();
        }

        return this._switchOffMutationExecutor.setAutoOverdraftLimit(
            apiPaymentMethod,
            payerId,
            limit
        ).then(function() {
            this._hideSwitchOffLimit();
            this.trigger('switch-off-limit-changed', { sum: +this._model.get('switch_off_limit') });
        }.bind(this)).catch(function(e) {
            var errorMessage = u._.get(e, 'message');

            this._hideSwitchOffLimit();

            BEM.blocks['b-metrika2'].params({
                params: {
                    payment: {
                        'switch-off-limit-turn-on-error': errorMessage ? JSON.stringify(errorMessage) : '1'
                    }
                }
            });
        }.bind(this));
    },

    _onAutoPaymentSumsChange: function() {
        var params = this.params,
            sum = this._model.get('autopayment_sum'),
            remainingSum = this._model.get('remaining_sum'),
            workCurrency = params.currency,
            nds = params.nds || 0

        this._autopaymentHint = BEM.DOM.replace(this._autopaymentHint, BEMHTML.apply({
            block: 'b-pay',
            elem: 'autopayment-hint',
            sum: sum,
            remainingSum: remainingSum,
            workCurrency: workCurrency,
            nds: nds
        }));
    },

    _getPayersFilteredByPaymentMethod: function(paymentMethod) {
        paymentMethod = paymentMethod || this._model.get('payment_method');

        return (this._switchOffLimitOptions || []).filter(function(option) {
            return u._.contains(
                option.paymentMethods.map(function(method) {
                    return method.code;
                }),
                this.modelPaymentMethodsToApiPaymentMethodsDictionary[paymentMethod]
            );
        }.bind(this));
    },

    _initClipboard: function() {
        this.clipboard = new Clipboard('.b-pay__copy-payment-code-button', {
            text: function() {
                return this._paymentCode[0].innerText;
            }.bind(this)
        }).on('success', this._showCopiedMessage.bind(this));
    },

    _getTipman: function() {
        return this._tipman || (this._tipman = BEM.create('tipman', {
            tipMods: { size: 's', theme: 'normal', autoclosable: 'no' },
            tipJs: { to: ['top'] }
        }));
    },

    _showCopiedMessage: function(e) {
        e.clearSelection(); // чтобы в FF не скролилось

        clearTimeout(this._copiedTimeout);

        this._getTipman().show({
            owner: this._copyPaymentCodeButton,
            content: iget2('b-pay', 'copied-text', 'Скопировано')
        });

        this._copiedTimeout = setTimeout(function() {
            this._getTipman().hide();
        }.bind(this), 1000);
    },

    _initCreditCardSelect: function(clientCards) {
        var cards = clientCards || [],
            select = this._cardSelectCell && cards.length && BEM.DOM.append(
                this._cardSelectCell,
                BEMHTML.apply({
                    block: 'b-pay-select-credit-card',
                    mix: [
                        { block: 'b-pay', elem: 'credit-card-select' }
                    ],
                    cards: cards,
                    size: 'n'
                })
            ).bem('b-pay-select-credit-card');

        select && this._subscriptionManager.on(select, 'change', this._onCreditCardSelect, this);

        this._model.set('credit_card_id', u._.get(cards, '0.card_id'));
    }
});
