block('b-pay')(

    elem('form')(
        tag()('form'),

        attrs()(function() {
            return {
                target: '_parent'
            };
        })
    ),

    elem('popup-header').tag()('h2'),

    elem('form-body').content()(function() {
        var ctx = this.ctx,
            formattedSum = u.numberFormatter.format(ctx.offerSumToPay, {
                precision: 2
            });

        return [
            ctx.showRecommendations && {
                elem: 'payment-recommendation',
                preselectRecommendation: ctx.preselectRecommendation,
                workCurrency: ctx.workCurrency,
                withNds: ctx.withNds,
                clientNds: ctx.clientNds,
            },
            ctx.withNds ? {
                elem: 'pay-with-nds',
                formattedSum: formattedSum,
                workCurrency: ctx.workCurrency,
                clientNds: ctx.clientNds,
                paymentMethod: ctx.paymentMethod,
                needOverdraftPaymentMethod: ctx.needOverdraftPaymentMethod,
                promocode: ctx.promocode
            } : {
                elem: 'pay',
                formattedSum: formattedSum,
                wallet: ctx.wallet,
                workCurrency: ctx.workCurrency,
                clientNds: ctx.clientNds,
                pseudo_currency: ctx.pseudo_currency,
                boundCards: ctx.boundCards,
                paymentMethod: ctx.paymentMethod,
                needOverdraftPaymentMethod: ctx.needOverdraftPaymentMethod,
                promocode: ctx.promocode
            }
        ];
    }),

    elem('payment-recommendation').content()(function() {
        var ctx = this.ctx,
            currency = ctx.workCurrency,
            nds = ctx.clientNds,
            withNds = ctx.withNds,
            preselectRecommendation = ctx.preselectRecommendation;

        function getRecommendationItem(type, selected, text) {
            return {
                elem: 'recommendation-item',
                elemMods: {
                    selected: selected ? 'yes' : '',
                    type: type
                },
                nds: withNds && nds,
                currency: currency,
                text: text
            };
        }

        return [
            {
                elem: 'recommendation-sum-header',
                content: iget2('b-pay', 'recommended-sums', 'Рекомендованные суммы')
            },
            {
                elem: 'recommendation-items-wrapper',
                content: [
                    getRecommendationItem('min', false, iget2('b-pay', 'recommended-sum-min', 'Стартуйте с небольшим бюджетом')),
                    getRecommendationItem('mid', preselectRecommendation, iget2('b-pay', 'recommended-sum-mid', 'Можно закупать больший объём трафика')),
                    getRecommendationItem('max', false, iget2('b-pay', 'recommended-sum-max', 'Рекомендуемый бюджет рекламной кампании для достаточного охвата аудитории'))
                ]
            }];
    }),

    elem('recommendation-sum-header').tag()('h3'),

    elem('recommendation-item').content()(function() {
        var ctx = this.ctx,
            type = ctx.elemMods.type,
            nds = ctx.nds,
            text = ctx.text,
            currency = ctx.currency,
            res = [{
                tag: 'span',
                elem: 'recommendation-sum',
                content: u['b-pay']._getFormattedRecommendationSum(type, currency)
            }];

        if (+nds) {
            res.push({
                tag: 'span',
                elem: 'recommendation-sum-with-nds',
                content: iget2('b-pay', 'recommended-sum-with-nds', '{sum} с НДС', {
                    sum: u['b-pay']._getFormattedRecommendationSum(type, currency, nds)
                })
            });
        }

        return res.concat([
            {
                tag: 'p',
                elem: 'recommendation-item-text',
                content: text
            }, {
                elem: 'recommendation-item-icon'
            }
        ]);
    }),

    elem('substantial-payment-tooltip').content()(function() {
        var ctx = this.ctx,
            currency = ctx.currency,
            sum = ctx.sum;

        return [
            {
                content: iget2('b-pay', 'tooltip-msg', 'При внесении суммы более {sum} вы можете пополнить счёт', {
                    sum: u.currencies.formatSum(currency, sum, { precision: 0 })
                }),
            },
            {
                content: [
                    {
                        elem: 'substantial-payment-tooltip-item',
                        content: iget2('b-pay', 'tooltip-msg-item1', 'наличными в банке')
                    },
                    {
                        elem: 'substantial-payment-tooltip-item',
                        content: iget2('b-pay', 'tooltip-msg-item2', 'через систему PayPal (только для физ. лиц)')
                    },
                    {
                        elem: 'substantial-payment-tooltip-item',
                        content: iget2('b-pay', 'tooltip-msg-item3', 'Яндекс.Деньгами, способ доступен только для идентифицированных пользователей')
                    }
                ]
            }
        ]
    }),

    elem('pay').content()(function() {
        var ctx = this.ctx,
            formattedSum = ctx.formattedSum,
            workCurrency = ctx.workCurrency,
            wallet = ctx.wallet,
            pseudo_currency = ctx.pseudo_currency,
            cards = ctx.boundCards,
            paymentMethod = ctx.paymentMethod,
            needOverdraftPaymentMethod = ctx.needOverdraftPaymentMethod,
            promocode = ctx.promocode;

        return {
            elem: 'table',
            content: [
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'cell',
                            elemMods: {
                                number: 1
                            },
                            content: wallet ? iget2('b-pay', 'oplatit', 'Оплатить') : iget2('b-pay', 'popolnit-kampaniyu-na', 'Пополнить кампанию на')
                        },
                        {
                            elem: 'cell',
                            elemMods: {
                                number: 2
                            },
                            content: [
                                {
                                    elem: 'toggle-input',
                                    mix: [
                                        {
                                            block: 'b-pay',
                                            elem: 'sum'
                                        }
                                    ],
                                    mode: 'input',
                                    value: formattedSum
                                },
                                u.currencies.get(workCurrency).currency_sign
                            ]
                        }
                    ]
                },
                pseudo_currency ?
                    {
                        elem: 'row',
                        mix: [{
                            block: 'b-pay',
                            elem: 'note'
                        }],
                        content: {
                            elem: 'cell',
                            attrs: {
                                colspan: 3
                            },
                            content: iget2('b-pay', 'primechanie-1-u-e', 'Примечание: 1 у.е. = {foo} {bar}', {
                                foo: pseudo_currency.rate,
                                bar: pseudo_currency.name
                            })
                        }
                    } :
                    '',
                pseudo_currency ?
                    {
                        elem: 'row',
                        mix: [{
                            block: 'b-pay',
                            elem: 'row-total'
                        }],
                        content: [
                            {
                                elem: 'cell',
                                elemMods: {
                                    number: 1
                                },
                                content: iget2('b-pay', 'summa-platezha', 'Сумма платежа')
                            },
                            {
                                elem: 'cell',
                                elemMods: {
                                    number: 2
                                },
                                content: {
                                    elem: 'toggle-input',
                                    mix: [
                                        {
                                            block: 'b-pay',
                                            elem: 'sum-money-local'
                                        }
                                    ],
                                    mode: 'link',
                                    value: formattedSum
                                }
                            },
                            {
                                elem: 'cell',
                                elemMods: {
                                    number: 3
                                },
                                content: pseudo_currency.name
                            }
                        ]
                    } :
                    '',

                (workCurrency === 'BYN') && {
                    elem: 'row',
                    content: {
                        elem: 'cell',
                        elemMods: { wordwrap: 'yes' },
                        attrs: {
                            colspan: 3
                        },
                        content: iget2('b-pay', 'nds-20-rb', 'Для клиентов, которые работают с ООО «Яндекс Реклама», к счёту будет прибавлен НДС 20%')
                    }
                },

                (workCurrency === 'KZT') && {
                    elem: 'row',
                    content: {
                        elem: 'cell',
                        elemMods: { wordwrap: 'yes' },
                        attrs: {
                            colspan: 3
                        },
                        content: iget2('b-pay', 'nds-12-kz', 'Для клиентов, которые работают с ТОО «Яндекс.Казахстан», к счёту будет прибавлен НДС 12%')
                    }
                },
                { elem: 'apply-promocode', promocode: promocode },
                {
                    elem: 'payment-method',
                    cards: cards,
                    paymentMethod: paymentMethod,
                    needOverdraftPaymentMethod: needOverdraftPaymentMethod
                }
            ]
        };
    }),

    elem('pay-with-nds').content()(function() {
        var ctx = this.ctx,
            formattedSum = ctx.formattedSum,
            workCurrency = ctx.workCurrency,
            clientNds = ctx.clientNds,
            paymentMethod = ctx.paymentMethod,
            needOverdraftPaymentMethod = ctx.needOverdraftPaymentMethod,
            promocode = ctx.promocode;

        return {
            elem: 'table',
            content: [
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'cell',
                            mix: [
                                { block: 'b-pay', elem: 'top-up-sum' }
                            ],
                            elemMods: {
                                number: 1
                            },
                            content: [
                                iget2('b-pay', 'popolnit-obshchiy-schyot-na', 'Сумма пополнения'),
                                {
                                    block: 'b-pay',
                                    elem: 'min-payment-sum',
                                    content: iget2('b-pay', 'min-payment-sum', 'не менее {sum} {currency}', {
                                        sum: u.numberFormatter.format(u.currencies.get(workCurrency)['MIN_PAY'], { precision: 2 }),
                                        currency: u.currencies.get(workCurrency).currency_sign
                                    })
                                }
                            ]
                        },
                        {
                            elem: 'cell',
                            mix: [
                                { block: 'b-pay', elem: 'top-up-sum-cell' }
                            ],
                            elemMods: {
                                number: 2
                            },
                            content: [
                                {
                                    elem: 'toggle-input',
                                    mix: [
                                        {
                                            block: 'b-pay',
                                            elem: 'sum-without-nds'
                                        }
                                    ],
                                    mode: 'input',
                                    value: formattedSum
                                },
                                u.currencies.get(workCurrency).currency_sign,
                                {
                                    block: 'b-pay',
                                    elem: 'sum-cell-suffix',
                                    content: [
                                        ', ',
                                        iget2('b-pay', 'will-be-deposited', 'будет зачислено на счёт')
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    elem: 'nds-fields',
                    formattedSum: formattedSum,
                    workCurrency: workCurrency,
                    clientNds: clientNds
                },
                { elem: 'apply-promocode', promocode: promocode },
                {
                    elem: 'payment-method',
                    paymentMethod: paymentMethod,
                    needOverdraftPaymentMethod: needOverdraftPaymentMethod
                }
            ]
        };
    }),

    elem('apply-promocode').replace()(function() {
        return {
            elem: 'row',
            mix: [
                { block: 'b-pay', elem: 'promocode-row', elemMods: { hidden: 'yes' } }
            ],
            content: [
                {
                    elem: 'cell',
                    mix: [
                        { block: 'b-pay', elem: 'apply-promocode' }
                    ],
                    elemMods: {
                        number: 1
                    },
                    content: [
                        iget2('b-pay', 'apply-promocode', 'Промокод')
                    ]
                },
                {
                    elem: 'cell',
                    mix: [
                        { block: 'b-pay', elem: 'apply-promocode-cell' }
                    ],
                    elemMods: {
                        number: 2
                    },
                    content: [
                        {
                            block: 'input',
                            mods: {
                                size: 's',
                                autocomplete: 'off'
                            },
                            mix: [{
                                block: 'b-pay',
                                elem: 'promo-code'
                            }],
                            content: { elem: 'control' }
                        }
                    ]
                }
            ]
        };
    }),

    elem('nds-fields').replace()(function() {
        var ctx = this.ctx,
            formattedSum = ctx.formattedSum,
            workCurrency = ctx.workCurrency,
            nds = ctx.clientNds,
            warnSum = u['b-pay']._getRecommendationSum('warn', workCurrency),
            currencySign = u.currencies.get(workCurrency).currency_sign;

        return [
            {
                elem: 'row',
                mix: [
                    { elem: 'nds-row' }
                ],
                content: [
                    {
                        elem: 'cell',
                        elemMods: {
                            number: 1
                        },
                        content: iget2('b-pay', 'nds', 'НДС, {tax}%', {
                            tax: +nds.toString()
                        })
                    },
                    {
                        elem: 'cell',
                        elemMods: {
                            number: 2
                        },
                        content: [
                            {
                                block: 'b-pay',
                                elem: 'nds'
                            },
                            currencySign
                        ]
                    }
                ]
            },
            {
                elem: 'row',
                elemMods: this.elemMods,
                mix: [{
                    block: 'b-pay',
                    elem: 'tooltip-container'
                }],
                content: [
                    {
                        elem: 'cell',
                        elemMods: {
                            number: 1
                        },
                        content: iget2('b-pay', 'summa-platezha', 'Сумма платежа')
                    },
                    {
                        elem: 'cell',
                        elemMods: {
                            number: 2
                        },
                        mix: [
                            { block: 'b-pay', elem: 'total-sum' }
                        ],
                        content: [
                            {
                                elem: 'toggle-input',
                                mix: [
                                    {
                                        block: 'b-pay',
                                        elem: 'sum-with-nds'
                                    },
                                    warnSum && {
                                        block: 'b-feature-marker',
                                        js: {
                                            featureId: 'substantial-payment-tooltip',
                                            dynamic: true,
                                            direction: 'bottom-right',
                                            secondaryOffset: -33,
                                            text: {
                                                block: 'b-pay',
                                                elem: 'substantial-payment-tooltip',
                                                currency: workCurrency,
                                                sum: warnSum
                                            },
                                        }
                                    }
                                ],
                                mode: 'link',
                                value: formattedSum
                            },
                            currencySign,
                            {
                                block: 'b-pay',
                                elem: 'sum-cell-suffix',
                                content: [
                                    ', ',
                                    iget2('b-pay', 'including-vat', 'включая НДС {tax}% –{sum}{currency}', {
                                        tax: +nds.toString(),
                                        sum: {
                                            block: 'b-pay',
                                            elem: 'nds'
                                        },
                                        currency: currencySign
                                    })
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
    }),

    elem('toggle-input')(
        def()(function() {
            return applyNext({
                size: 's'
            });
        }),

        replace()(function() {
            var ctx = this.ctx;

            return {
                block: 'b-toggle-input',
                mods: {
                    mode: ctx.mode
                },
                mix: [].concat(
                    {
                        block: 'b-pay',
                        elem: 'toggle-input'
                    },
                    ctx.mix
                ),
                size: this.size,
                value: ctx.value
            };
        })
    ),

    elem('table').wrap()(function() {
        return {
            block: 'b-layout-table',
            mix: [{
                block: 'b-pay',
                elem: 'table',
                elemMods: this.ctx.elemMods
            }].concat(this.ctx.mix || []),
            content: applyCtx(this.ctx.content)
        };
    }),

    elem('row').wrap()(function() {
        return {
            block: 'b-layout-table',
            elem: 'row',
            mix: [{
                block: 'b-pay',
                elem: 'row',
                elemMods: this.ctx.elemMods
            }].concat(this.ctx.mix || []),
            content: applyCtx(this.ctx.content)
        };
    }),

    elem('cell').wrap()(function() {
        return {
            block: 'b-layout-table',
            elem: 'cell',
            attrs: this.ctx.attrs,
            mix: [{
                block: 'b-pay',
                elem: 'cell',
                elemMods: this.ctx.elemMods
            }].concat(this.ctx.mix || []),
            content: applyCtx(this.ctx.content)
        };
    }),

    elem('offer-checkbox').content()(function() {
        return {
            block: 'checkbox',
            mods: {
                theme: 'normal',
                size: this.ctx.newPaymentWorkflowEnabled ? 'm' : 's'
            },
            text: {
                content: iget2('b-pay', 'agree-to-offer', 'Я ознакомился и согласен с{offerLink} на оказание услуг «Яндекс.Директ»', {
                    offerLink: {
                        block: 'b-help-link',
                        mods: {
                            decoration: 'no'
                        },
                        url: u.getLegalHelpUrl('/oferta_direct/index.xml'),
                        text: iget2('b-pay', 'offer', 'Офертой')
                    }
                })
            }
        }
    })
);
