/**
 *
 * @param { nds, currentCurrency, } ctx.client
 * @param ctx.clientNds
 *
 * @namespace b-pay
 */
block('b-pay')(

    def()(function() {
        var data = this.data,
            userOptions = data.USER_OPTIONS || {},
            ctx = this.ctx,
            currency = data.work_currency,
            isOfferAccepted = ctx.isOfferAccepted,
            newPaymentWorkflow = data.new_payment_workflow_enabled,
            recommendationMid = u['b-pay']._getRecommendationSum('mid', currency),
            recommendationMax = u['b-pay']._getRecommendationSum('max', currency),
            recommendationMin = u['b-pay']._getRecommendationSum('min', currency),
            customMinPay = this.data.customMinPay,
            queryParams = u.getUrlParams(),
            offerSumToPayFromQueryParams = queryParams['payment-sum'],
            offerSumToPay = ctx.offerSumToPay || recommendationMin,
            clientNds = +ctx.clientNDS,
            withNds = clientNds && !u._.contains(['YND_FIXED', 'BYN', 'KZT'], currency),
            showRecommendations = !ctx.offerSumToPay || (recommendationMax && ctx.offerSumToPay <= recommendationMax);

        if (newPaymentWorkflow) {
            if (ctx.paymentSumFromGetParam !== undefined || userOptions.payment_sum !== undefined) {
                showRecommendations = false;
            }

            if (ctx.paymentSumFromGetParam || userOptions.payment_sum) {
                offerSumToPay = +ctx.paymentSumFromGetParam || +userOptions.payment_sum;
            }
        }

        if (data.payment_sum_offer) {
            offerSumToPay = data.payment_sum_offer;
        }

        if (offerSumToPayFromQueryParams !== undefined) {
            var offerSumToPayFromQueryParamsFormatted = +offerSumToPayFromQueryParams;
            offerSumToPay = offerSumToPayFromQueryParamsFormatted > customMinPay ? offerSumToPayFromQueryParamsFormatted : customMinPay;
        }

        return applyNext({
            'mods.touch': ctx.isTouch,
            'mods.new-payment-workflow': newPaymentWorkflow ? 'yes' : 'no',
            workCurrency: currency,
            clientNds: clientNds,
            withNds: withNds,
            offerSumToPay: offerSumToPay,
            showRecommendations: showRecommendations,
            'ctx.preselectRecommendation': offerSumToPay === recommendationMid,
            newPaymentWorkflow: newPaymentWorkflow,
            wallet: ctx.wallet,
            isIframeContent: ctx.isIframeContent,
            isOfferAccepted: isOfferAccepted,
            isModerationsOfferFeatureEnabled: u.consts('isModerationsOfferFeatureEnabled'),
            hidePayWithCash: u.consts('hidePayWithCash'),
            newCashPaymentEnabled: u.consts('newCashPaymentEnabled')
        });
    }),

    addJs()(function() {
        var currency = this.workCurrency;

        return {
            customMinPay: this.data.customMinPay,
            isInline: this.ctx.mods.inline === 'yes',
            currency: currency,
            withNds: this.withNds,
            nds: this.clientNds,
            rate: currency == 'YND_FIXED' ? this.data.pseudo_currency.rate : 1,
            defaultSum: this.offerSumToPay,
            dailySum: u.currencies.getConst(currency, 'MIN_DAY_BUDGET'),
            isIframeContent: this.isIframeContent,
            needOpenPopup: this.data.FORM.showpopup === '1',
            toPay: this.data.FORM.topay,
            promocode: this.data.FORM.promocode,
            isOfferAccepted: this.ctx.isOfferAccepted,
            isModerationsOfferFeatureEnabled: u.consts('isModerationsOfferFeatureEnabled'),
            newCashPaymentEnabled: this.newCashPaymentEnabled,
            cid: this.ctx.cid
        };
    }),

    elem('form-buttons')(

        content()(function() {
            var data = this.data,
                statusPostModerate = data.statusPostModerate,
                // доступна ли мгновенная модерация
                instantModerationAllowed = !(data.statusModerate == 'Yes' && /^(New|Yes)$/.test(statusPostModerate)) &&
                data.yandex_domain == 'yandex.ru',
                // флаг мгновенной модерации
                instantModeration = false,
                // по умолчанию показывается только кнопка "Выписать счет"
                onlyBillOrder = true,
                fixedOrRubCurrency = /^(YND_FIXED|RUB)$/.test(this.workCurrency),
                countryId,
                loginRights,
                hidePayWithCash = this.hidePayWithCash,
                newCashPaymentEnabled = this.newCashPaymentEnabled,
                ctx = this.ctx,
                submit;

            if (instantModerationAllowed) {
                loginRights = data.login_rights;

                instantModeration = loginRights.role == 'client' && !loginRights.client_have_agency &&
                    statusPostModerate == 'Accepted' ||
                        hasLoginRights('super_control', 'manager_control', 'support_control') &&
                            !data.AgencyUID && fixedOrRubCurrency;
            }

            // если мгновенная модерация применима, то проверяем показывать ли
            // только кнопку "Выписать счет" или дать выбрать оплату наличными
            if (instantModeration) {
                countryId = +data.country_region_id;

                onlyBillOrder = !fixedOrRubCurrency || !!countryId && countryId !== 225;
            }

            submit = [
                {
                    block: 'button',
                    mix: [{
                        block: 'b-pay',
                        elem: 'submit'
                    }],
                    mods: {
                        disabled: 'yes',
                        theme: 'action'
                    },
                    type: 'submit',
                    content: iget2('b-pay', 'submit-vypisat-schyot-or-param-submit', 'Выписать счёт')
                },
                {
                    block: 'button2',
                    theme: 'action',
                    mix: [{
                        block: 'b-pay',
                        elem: 'balance-cart-button'
                    }],
                    mods: {
                        size: 's',
                        disabled: 'yes',
                        theme: 'action'
                    },
                    text: iget2('b-pay', 'add-to-cart', 'Добавить в корзину')
                }
            ];

            if (hidePayWithCash) {
                return submit;
            }

            return iget2('b-pay', 'submit-vypisat-schyot-or', '{submit} {or} {cash}', {
                submit: submit,

                or: function(text) {
                    if (onlyBillOrder) return ' ';

                    return text;
                }(iget2('b-pay', 'submit-vypisat-schyot-or-param-or', 'или')),

                cash: function(text) {
                    if (onlyBillOrder) return ' ';

                    return {
                        block: 'link',
                        url: newCashPaymentEnabled ? undefined : u.getUrl('directPaymentInstructions', {
                            cid: ctx.cid,
                            ulogin: u.escapeHTML(ctx.userLogin)
                        }),
                        mix: [
                            {
                                block: 'b-pay',
                                elem: 'cash-pay-link'
                            }
                        ],
                        content: text
                    };
                }(iget2('b-pay', 'submit-vypisat-schyot-or-param-cash', 'оплатить кампанию наличными')),

                context: 'submit - Выписать счёт; or - или; cash - оплатить кампанию наличными'
            });
        }),

        match(function() {
            return this.wallet;
        }).content()(function() {
            var data = this.data,
                wallet = this.wallet,
                clientCountryId = +this.data.client_country || +this.data.country_region_id,
                hidePayWithCash = this.hidePayWithCash,
                newCashPaymentEnabled = this.newCashPaymentEnabled;

            return [
                {
                    block: 'button',
                    mix: [{
                        block: 'b-pay',
                        elem: 'submit'
                    }],
                    mods: {
                        disabled: 'yes',
                        theme: 'action'
                    },
                    content: iget2('b-pay', 'vypisat-schyot', 'Выписать счёт')
                },
                {
                    block: 'button2',
                    theme: 'action',
                    mix: [{
                        block: 'b-pay',
                        elem: 'balance-cart-button'
                    }],
                    mods: {
                        size: 's',
                        disabled: 'yes',
                        theme: 'action'
                    },
                    text: iget2('b-pay', 'add-to-cart', 'Добавить в корзину')
                },
                !hidePayWithCash &&
                /^(YND_FIXED|RUB)$/.test(this.workCurrency) &&
                    data.pay_method != 'with_block' &&
                        !wallet.agencyID && wallet.money_type == 'real' &&
                (!clientCountryId || clientCountryId == 225) ?
                    {
                        block: 'link',
                        url: newCashPaymentEnabled ? undefined : u.getUrl('directPaymentInstructions', {
                            cid: this.ctx.cid,
                            ulogin: u.escapeHTML(this.ctx.userLogin)
                        }),
                        content: iget2('b-pay', 'oplata-nalichnymi', 'Оплата наличными'),
                        mix: [
                            {
                                block: 'b-pay',
                                elem: 'link'
                            },
                            {
                                block: 'b-pay',
                                elem: 'cash-pay-link'
                            }
                        ],
                        target: '_blank'
                    } :
                    {}
            ];
        }),

        match(function() {
            return this.newPaymentWorkflow;
        }).content()(function() {
            var isFromWidget = this.data.FORM.isFromWidget === '1';

            return [
                {
                    block: 'button2',
                    mix: [{
                        block: 'b-pay',
                        elem: 'submit'
                    }],
                    mods: {
                        size: 'n',
                        disabled: 'yes',
                        theme: 'action'
                    },
                    text: iget2('b-pay', 'forward-to-payment', 'Перейти к оплате')
                },
                {
                    block: 'button2',
                    theme: 'action',
                    mix: [{
                        block: 'b-pay',
                        elem: 'balance-cart-button'
                    }],
                    mods: {
                        size: 'n',
                        disabled: 'yes',
                        theme: 'action'
                    },
                    text: iget2('b-pay', 'add-to-cart', 'Добавить в корзину')
                },
                this.mods.inline !== 'yes' && !isFromWidget && {
                    block: 'button2',
                    mix: [{
                        block: 'b-pay',
                        elem: 'cancel-button'
                    }],
                    mods: {
                        size: 'n',
                        theme: 'normal'
                    },
                    text: iget2('b-pay', 'close', 'Закрыть')
                }
            ];
        })
    ),

    elem('form').content()(function() {
        return [
            {
                name: 'cmd',
                value: 'payforall'
            },
            {
                name: 'cid',
                value: this.ctx.cid
            },
            {
                name: 'csrf_token',
                value: this.data.csrf_token
            },
            this.withNds && {
                name: 'sums_with_nds',
                value: 1
            },
            this.ctx.userLogin && {
                name: 'ulogin',
                value: u.escapeHTML(this.ctx.userLogin)
            },
            {
                name: 'sum_' + this.ctx.cid,
                value: '',
                mix: [{
                    block: 'b-pay',
                    elem: 'hidden-sum'
                }]
            }
        ].map(function(el) {
            if (!el) return '';

            return {
                block: 'b-hidden',
                mix: el.mix || [],
                attrs: {
                    name: el.name,
                    value: el.value
                }
            };
        });
    }),

    mode('form-body')(function() {
        return {
            block: 'b-pay',
            elem: 'form-body',
            offerSumToPay: this.offerSumToPay,
            showRecommendations: this.showRecommendations,
            preselectRecommendation: this.ctx.preselectRecommendation,
            workCurrency: this.workCurrency,
            clientNds: this.clientNds,
            withNds: this.withNds,
            pseudo_currency: this.data.pseudo_currency,
            wallet: this.wallet,
            isOfferAccepted: this.ctx.isOfferAccepted,
            isModerationsOfferFeatureEnabled: u.consts('isModerationsOfferFeatureEnabled')
        };
    }),

    content()(function() {
        var isPageContentView = this.ctx.isPageContentView,
            formContent = {
                block: 'b-pay',
                elem: 'content-wrapper',
                content: {
                    block: 'b-pay',
                    elem: 'content',
                    elemMods: {
                        'has-balance-cart': 'no',
                        'has-close-button': !isPageContentView
                    },
                    formBody: apply('form-body'),
                    cid: this.ctx.cid,
                    userLogin: this.ctx.userLogin,
                    isOfferAccepted: this.ctx.isOfferAccepted
                }
            };
        var blockContent;

        if (isPageContentView) {
            blockContent = [formContent];
        } else {
            blockContent = [
                {
                    block: 'button',
                    mix: [
                        { block: 'b-pay', elem: 'open-popup-button' }
                    ],
                    mods: {
                        pseudo: 'yes',
                        theme: 'action',
                        disabled: this.ctx.mods.disabled ? 'yes' : '',
                        size: this.ctx.btnSize
                    },
                    content: this.ctx.btnText || iget2('b-pay', 'add-money', 'Пополнить')
                },
                {
                    block: 'popup2',
                    mix: [
                        { block: 'b-pay', elem: 'payment-popup' }
                    ],
                    mods: {
                        target: 'anchor',
                        theme: 'normal',
                        autoclosable: 'yes'
                    },
                    directions: ['right-center', 'left-center', 'top-center', 'bottom-center'],
                    hasTail: true,
                    viewportOffset: 30,
                    content: formContent
                }
            ];
        }

        blockContent.push({
            elem: 'form',
            cid: this.ctx.cid,
            userLogin: this.ctx.userLogin
        });

        return blockContent;
    }),

    elem('content').content()(function() {
        var showRecommendations = this.showRecommendations,
            yandexDomain = this.data.yandex_domain,
            showOffer = !this.ctx.isOfferAccepted && !!u.consts('isModerationsOfferFeatureEnabled') && (this.data.new_payment_workflow_enabled || u.consts('enabledChangeOfferForClientsFromTurkey'));

        return [
            {
                elem: 'popup-title',
                content: [
                    {
                        block: 'button2',
                        mods: {
                            theme: 'clear',
                            size: 's'
                        },
                        mix: [
                            { block: 'b-pay', elem: 'close-popup-button' }
                        ],
                        icon: {
                            mods: { type: 'close' }
                        }
                    },
                    {
                        block: 'b-pay',
                        elem: 'popup-header',
                        content: iget2('b-pay', 'popolnenie-obshchego-schyota', 'Пополнение счёта')
                    },
                    {
                        block: 'b-pay',
                        elem: 'popup-disclaimer',
                        content: showRecommendations ?
                            iget2('b-pay', 'popup-disclaimer-1', 'Введите сумму пополнения или выберите одну из рекомендованных. {link}', {
                                link: {
                                    block: 'link',
                                    mix: {
                                        block: 'b-pay',
                                        elem: 'payment-methods'
                                    },
                                    url: u.formatUrl({
                                        protocol: 'https',
                                        host: yandexDomain,
                                        path: 'support/direct/payments/payment-methods.html'
                                    }),
                                    target: '_blank',
                                    content: iget2('b-pay', 'payment-methods', 'Способы оплаты')
                                }
                            }) :
                            iget2('b-pay', 'popup-disclaimer-2', 'Вы можете изменить сумму пополнения или сумму платежа. {link}', {
                                link: {
                                    block: 'link',
                                    mix: {
                                        block: 'b-pay',
                                        elem: 'payment-methods'
                                    },
                                    url: u.formatUrl({
                                        protocol: 'https',
                                        host: yandexDomain,
                                        path: 'support/direct/payments/payment-methods.html'
                                    }),
                                    target: '_blank',
                                    content: iget2('b-pay', 'payment-methods', 'Способы оплаты')
                                }
                            })
                    }
                ]
            },
            this.ctx.formBody,
            showOffer && {
                block: 'b-pay',
                elem: 'common-offer',
                content: {
                    elem: 'offer-checkbox',
                    elemMods: {
                        old: !this.data.new_payment_workflow_enabled
                    },
                    newPaymentWorkflowEnabled: this.data.new_payment_workflow_enabled
                }
            },
            {
                block: 'b-pay',
                elem: 'errors'
            },
            {
                block: 'b-pay',
                elem: 'form-buttons',
                cid: this.ctx.cid,
                userLogin: this.ctx.userLogin
            }
        ];
    }),

    mod('inline', 'yes').content()(function() {
        return {
            elem: 'content-inline',
            content: [
                apply('form-body'),
                {
                    elem: 'footer'
                },
                {
                    elem: 'form-buttons',
                    cid: this.ctx.cid,
                    userLogin: this.ctx.userLogin,
                },
                {
                    elem: 'form',
                    cid: this.ctx.cid,
                    userLogin: this.ctx.userLogin
                }
            ]
        };
    }),

    elem('footer').content()(function() {
        var workCurrency = this.workCurrency;

        return [
            {
                elem: 'separator'
            },
            {
                elem: 'comment',
                content: iget2('b-pay', 'minimalnyy-platezh-s-bez', 'Минимальный платеж: {foo} без учёта НДС.', {
                    foo: u.currencies.formatSum(workCurrency, this.data.customMinPay) || u.currencies.formatConst(workCurrency, 'MIN_PAY')
                })
            }
        ];
    })
);
