/**
 *
 * @event b-pay#popup-shop popup стал виден
 * @event b-pay#bill-click клик по кнопке "Выписать счет"
 * @event b-pay#cash-click клик по кнопке "Оплатить наличными"
 *
 * @fires b-pay#popup-shop
 * @fires b-pay#bill-click
 * @fires b-pay#cash-click
 */
BEM.DOM.decl('b-pay', {

    onSetMod: {

        js: function() {
            var params = this.params,
                currency = params.currency;

            this.oldAmount = 0;

            // кэшируем элементы до того, как открылся попап
            this.elem('content');
            this.elem('errors');
            this.elem('popup-header');
            this._recommendationItemMin = this.elem('recommendation-item', 'type', 'min');
            this._recommendationSumMin = u['b-pay']._getRecommendationSum('min', currency);
            this._recommendationItemMid = this.elem('recommendation-item', 'type', 'mid');
            this._recommendationSumMid = u['b-pay']._getRecommendationSum('mid', currency);
            this._recommendationItemMax = this.elem('recommendation-item', 'type', 'max');
            this._recommendationSumMax = u['b-pay']._getRecommendationSum('max', currency);
            this._warnSum = u['b-pay']._getRecommendationSum('warn', currency);
            this._cashPayLink = this.elem('cash-pay-link');

            this._model = BEM.MODEL.create(
                { name: 'm-client-wallet' },
                {
                    customMinPay: params.customMinPay,
                    currency: params.currency,
                    clientNds: params.nds || 0,
                    sum: params.defaultSum,
                    isOfferAccepted: params.isOfferAccepted,
                    isOfferHideFeatureEnabled: params.isModerationsOfferFeatureEnabled
                }
            );

            u.graspSelf.call(this, {
                _openPopupButton: '? button on open-popup-button',
                _closePopupButton: '? button2 on close-popup-button',
                _cancelButton: '? button2 on cancel-button',
                _addToBalanceCartButton: '? button2 on balance-cart-button',
                _dropdown: '? dropdown inside',
                _commonOfferCheckbox: '? checkbox inside common-offer',
                _autopaymentOfferCheckbox: '? checkbox inside autopayment-offer-checkbox',
                _switchOffLimitOfferCheckbox: '? checkbox inside switch-off-limit-offer-checkbox',
                _tooltip: '? b-feature-marker inside tooltip-container',
                _paymentMethodsBtn: '? link on payment-methods',
                _paymentPopup: '? popup2 on payment-popup'
            });

            this._submit = this.findBlockOn('submit', 'button') || this.findBlockOn('submit', 'button2');

            this._errors = [];

            this._onErrorDebounce = $.debounce(this._onError, 100, this);

            this._model.on('error', function(e, data) {
                this._renderError(data.errors[0].text);
            }, this);

            this.clearPopup();
            this._initEvents();
            this._initClipboard();

            if (params.needOpenPopup) {
                // данный блок с модификатором new-payment-workflow инициалируется после текущего блока,
                // а это значит, что без ожидания не получится открыть попап и установить другую сумму
                setTimeout(function() {
                    var toPay = parseFloat(params.toPay),
                        promocode = params.promocode;

                    if (toPay) {
                        this._setSum(toPay);
                    }

                    this._model.set('promocode', promocode);

                    this._openPopup();
                }.bind(this), 0);
            }

            if (window.ResizeObserver && this.elem('content-wrapper')[0]) {
                this._resizeObserver = new window.ResizeObserver(function(entries) {
                    for (var i = 0; i < entries.length; i++) {
                        var entry = entries[i],
                            sizes = {};

                        if (entry.borderBoxSize && entry.borderBoxSize.length > 0) {
                            sizes = {
                                width: entry.borderBoxSize[0].inlineSize,
                                height: entry.borderBoxSize[0].blockSize
                            };
                        } else {
                            sizes = {
                                width: entry.contentRect.width,
                                height: entry.contentRect.height
                            }
                        }
                        this._sendPostMessage('resize', sizes);
                    }
                }.bind(this));

                this._resizeObserver.observe(this.elem('content-wrapper')[0]);
            }
        },

        disabled: {

            /**
             * Дизейбл контрола
             */
            yes: function() {
                this._dropdown && this._dropdown.findBlockInside('button').setMod('disabled', 'yes');
            },

            /**
             * Рздизейбл
             */
            '': function() {
                this._dropdown && this._dropdown.findBlockInside('button').delMod('disabled');
            }
        }

    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        if (this._resizeObserver) {
            this._resizeObserver.unobserve(this.elem('content')[0]);
        }
        this._subscriptionManager.dispose();
        this.__base();
    },

    /**
     * Очищает попап, выставляя значения по умолчанию и обновив состояние блокировки кнопки отправки формы
     */
    clearPopup: function() {
        this
            .setDefaults()
            .updateDisabled()
            .delMod(this.elem('content'), 'errors');
    },

    _onOfferCheckboxChange: function(e, data) {
        this._model.set('offer_agreed', data.checked);
        this.delMod(this.elem('content'), 'errors');

        this.updateDisabled();

        BEM.blocks['b-metrika2'].params({
            params: {
                payment: {
                    'offer-agreed': data.checked ? '1' : '0'
                }
            }
        });
    },

    /**
     * Выставление значений по умолчанию
     * @returns {BEM.DOM}
     */
    setDefaults: function() {
        this._model.set('sum', this.params.defaultSum, { source: this });

        return this;
    },

    /**
     * Блокирует кнопку отправки формы, если сумма не определена в модели
     * @returns {BEM.DOM}
     */
    updateDisabled: function(paymentMethod) {
        var isOfferHidden,
            isSingleLegalPayer = this._model.get('hasSingleLegalPayer'),
            payment = paymentMethod || this._model.get('payment_method');

        switch (true) {
            case payment === 'card':
            case payment === 'card-legal' && isSingleLegalPayer: {
                isOfferHidden = this.params.isModerationsOfferFeatureEnabled && !this.params.isOfferAccepted ? this._model.get('offer_agreed') : true;
                break;
            }
            default: {
                isOfferHidden = true;
                break;
            }
        }

        this._submit.setMod('disabled', isOfferHidden && this._model.get('sum') !== undefined ? '' : 'yes');

        return this;
    },

    /**
     * Подписка на события вложенных блоков button,
     * Проксирование событий вверх
     * @private
     */
    _initEvents: function() {
        var params = this.params,
            mgr = this._subscriptionManager = BEM.create('i-subscription-manager'),
            blockPopup = this._dropdown && this._dropdown._popup,
            blockBill = this._submit,
            currency = params.currency;

        mgr.on(this, 'balance-cart:first-data-loaded', this._balanceCartFirstDataLoaded);
        mgr.on(this, 'balance-cart:amount-added', this._balanceCartAmountAdded);
        mgr.on(this, 'balance-cart:add-error', this._balanceCartAddError);
        this._commonOfferCheckbox && mgr.on(this._commonOfferCheckbox, 'change', this._onOfferCheckboxChange, this);
        this._autopaymentOfferCheckbox && mgr.on(this._autopaymentOfferCheckbox, 'change', this._onOfferCheckboxChange, this);
        this._switchOffLimitOfferCheckbox && mgr.on(this._switchOffLimitOfferCheckbox, 'change', this._onOfferCheckboxChange, this);

        if (this._paymentPopup) {
            this._openPopupButton && mgr.on(this._openPopupButton, 'click', this._openPopup, this);
            this._closePopupButton && mgr.on(this._closePopupButton, 'click', this._closePopup, this);
        }

        this._cancelButton && mgr.on(this._cancelButton, 'click', this._closePopup, this);

        mgr.on(this._submit, 'click', function() {
            var goalName = 'PAY-PROF',
                sum = this._model.get('sum');

            try {
                yaCounter191494.reachGoal(goalName);
                yaCounter18641516.reachGoal(goalName);
            } catch (e) {}

            // описание события в метрике: https://st.yandex-team.ru/DIRECT-81556
            BEM.blocks['b-metrika2'].reachGoal({
                target: 'SUBMIT_PAYMENT',
                params: {
                    sum: sum,
                    currency: currency,
                    lteMin: sum <= this._recommendationSumMin ? 1 : 0,
                    lteMidGtMin: sum <= this._recommendationSumMid && sum > this._recommendationSumMin ? 1 : 0,
                    lteMaxGtMid: sum <= this._recommendationSumMax && sum > this._recommendationSumMid ? 1 : 0,
                    gtMax: sum > this._recommendationSumMax ? 1 : 0
                }
            });

            return false;
        }, this);

        this._addToBalanceCartButton && mgr.on(this._addToBalanceCartButton, 'click', this._addToBalanceCart, this);

        this._paymentMethodsBtn && mgr.on(this._paymentMethodsBtn.domElem, 'click', function() {
            var goalParams = Object.create(null);
            goalParams.URL_payment_methods_click_from_pay_popup = document.location.href;

            BEM.blocks['b-metrika2'].reachGoal({
                target: 'PAYMENT_METHODS_CLICK_FROM_PAY_POPUP',
                params: goalParams
            });
        });

        blockPopup && mgr.on(blockPopup, 'show', function() {
            this.trigger('popup-show');
            this._toggleTooltip(this._model.get('sum_with_nds'));
        }, this);

        blockBill && mgr.on(blockBill, 'click', function() {
            this.trigger('bill-click');
        }, this);

        this.bindTo(this._cashPayLink, 'click', function() {
            this.trigger('cash-click');

            // описание события в метрике: https://st.yandex-team.ru/DIRECT-81556
            BEM.blocks['b-metrika2'].reachGoal('PAY_WITH_CASH');

            this._submitPayWithCash();
        });

        this.bindTo(this._recommendationItemMin, 'click', function() {
            this._onSelectRecommendation('min');
        });

        this.bindTo(this._recommendationItemMid, 'click', function() {
            this._onSelectRecommendation('mid');
        });

        this.bindTo(this._recommendationItemMax, 'click', function() {
            this._onSelectRecommendation('max');
        });

        mgr.on(this._model, 'sum', 'change', this._onModelSumChange, this);

        if (this._warnSum) {
            mgr.on(this._model, 'sum_with_nds', 'change', function(e, data) {
                this._toggleTooltip(data.value);
            }, this);
        }

        mgr.on(this._submit, 'click', this._onSubmit, this);
    },

    _addToBalanceCart: function() {
        var amount = this._model.get('sum_with_nds');

        if (this._model.validate().valid) {
            this._addToBalanceCartButton.setMod('progress', 'yes');
            BEM.blocks['header2-balance-cart'].addAmount(amount, this.oldAmount);
        }
    },

    _deselectRecommendations: function() {
        this.setMod(this._recommendationItemMin, 'selected', '');
        this.setMod(this._recommendationItemMid, 'selected', '');
        this.setMod(this._recommendationItemMax, 'selected', '');
    },

    _selectRecommendation: function(type) {
        this.setMod(this.elem('recommendation-item', 'type', type), 'selected', 'yes');
    },

    _onSelectRecommendation: function(type) {
        var currency = this.params.currency,
            sum = u['b-pay']._getRecommendationSum(type, currency);

        this._deselectRecommendations();
        this._selectRecommendation(type);

        // описание события в метрике: https://st.yandex-team.ru/DIRECT-81556
        BEM.blocks['b-metrika2'].reachGoal({
            target: 'RECOMMENDATION_SUM_CLICK',
            params: {
                recommendationSum: sum,
                currency: currency
            }
        });

        this._setSum(sum);

        if (this.hasMod(this.elem('content'), 'errors', 'yes')) {
            this.delMod(this.elem('content'), 'errors');
        }

        this.updateDisabled();
    },

    _setSum: function(sum) {
        var tax = sum * (+this.params.nds / 100);

        this._model.set('sum', sum);
        this._model.set('nds', tax);
        this._model.set('sum_with_nds', sum + tax);
    },

    _onModelSumChange: function(event, data) {
        var type = u['b-pay']._getRecommendationType(data.value, this.params.currency);

        this._deselectRecommendations();

        if (type) {
            this._selectRecommendation(type);
        }
    },

    /**
     * Возвращает имя парного поля модели по имени указанного поля (должен быть реализован в модификаторах блока)
     * @param {String} name
     * @returns {String}
     * @protected
     */
    _getOtherName: function(name) {
        throw new Error('should be implemented in subclasses');
    },

    /**
     * Возвращает отформатированное значение для поля из модели ('0.00' если значение нельзя привести к числу)
     * @param {String} name имя поля
     * @returns {String}
     * @protected
     */
    _getValueFromModel: function(name) {
        var value = this._model.get(name);

        return isNaN(value) ? '0.00' : u.numberFormatter.format(value, { precision: 2 });
    },

    /**
     * Обработчик изменения модели (должен быть реализован в модификаторах блока)
     * @param {jQuery.Event} e
     * @param {Object} data
     * @returns {BEM.DOM}
     * @protected
     */
    _onModelChanged: function(e, data) {
        throw new Error('should be implemented in subclasses');
    },

    /**
     * Обработчик переключения поля ввода из активного состоянии и обратно (используется в модификаторе _with-nds)
     * @param {jQuery.Event} e
     * @param {Object} data
     * @returns {BEM.DOM}
     * @protected
     */
    _onInputToggle: function(e, data) {
        var name = e.data.name;

        this[name].val(this._getValueFromModel(name));

        if (data.source == this) return this;

        this[this._getOtherName(name)].toggle(false, this);

        return this;
    },

    /**
     * Обработчик изменения значения в поле ввода (используется в модификаторе _with-nds)
     * @param {jQuery.Event} e
     * @returns {BEM.DOM}
     * @protected
     */
    _onInputChange: function(e) {
        var name = e.data.name;

        if (this[name].getMod('focused') != 'yes') return this;

        var value = this[name].val().replace(/[^0-9.,]/g, '');

        this._model.set(name, u.numberFormatter.clear(value, { fail: '' }), { source: this });
        this.delMod(this.elem('content'), 'errors');

        return this.updateDisabled();
    },

    /**
     * Обработчик потери фокуса полем ввода (используется в модификаторе _with-nds)
     * @param {jQuery.Event} e
     * @returns {BEM.DOM}
     * @protected
     */
    _onInputBlur: function(e) {
        var name = e.data.name;

        this[name].val(this._getValueFromModel(name));

        return this;
    },
    /**
     * Обработчик ошибок
     * @private
     */
    _onError: function() {
        this.params.isInline ?
            BEM.blocks['b-confirm'].alert(this._errors[0]) :
            this.elem('errors').html(this._errors[0]);

        if (window.Ya && window.Ya.Rum && window.Ya.Rum.logError) {
            var rumExtra = {
                additional: {
                    text: this._errors[0]
                },
                block: 'b-pay',
                level: 'yesReallyThisIsAnError',
                type: 'validationErrorVisibleForUser'
            };

            window.Ya.Rum.logError(rumExtra, new Error(this._errors[0]));
        }

        this.setMod(this.elem('content'), 'errors', 'yes');
        this._errors = [];
    },

    /**
     * Обработчик нажатия на кнопке отправки формы
     * @protected
     */
    _onSubmit: function() {
        if (!this._model.validate().valid) {
            return;
        }

        if (!this.params.isOfferAccepted && u.consts('isModerationsOfferFeatureEnabled')) {
            u.payment.setOfferAccepted();
        }

        this._submitForm();
    },

    _submitForm: function() {
        var paymentValueField = this.hasMod('nds', 'yes') ? 'sum_with_nds' : 'sum';

        this.findBlockOn('hidden-sum', 'b-hidden').val(this._model.get(paymentValueField, 'raw'));
        this.elem('form').submit();
    },

    /**
     * Показывает или скрывает тултип в зависимости от введенной суммы
     * */
    _toggleTooltip: function(sum) {
        if (this._warnSum && sum > this._warnSum) {
            this._tooltip.show();
        }
    },

    _balanceCartFirstDataLoaded: function(data, params) {
        this._subscriptionManager.un(this, 'balance-cart:first-data-loaded', this._balanceCartFirstDataLoaded);

        var hasSinglePersonalAccount = params.hasSinglePersonalAccount,
            bPayContentElem = this.elem('content');

        // Запрещено отображать корзину без "Единого лицевого счета"
        if (!hasSinglePersonalAccount) {
            this._subscriptionManager.un(this, 'balance-cart:amount-added', this._balanceCartAmountAdded);
            return;
        }

        this.oldAmount = params.oldAmount;

        this.setMod(bPayContentElem, 'has-balance-cart', 'yes');
        this._addToBalanceCartButton.delMod('disabled');
    },

    _balanceCartAmountAdded: function(data, params) {
        this.oldAmount = params.oldAmount;
        this._resetBalaceCardProgress();

        this._finishPayment();
    },

    _balanceCartAddError: function() {
        this._resetBalaceCardProgress();

        this._renderError(iget2('b-pay', 'balance-cart-error', 'Произошла ошибка, обновите страницу и попробуйте еще раз'))
    },

    _resetBalaceCardProgress: function() {
        this._addToBalanceCartButton.setMod('progress', 'no');
        this._addToBalanceCartButton.delMod('disabled');
    },

    _renderError: function(errorText) {
        this._renderErrors([errorText]);
    },

    _renderErrors: function(errorTexts) {
        var errors = this._errors;

        errorTexts.forEach(function(errorText) {
            errors.push(errorText);
        });

        this._onErrorDebounce();
    },

    _openPopup: function() {
        this._paymentPopup.setAnchor(this._openPopupButton);
        this._paymentPopup.setMod('visible', 'yes');
    },

    _closePopup: function() {
        this._sendPostMessage('close');

        this._paymentPopup && this._paymentPopup.delMod('visible');
    },

    _finishPayment: function() {
        this._sendPostMessage('finish-payment');

        this._paymentPopup && this._closePopup();
    },

    /**
     * Отправляет сообщение родительскому окну
     * @param {String} type идентификатор сообщения
     * @param {Object} [data] дополнительные данные
     */
    _sendPostMessage: function(type, data) {
        if (!this.params.isIframeContent) {
            return;
        }

        window.parent.postMessage(JSON.stringify({
            source: 'direct-payment',
            type: type,
            data: data
        }), '*');
    },

    _submitPayWithCash: function() {
        var win,
            newCashPaymentEnabled = this.params.newCashPaymentEnabled;

        if (newCashPaymentEnabled) {
            win = window.open(this._getPayWithCashLink(), '_blank');
            win.focus();
        }
    },

    _getPayWithCashLink: function() {
        return u['b-pay']._getPayWithCashLink(this.params.cid, this._model.get('sum_with_nds'))
    }
});
