(function() {
    u.register({
        'b-pay': {
            _getErrorMessage: function(errors, currency) {
                return errors.map(function(error) {
                    switch (error.code) {
                        case 'DefectIds.PROMOCODE_DOMAIN_OR_CLIENT_DOES_NOT_MATCH':
                            return iget2(
                                'b-pay',
                                'promocode-domain-or-client-does-not-match',
                                'Указанный промокод не может быть применён. Пожалуйста, проверьте условия его активации и ограничения по использованию. {podrobnee}',
                                {
                                    // ignore bemhtml
                                    podrobnee: BEMHTML.apply({
                                        block: 'link',
                                        mods: { theme: 'white' },
                                        url: u.formatUrl({
                                            host: u.url.getRegionalDomain(),
                                            path: '/support/direct/payments/promocode.html#promocode__conditions'
                                        }),
                                        target: '_blank',
                                        content: iget2('b-pay', 'podrobnee', 'Подробнее')
                                    })
                                }
                            );
                        case 'BalanceDefectIds.INVALID_PROMO_CODE':
                            return iget2('b-pay', 'promo-code-is-not-valid', 'Промокод не найден');
                        case 'BalanceDefectIds.PROMOCODE_WRONG_CLIENT':
                            return iget2('b-pay', 'promo-code-wrong-client', 'Промокод не действителен');
                        case 'BalanceDefectIds.UNIQUE_URLS_PROMOCODE':
                            return iget2('b-pay', 'promo-code-unique-urls-required', 'Промокод не может быть использован. Ошибка в значении домена.');
                        case 'BalanceNumericDefectIds.INVALID_MINIMAL_QTY':
                            return iget2('b-pay', 'promo-code-minimal-qty-is-not-valid', 'Для применения промокода сумма платежа должна быть не менее {amount}', {
                                amount: u.currencies.formatSum(currency, error.params)
                            });
                        case 'DefectIds.MUST_BE_NULL':
                            return iget2('b-pay', 'promo-code-apply-is-not-available', 'Применение промокода сейчас невозможно');
                        case 'DefectIds.PROMOCODE_CLIENT_DOES_NOT_MATCH':
                            return iget2('b-pay', 'promo-code-client-does-not-match', 'Логин, на который применяется промокод, отличается от логина, для которого промокод выдан');
                        case 'DefectIds.PROMOCODE_CLIENT_DOMAIN_DOES_NOT_MATCH':
                            return iget2('b-pay', 'promo-code-client-domain-does-not-match', 'Домен, на который применяется промокод, отличается от домена, для которого промокод выдан');
                        case 'DefectIds.PROMOCODE_CLIENT_HAS_MULTIPLE_DOMAINS':
                            return iget2('b-pay', 'promo-code-client-has-multiple-domains', 'Промокод нельзя использовать, рекламируя несколько различных доменов');
                        default:
                            iget2('b-pay', 'unexpected-error', 'Что-то пошло не так, попробуйте еще раз позже')
                    }
                });
            },

            _getRecommendationSum: function(type, currency) {
                switch (type) {
                    case 'min':
                        return u.currencies.getConst(currency, 'RECOMMENDATION_SUM_MIN');
                    case 'mid':
                        return u.currencies.getConst(currency, 'RECOMMENDATION_SUM_MID');
                    case 'max':
                        return u.currencies.getConst(currency, 'RECOMMENDATION_SUM_MAX');
                    case 'warn':
                        return u.currencies.getConst(currency, 'RECOMMENDATION_SUM_WARN');
                    default:
                        return;
                }
            },

            _getRecommendationType: function(sum, currency) {
                var types = ['min', 'mid', 'max'],
                    i;

                for (i = 0; i < types.length; i++) {
                    if (this._getRecommendationSum(types[i], currency) === sum) {
                        return types[i];
                    }
                }
                return;
            },

            _getFormattedRecommendationSum: function(type, currency, nds) {
                var sum = this._getRecommendationSum(type, currency),
                    currencySign = u.currencies.get(currency).currency_sign;

                sum = nds ? ((+nds) / 100 + 1) * sum : sum;

                return u.numberFormatter.format(sum, { precision: 2 }) + '&nbsp' + currencySign;
            },

            _getPaymentTermMessage: function(paymentType) {
                switch (paymentType) {
                    case 'card':
                    case 'card-legal':
                    case 'cash':
                        return iget2('b-pay', 'payment-term-method-card', 'Платёж зачисляется в течение 15 минут');
                    case 'wire':
                    case 'overdraft':
                    case 'promocode':
                        return iget2('b-pay', 'payment-term-method-wire', 'Платёж зачисляется в течение 2-3 {businessDay} дней', {
                            businessDay: {
                                block: 'b-pay',
                                elem: 'business-day',
                                tag: 'span',
                                content: iget2('b-pay', 'business-day', 'рабочих')
                            }
                        });
                    default:
                        return '';
                }
            },

            _getPayWithCashLink: function(cid, sum) {
                var customerNumber = '5007' + cid;

                return u.formatUrl({
                    host: 'https://yoomoney.ru',
                    path: '/eshop.xml',
                    query: {
                        shopid: '1038',
                        scid: '1871',
                        shopArticleId: '1256',
                        paymentType: 'GP',
                        sum: sum,
                        customerNumber: customerNumber
                    }
                })
            }
        }
    })
})();
