/**
 * @param {String} perPageParamName Имя get-параметра - количества элементов на странице
 * @param {String} url Базовый урл страницы для перехода. К нему будет дописан perPageParamName со значением
 * @param {Object} pages хэш с вариантами количества элементов на странице:
 *                       в ключе - значение параметра perPageParamName, в значении - текстовое представление этого параметра
 * @param {String} onpage текущее количество элементов на странице
 */
block('b-perpage-selector')(
    def()(function() {
        this.pages = this.ctx.pages;
        this.onpage = this.ctx.onpage;

        return applyNext();
    }),

    elem('pages-selector').def()(function() {
        var pages = this.pages,
            onpage = this.onpage,
            options = [],
            attrsOption;

        for (var key in pages) {
            if (pages.hasOwnProperty(key)) {
                attrsOption = {
                    value: key
                };

                key == onpage && (attrsOption['selected'] = 'selected');

                options.push({
                    elem: 'option',
                    attrs: attrsOption,
                    content: pages[key]
                });
            }
        }
        return {
            block: 'select',
            mix: [{
                block: 'b-perpage-selector',
                elem: 'select'
            }],
            content: [
                {
                    block: 'button',
                    content: pages[onpage]
                },
                {
                    elem: 'control',
                    content: options
                }
            ]
        };
    }),

    addJs()(function() {
        return {
            url: this.ctx.url,
            perPageParamName: this.ctx.perPageParamName || 'onpage'
        };
    })
);
