BEM.DOM.decl({ block: 'b-phone-warnings-dna' }, {
    onSetMod: {
        js: function() {
            if (!window.dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            var ulogin = this.params.ulogin,
                tld = this.params.tld;

            this._renderDna(window.dna, ulogin, tld);
        }
    },

    _renderDna: function(dna, login, tld) {
        var dnaComp = dna.reactCreateElement(dna.components.PhoneWarningWrapper, {
            login: login,
            tld: tld,
            clientFeatures: u.consts('clientFeaturesAll'),
            operatorFeatures: u.consts('operatorFeaturesAll')
        }, null);

        dna.reactDOMRender(
          dnaComp,
          this.elem('content').get(0)
        );
    }
});
