block('b-phrase-adjustment')(

    elem('item')(

        tag()('tr'),

        content()(function() {
            return [
                {
                    elem: 'cell',
                    tag: 'td',
                    elemMods: {
                        type: 'checkbox'
                    },
                    content: {
                        block: 'checkbox',
                        mix: [{
                            block: 'b-checkboxes-group',
                            elem: 'item'
                        }],
                        mods: { checked: this.ctx.checked ? 'yes' : '' }
                    }
                },
                {
                    elem: 'cell',
                    tag: 'td',
                    content: [
                        {
                            elem: 'minus-word',
                            content: this.ctx.word
                        },
                        {
                            elem: 'word-forecast',
                            content: [
                                {
                                    elem: 'word-forecast-num',
                                    content: this.ctx.forecast
                                },
                                iget2('b-phrase-adjustment', 'pokazov-v-mesyac', 'показов в месяц')
                            ]
                        }
                    ],
                    elemMods: {
                        type: 'word'
                    }
                },
                {
                    elem: 'cell',
                    tag: 'td',
                    elemMods: {
                        type: 'example'
                    },
                    content: this.ctx.example
                }
            ];
        })
    ),

    content()(function() {
        return [
            {
                elem: 'info',
                content: [
                    {
                        elem: 'forecast',
                        content: [
                            iget2('b-phrase-adjustment', 'prognoz-pokazov-v-mesyac', 'Прогноз показов в месяц &ndash;'),
                            {
                                elem: 'forecast-num',
                                tag: 'span'
                            },
                            {
                                block: 'spin',
                                mods: {
                                    theme: 'gray-16'
                                },
                                mix: [{
                                    block: 'b-phrase-adjustment',
                                    elem: 'forecast-spin'
                                }]
                            }
                        ]
                    },
                    {
                        elem: 'info-text',
                        content: iget2(
                            'b-phrase-adjustment',
                            'chtoby-utochnit-klyuchevuyu-frazu',
                            'Чтобы уточнить ключевую фразу, отметьте нужные минус-слова.'
                        )
                    },
                    {
                        elem: 'info-text',
                        mix: { block: 'b-phrase-adjustment', elem: 'minus-words-hint' },
                        content: iget2(
                            'b-phrase-adjustment',
                            'dobavlenie-minus-slova-k',
                            'Добавление минус-слова к фразе исключает показ объявления по всем запросам, содержащим это слово.'
                        )
                    },
                    {
                        elem: 'empty',
                        content: [
                            {
                                block: 'icon',
                                mods: {
                                    'size-13': 'alert'
                                },
                                mix: [{
                                    block: 'b-phrase-adjustment',
                                    elem: 'empty-icon'
                                }]
                            },
                            iget2(
                                'b-phrase-adjustment',
                                'na-osnovanii-statistiki-poiskovyh',
                                'На основании статистики поисковых запросов нет возможности уточнить данную ключевую фразу добавлением минус-слов.'
                            )
                        ]
                    },
                    {
                        block: 'spin',
                        mods: {
                            theme: 'gray-16'
                        },
                        mix: [{
                            block: 'b-phrase-adjustment',
                            elem: 'open-spin'
                        }]
                    }
                ]
            },
            {
                elem: 'minus-words-container',
                mix: {
                    block: 'b-checkboxes-group',
                    mods: {
                        mode: 'checkbox'
                    }
                },
                content: [
                    {
                        elem: 'table',
                        elemMods: {
                            header: 'yes'
                        },
                        tag: 'table',
                        content: {
                            tag: 'tr',
                            content: [
                                {
                                    elem: 'cell',
                                    tag: 'td',
                                    elemMods: {
                                        type: 'checkbox'
                                    },
                                    content: {
                                        block: 'checkbox',
                                        mix: [{
                                            block: 'b-checkboxes-group',
                                            elem: 'item'
                                        }]
                                    }
                                },
                                {
                                    tag: 'td',
                                    elem: 'cell',
                                    elemMods: {
                                        type: 'word'
                                    },
                                    content: iget2('b-phrase-adjustment', 'minus-slovo', 'Минус-слово')
                                },
                                {
                                    tag: 'td',
                                    elem: 'cell',
                                    elemMods: {
                                        type: 'example'
                                    },
                                    content: iget2('b-phrase-adjustment', 'primery-zaprosov-s-minus', 'Примеры запросов с минус-словом')
                                }
                            ]
                        }
                    },
                    {
                        elem: 'scrollpane',
                        content: [
                            {
                                tag: 'table',
                                elem: 'table',
                                content: [
                                    {
                                        tag: 'tbody',
                                        elem: 'minus-words'
                                    },
                                    {
                                        tag: 'tfoot',
                                        elem: 'load-more',
                                        content: [
                                            {
                                                tag: 'td',
                                                elem: 'cell',
                                                attrs: {
                                                    colspan: 3
                                                },
                                                content: {
                                                    block: 'button',
                                                    type: 'button',
                                                    mix: [{
                                                        block: 'b-phrase-adjustment',
                                                        elem: 'load-more-btn'
                                                    }],
                                                    content: iget2('b-phrase-adjustment', 'zagruzit-eshchyo', 'Загрузить ещё')
                                                }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                block: 'spin',
                                mods: {
                                    theme: 'gray-16'
                                },
                                mix: [{
                                    block: 'b-phrase-adjustment',
                                    elem: 'minus-words-spin'
                                }]
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
