BEM.DOM.decl('b-phrase-adjustment', {
    onSetMod: {
        js: function() {

            this.loadMore = this.findBlockOn(this.elem('load-more-btn'), 'button')
                .on('click', this._onLoadMoreClick, this);

            this._updateModelFromCheckboxesDebounce = $.debounce(function() {
                this._updateModelFromCheckboxes.apply(this);
            }, 100);

            //Хэш с вариантами разных словоформ от нормализованного
            this.normForms = {};

            //загруженные с сервера минус-слова
            this._loadedMinusWords = [];

            // все три запроса посылать одним request то будут некорректно срабатывать коллбэки
            ['_requestPhraseStat', '_requestRefineMinusWords', '_requestNormWords'].forEach(function(name) {
                this[name] = BEM.create('i-request_type_ajax', {
                    url: '/registered/main.pl',
                    dataType: 'json',
                    type: 'POST',
                    callbackCtx: this
                });
            }, this);

            this._setDebouncedFunctions();
        },

        'forecast-loading': function(modName, modVal) {
            if (!this.forecastSpin) this.forecastSpin = this.findBlockOn('forecast-spin', 'spin');
            this.forecastSpin.setMod('progress', modVal == 'yes' ? 'yes' : 'no');
        },

        'minus-words-loading': function(modName, modVal) {
            if (!this.minusWordsSpin) this.minusWordsSpin = this.findBlockOn('minus-words-spin', 'spin');
            this.minusWordsSpin.setMod('progress', modVal == 'yes' ? 'yes' : 'no');
        },

        'first-open': function(modName, modVal) {
            if (!this.firstOpenSpin) this.firstOpenSpin = this.findBlockOn('open-spin', 'spin');
            this.firstOpenSpin.setMod('progress', modVal == 'yes' ? 'yes' : 'no');
        }
    },

    setMinusWordsHint: function(text) {
        this.elem('minus-words-hint').text(text);
    },

    /**
     * Устанавливает debounce-функции для функций, загружающих данные
     * @private
     */
    _setDebouncedFunctions: function() {
         // таймаут для $.debounce (см. http://habrahabr.ru/post/60957/)
        // по которому ходим на сервер за новым прогнозом и новыми минус-словами
        var LOADING_TIMEOUT = 500;

        this._loadForecastDebounce = $.debounce(this._loadForecast, LOADING_TIMEOUT, this);
        this._loadNormFormsDebounce = $.debounce(this._loadNormForms, LOADING_TIMEOUT, this);
    },

    /**
     * Возвращает группу чекбоксов для минус-слов
     * @param {Object} [options]
     * @param {Boolean} [options.dropCache]
     * @returns {Array}
     * @private
     */
    _getCheckboxesGroup: function(options) {
        var dropCache = options && options.dropCache;

        if (this._checkboxesGroup) return dropCache ? this._checkboxesGroup.rearrange() : this._checkboxesGroup;

        //инициализируем группу чекбоксов для минус слов
        this._checkboxesGroup = this.findBlockInside('b-checkboxes-group')
            .on('change', this._updateModelFromCheckboxesDebounce, this);

        return this._checkboxesGroup;
    },

    /**
     * Инициализирует стартовые данные блока уточнения ключевиков в соответствие с попапом-родителем
     * @param {BEM} parent - блок-родитель b-phrase-popup
     */
    attach: function(parent) {
        this
            .setMod('has-more', 'no')
            .delMod('empty')
            .delMod('has-words');

        this._clearMinusWordsList();
        this.bannersGroupModel = parent.bannersGroupModel;

        this.geoModel = this.bannersGroupModel.getGeoModel();
        this.campaignModel = this.bannersGroupModel.getCampaignModel();

        this.editPhraseModel = parent.editPhraseModel
            .on('key_words', 'change', this._onKeyWordsChanged, this)
            .on('minus_words', 'change', this._onMinusWordsChanged, this);

        this._onKeyWordsChanged();
    },

    /**
     * Возвращает гео-код строкой
     * @returns {String}
     * @private
     */
    _getGeo: function() {
        return this.geoModel.get('geo');
    },

    /**
     * Очищает блок с ключевыми словами
     * @returns {BEM}
     * @private
     */
    _clearMinusWordsList: function() {
        this._loadedMinusWords = [];
        BEM.DOM.destruct(this.elem('minus-words'), true);

        return this;
    },

    /**
     *  Отсоединяет попап-родитель
     */
    detach: function() {
        this.editPhraseModel
            .un('key_words', 'change')
            .un('minus_words', 'change');

    },

    /**
     * Устанавливает прогноз показов в __forecast-num
     * @param {Number} hits
     */
    _onForecastLoaded: function(hits) {
        this.setMod('forecast-loading', 'no').elem('forecast-num').text(hits);
    },

    /**
     * Полный спислок минус-слов на фразу
     * @returns String[] - массив минус-слов
     * @private
     */
    _getGeneralMinusWords: function() {
        return this.bannersGroupModel.get('minus_words').concat(this.campaignModel.get('minus_words'));
    },

    /**
     * Загружает прогноз по показам для данной ключевой фразы и региона
     * @private
     */
    _loadForecast: function() {
        var geo = this._getGeo(),
            phrase = this.editPhraseModel.get('phrase'),
            //DIRECT-62855 - учитываем минус-слова в прогнозе
            minusWords = this._getGeneralMinusWords(),
            campaignType = this.bannersGroupModel.get('camp_type'),
            contentPromotionType = this.bannersGroupModel.get('content_promotion_content_type');

        this._requestPhraseStat.get({
            cmd: 'ajaxPhraseStat',
            is_mobile: campaignType === 'mobile_content' ? 1 : undefined,
            video_advq: contentPromotionType === 'video' ? 1 : undefined,
            collections_advq: contentPromotionType === 'collection' ? 1 : undefined,
            geo: geo,
            w1: phrase,
            json_mw1: JSON.stringify(minusWords)
        }, function(hits) {
            this._onForecastLoaded(hits);
        });
    },

    /**
     * Произошел клик по ссылке "загрузить ещё"
     * @private
     */
    _onLoadMoreClick: function() {
        this._loadMinusWords(true);
    },

    /**
     * Загружает минус-слова для данной фразы
     * @param {Boolean} [loadMore]
     * @returns {*}
     * @private
     */
    _loadMinusWords: function(loadMore) {
        var geo = this._getGeo(),
            keyWords = this.editPhraseModel.get('key_words'),
            phraseMinusWords = this.editPhraseModel.get('minus_words') || [],
            generalMinusWords = this._getGeneralMinusWords(),
            campaignType = this.bannersGroupModel.get('camp_type'),
            contentPromotionType = this.bannersGroupModel.get('content_promotion_content_type');

        if (!loadMore) this._clearMinusWordsList();

        this
            .setMod(loadMore ? 'minus-words-loading' : 'first-open', 'yes')
            .delMod('empty');

        loadMore || this.delMod('has-words');

        this._requestRefineMinusWords.get({
            cmd: 'ajaxRefineMinusWords',
            geo: geo,
            is_mobile: campaignType === 'mobile_content' ? 1 : undefined,
            video_advq: contentPromotionType === 'video' ? 1 : undefined,
            collections_advq: contentPromotionType === 'collection' ? 1 : undefined,
            phrase: keyWords + ' ' + u.minusWords.arrayToString([].concat(phraseMinusWords, this._loadedMinusWords)),
            json_minus_words: JSON.stringify(generalMinusWords)
        }, function(data) {
            data.words.forEach(function(wordData) {
                this.normForms[wordData.word] || (this.normForms[wordData.word] = []);
                this.normForms[wordData.word].push(wordData.word);
            }, this);
            this.setMod(loadMore ? 'minus-words-loading' : 'first-open', 'no');
            !loadMore && this._clearMinusWordsList();
            this._buildMinusWordsList(data);
            //this._updateCustomMinusWords();
        });
    },

    /**
     * Возвращает список минус-слов, сохраненных в модели фразы
     * @returns {Array}
     * @private
     */
    _getMinusWordsFromModel: function() {
        return this.editPhraseModel.get('minus_words');
    },

    /**
     *  Загружает базовые словоформы для имеющихся минус-слов
     *  @private
     */
    _loadNormForms: function() {
        var unknownNormForms = [];

        this._getMinusWordsFromModel().map(function(word) {
            !this.normForms[word] && unknownNormForms.push(word);
        }, this);

        this._requestNormWords.get({
            cmd: 'ajaxNormWords',
            words: $.trim(unknownNormForms.join(' '))
        }, function(words) {
            Object.keys(words).map(function(form) {
                this.normForms[form] = (this.normForms[form] || []).concat(words[form] || []);
            }, this);
        });
    },

    /**
     * Строит и применяет к DOM список минус-слов
     * @param {Object} data
     * @private
     */
    _buildMinusWordsList: function(data) {
        var views = [];

        data.words && data.words.map(function(item) {
            views.push(BEMHTML.apply({
                block: 'b-phrase-adjustment',
                elem: 'item',
                word: '-' + item.word,
                checked: this._isMinusWordSelected(item.word),
                //показываем первые 5 примеров из пришедшего массива
                example: item.phrases.slice(0, 5).join(', '),
                forecast: item.exact_cnt || item.cnt
            }));

            this._loadedMinusWords.push(item.word);
        }, this);

        if (views.length > 0) {
            BEM.DOM.append(this.elem('minus-words'), views.join(''));
        }
        this._getCheckboxesGroup({ dropCache: true });

        var empty = !data.has_more && this._loadedMinusWords.length == 0;

        this
            .setMod('has-more', data.has_more ? 'yes' : 'no')
            .setMod('empty', empty ? 'yes' : 'no')
            .setMod('has-words', !empty ? 'yes' : 'no');
    },

    /**
     * Обновляет поле minus_words в модели на основании состояния чекбокса
     * @private
     */
    _updateModelFromCheckboxes: function() {
        var minusWords = [].concat(this._getMinusWordsFromModel());

        //@heliarian todo пробросить _getCheckboxes -> getCheckboxes
        this._checkboxesGroup._getCheckboxes().forEach(function(cbx, i) {
            var minusWord = this._loadedMinusWords[+i],
                index = minusWords.indexOf(minusWord);

            if (index == -1 && cbx.isChecked()) {
                minusWords.push(minusWord);
            } else if (index !== -1 && !cbx.isChecked()) {
                minusWords.splice(index, 1)
            }
        }, this);

        this.editPhraseModel.set('minus_words', minusWords, { source: this, from: 'checkbox' });
    },

    /**
     * Возвращает true, если слово word уже было выбрано в качестве минус-слова и сохранено в модели
     * @param {String} word
     * @returns {boolean}
     * @private
     */
    _isMinusWordSelected: function(word) {
        var minusWords = this._getMinusWordsFromModel();

        return minusWords.indexOf(word) !== -1 || minusWords.indexOf(this.normForms[word]) !== -1;
    },

    /**
     * Предзагрузка прогноза показов
     * @param {Boolean} [invokeAsap] — немедленно вызывает загрузку прогнозов
     * @private
     */
    _preLoadForecast: function(invokeAsap) {
        this.setMod('forecast-loading', 'yes');

        invokeAsap ?
            this._loadForecast() :
            this._loadForecastDebounce();
    },

    /**
     * Обновляет галки на чекбоксах у минус слов в соответствии со значением модели
     * @returns {*}
     * @private
     */
    _updateCheckboxesFromModel: function() {
        var checkboxesList = this._getCheckboxesGroup().getCheckboxes(),
            word;

        checkboxesList.map(function(cbx, index) {
            word = this._loadedMinusWords[index];

            cbx.setMod('checked', this._isMinusWordSelected(word) ? 'yes' : '');
        }, this);

        return this;
    },

    /**
     * Обработчик события на изменение минус-слов
     * this.editPhraseModel.on('minus_words', 'change')
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onMinusWordsChanged: function(e, data) {
        this._preLoadForecast(data && data.from === 'checkbox');

        if (!(data && data.source == this || this.getMod('minus-words-loading') == 'yes')) {
            this._updateCheckboxesFromModel();
        }

        return this;
    },

    /**
     * Обработчик события на изменение ключевых слов
     * this.editPhraseModel.on('key_words', 'change')
     * @private
     */
    _onKeyWordsChanged: function() {
        this._loadNormFormsDebounce();
        this._preLoadForecast();
        this._loadMinusWords();
    }
}, {

});
