block('b-phrase-key-words')(
    tag()('span'),

    content()(function() {
        var MAX_WORD_LENGTH = 40,
            fixOn = this.ctx.phrase.key_words_fix_on,
            fixOff = this.ctx.phrase.key_words_fix_off,
            hellipCutFunc = function(str) {
                return u.hellipCut(str, MAX_WORD_LENGTH, '...');
            },
            prepareString = function(str) {
                if (!str) return str;

                var splitRes = str.split(' '),
                    length = splitRes.length;

                return str.split(' ').map(function(word, i) {
                    var res = word.match('#(.*)#');

                    if (res) {
                        return {
                            block: 'b-phrase-key-words',
                            elem: 'fixation',
                            content: [
                                res[1].split('&').map(function(resPart) {
                                    return u.escapeHTML(hellipCutFunc(resPart))
                                }).join(' '),
                                (i < length) && ' '
                            ]
                        };
                    }
                    return [
                        u.escapeHTML(hellipCutFunc(word)),
                        (i < length) && ' '
                    ];
                });
            };

        if (!fixOn || !fixOff) {
            return prepareString(this.ctx.phrase.key_words);
        }

        this.ctx.phrase.fixation.forEach(function(fix) {
            //todo - могут ли быть в fix[0] и fix[1] другие выражения, которые надо экранировать?
            fixOn = fixOn.replace(
                new RegExp('(^|\\s)' + fix[0].replace('+', '\\+') + '($|\\s)', 'g'),
                '$1#' + fix[0].replace(/\s/g, '&') + '#$2');
            fixOff = fixOff.replace(
                new RegExp('(^|\\s)' + fix[1] + '($|\\s)', 'g'),
                '$1#' + fix[1].replace(/\s/g, '&') + '#$2');
        });

        return [
            {
                elem: 'key-words-fix-on',
                tag: 'span',
                content: prepareString(fixOn)
            },
            {
                elem: 'key-words-fix-off',
                tag: 'span',
                content: prepareString(fixOff)
            }
        ];
    })
);
