BEM.DOM.decl('b-phrase-key-words', {
    init: function(model) {
        this.phraseModel = model;

        this.bindEvents({ isBind: true });
    },

    /**
     *
     * @param {Object} options
     * @param {Boolean} options.isBind
     * @returns {BEM}
     */
    bindEvents: function(options) {
        this.phraseModel &&
            this.phraseModel[options.isBind ? 'on' : 'un']('stopword_fixated', 'change', function() {
                this.domElem &&
                    this.setMod('fixation', this.phraseModel.get('stopword_fixated') ? 'on' : 'off')
            }, this);

        return this;
    },

    destruct: function() {
        this.bindEvents({ isBind: false });

        return this.__base.apply(this, arguments);
    }
});
