BEM.DOM.decl('b-phrase-minus-words-popup', {
    onSetMod: {
        js: function() {
            //кэшируем элементы
            this.elem('content');
            this.elem('key-words-wrapper');
            this.elem('minus-words-wrapper');
        }
    },

    getPopup: function() {
        return this.popup || (this.popup = this.findBlockInside('popup'));
    },

    show: function(parent, model, bannerMinusWords, campaignMinusWords) {
        var content = this.elem('content');

        this.phraseModel = model;
        this.parent = parent;

        // для автотаргетинга убираем раздел про фразу и минус-слова на фразы
        if (model.name == 'm-relevance-match') {
            this.setMod(this.elem('block', 'block-type', 'phrase'), 'hidden', 'yes')
        } else {
            this.setMod(this.elem('block', 'block-type', 'phrase'), 'hidden', '');

            BEM.DOM.update(this.elem('key-words-wrapper'), BEMHTML.apply({
                block: 'b-phrase-key-words',
                phrase: this.phraseModel.toJSON(),
                isFullLength: 1,
                mods: { fixation: this.phraseModel.get('stopword_fixated') ? 'on' : 'off' }
            }));

            this.findBlockInside(content, 'b-phrase-key-words');

            BEM.DOM.update(this.elem('minus-words-wrapper'), BEMHTML.apply({
                block: 'b-phrase-minus-words',
                phrase: this.phraseModel.toJSON(),
                mods: { unglued: this.phraseModel.get('unglued') ? 'on' : 'off' }
            }));
        }

        this
            .setMod(content, 'has-campaign', campaignMinusWords.length ? 'yes' : '')
            .setMod(content, 'has-banner', bannerMinusWords.length ? 'yes' : '');

        if (this.elem('banner-minus-words').length) {
            BEM.DOM.update(this.elem('banner-minus-words'), u.escapeHTML(u.minusWords.arrayToString(bannerMinusWords)));
        }
        if (this.elem('campaign-minus-words').length) {
            BEM.DOM.update(
                this.elem('campaign-minus-words'),
                u.escapeHTML(u.minusWords.arrayToString(campaignMinusWords))
            );
        }

        this.getPopup().show(parent);

        return this;
    },

    toggle: function(parent, model, bannerMinusWords, campaignMinusWords) {
        if (parent && parent == this.parent && this.isShown()) return this.hide();

        return this.show(parent, model, bannerMinusWords, campaignMinusWords)
    },

    /**
     * Показываем попап с минус словами для фразы
     * @returns {BEM}
     */
    hide: function() {
        this.getPopup().hide();

        return this;
    },

    /**
     * Видим ли данный попап
     * @returns {Boolean}
     */
    isShown: function() {
        return this.getPopup().isShown();
    }

}, {

});
