BEM.DOM.decl('b-phrase-minus-words', {
    init: function(model) {
        this.phraseModel = model;
        this.bindEvents({ isBind: true });
    },

    /**
     * Привязка событий к модели
     * @param {Object} data
     * @param {Boolean} data.isBind
     * @returns {BEM}
     */
    bindEvents: function(data) {
        this.phraseModel[data.isBind ? 'on' : 'un']('unglued', 'change', function() {
            this.setMod('unglued', this.phraseModel.get('unglued') ? 'on' : 'off')
        }, this);

        return this;
    },

    /**
     * Срабатывает при уничтожении блока
     * @returns {BEM}
     */
    destruct: function() {
        this.bindEvents({ isBind: false });

        return this;
    }

}, {

});
